/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenAndChildBasedNode;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;
import org.netbeans.modules.cnd.debug.DebugUtils;

public abstract class APTIfConditionBaseNode
extends APTTokenAndChildBasedNode
implements Serializable {
    private static final long serialVersionUID = 1068728941146083839L;
    private List<APTToken> condition;
    private int endOffset;

    APTIfConditionBaseNode(APTIfConditionBaseNode orig) {
        super(orig);
        this.condition = orig.condition;
        this.endOffset = orig.getEndOffset();
    }

    protected APTIfConditionBaseNode() {
    }

    protected APTIfConditionBaseNode(APTToken token) {
        super(token);
    }

    @Override
    public String getText() {
        String text = super.getText();
        String condStr = this.condition != null ? APTUtils.debugString(this.getCondition()) : "<no condition>";
        return text + " CONDITION{" + condStr + "}";
    }

    public TokenStream getCondition() {
        return this.condition != null ? new ListBasedTokenStream(this.condition) : APTUtils.EMPTY_STREAM;
    }

    @Override
    public boolean accept(APTFile curFile, APTToken token) {
        assert (token != null);
        int ttype = token.getType();
        assert (!APTUtils.isEOF(ttype)) : "EOF must be handled in callers";
        if (APTUtils.isEndDirectiveToken(ttype)) {
            this.endOffset = token.getOffset();
            if (this.condition == null) {
                if (DebugUtils.STANDALONE) {
                    System.err.printf("%s, line %d: %s with no expression\n", APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.getToken().getText().trim());
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: {2} with no expression", new Object[]{APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.getToken().getText().trim()});
                }
            }
            if (this.condition != null) {
                ((ArrayList)this.condition).trimToSize();
            }
            return false;
        }
        if (!APTUtils.isCommentToken(ttype)) {
            if (this.condition == null) {
                this.condition = new ArrayList<APTToken>();
            }
            this.condition.add(token);
        }
        return true;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }
}

