/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExceptionBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private static final String HELP_ID = "debug.add.breakpoint.java.exception";
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private ExceptionBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JTextField tfExceptionClassName;
    private JPanel cPanel;
    private JComboBox cbBreakpointType;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;

    private static ExceptionBreakpoint creteBreakpoint() {
        String string;
        try {
            string = EditorContextBridge.getMostRecentClassName();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            string = "";
        }
        ExceptionBreakpoint exceptionBreakpoint = ExceptionBreakpoint.create((String)string, (int)3);
        exceptionBreakpoint.setPrintText(NbBundle.getBundle(ExceptionBreakpointPanel.class).getString("CTL_Exception_Breakpoint_Print_Text"));
        return exceptionBreakpoint;
    }

    public ExceptionBreakpointPanel() {
        this(ExceptionBreakpointPanel.creteBreakpoint());
        this.createBreakpoint = true;
    }

    public ExceptionBreakpointPanel(ExceptionBreakpoint exceptionBreakpoint) {
        this.breakpoint = exceptionBreakpoint;
        this.initComponents();
        String string = exceptionBreakpoint.getExceptionClassName();
        ResourceBundle resourceBundle = NbBundle.getBundle(ExceptionBreakpointPanel.class);
        String string2 = resourceBundle.getString("TTT_TF_Field_Breakpoint_Class_Name");
        this.tfExceptionClassName = ClassBreakpointPanel.addClassNameEditor(this.pSettings, string, string2);
        this.tfExceptionClassName.setToolTipText(string2);
        this.tfExceptionClassName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_Method_Breakpoint_ClassName"));
        this.tfExceptionClassName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Exception_Breakpoint_ClassName"));
        HelpCtx.setHelpIDString((JComponent)this.tfExceptionClassName, (String)HELP_ID);
        this.jLabel3.setLabelFor(this.tfExceptionClassName);
        this.cbBreakpointType.addItem(resourceBundle.getString("LBL_Exception_Breakpoint_Type_Catched"));
        this.cbBreakpointType.addItem(resourceBundle.getString("LBL_Exception_Breakpoint_Type_Uncatched"));
        this.cbBreakpointType.addItem(resourceBundle.getString("LBL_Exception_Breakpoint_Type_Catched_or_Uncatched"));
        switch (exceptionBreakpoint.getCatchType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.conditionsPanel.setupConditionPaneContext();
        this.conditionsPanel.showClassFilter(true);
        this.conditionsPanel.showCondition(true);
        this.conditionsPanel.setClassMatchFilter(exceptionBreakpoint.getClassFilters());
        this.conditionsPanel.setClassExcludeFilter(exceptionBreakpoint.getClassExclusionFilters());
        this.conditionsPanel.setCondition(exceptionBreakpoint.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(exceptionBreakpoint.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(exceptionBreakpoint.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)exceptionBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", HELP_ID);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointExceptionJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Exception_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("L_Exception_Breakpoint_Class_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Exception_Breakpoint_Class_Name"));
        this.jLabel4.setLabelFor(this.cbBreakpointType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)resourceBundle.getString("L_Exception_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ASCD_L_Exception_Breakpoint_Type"));
        this.cbBreakpointType.setToolTipText(resourceBundle.getString("TTT_CB_Exception_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CB_Exception_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExceptionBreakpointPanel.class, (String)"ACSN_ExceptionBreakpoint"));
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string == null) {
            string = this.conditionsPanel.valiadateMsg();
        }
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        String string2 = this.tfExceptionClassName.getText().trim();
        this.breakpoint.setExceptionClassName(string2);
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setCatchType(1);
                break;
            }
            case 1: {
                this.breakpoint.setCatchType(2);
                break;
            }
            case 2: {
                this.breakpoint.setCatchType(3);
            }
        }
        this.breakpoint.setClassFilters(this.conditionsPanel.getClassMatchFilter());
        this.breakpoint.setClassExclusionFilters(this.conditionsPanel.getClassExcludeFilter());
        this.breakpoint.setCondition(this.conditionsPanel.getCondition());
        this.breakpoint.setHitCountFilter(this.conditionsPanel.getHitCount(), this.conditionsPanel.getHitCountFilteringStyle());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private String valiadateMsg() {
        if (this.tfExceptionClassName.getText().trim().length() == 0) {
            return NbBundle.getMessage(ExceptionBreakpointPanel.class, (String)"MSG_No_Exception_Class_Name_Spec");
        }
        return null;
    }
}

