/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.node.ColumnNameProvider;
import org.netbeans.modules.db.explorer.node.ColumnNode;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.netbeans.modules.db.explorer.node.ViewNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class QueryAction
extends BaseAction {
    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes.length == 1) {
            Lookup lookup = activatedNodes[0].getLookup();
            result = lookup.lookup(TableNode.class) != null || lookup.lookup(ViewNode.class) != null || lookup.lookup(ColumnNode.class) != null;
        } else {
            result = true;
            for (Node node : activatedNodes) {
                if (node.getLookup().lookup(ColumnNode.class) != null) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean appendQualifiedName(StringBuilder tableNameBuilder, SQLIdentifiers.Quoter quoter, String name, String authenticatedName, boolean tableIsQualified) {
        if (name != null && (tableIsQualified || !name.equals(authenticatedName))) {
            tableNameBuilder.append(quoter.quoteIfNeeded(name));
            tableNameBuilder.append('.');
            return true;
        }
        return tableIsQualified;
    }

    private String getQualifiedTableName(String simpleTableName, DatabaseConnection connection, SchemaNameProvider provider, SQLIdentifiers.Quoter quoter) throws SQLException {
        String schemaName = provider.getSchemaName();
        String catName = provider.getCatalogName();
        StringBuilder fullTableName = new StringBuilder();
        boolean tableIsQualified = false;
        tableIsQualified = this.appendQualifiedName(fullTableName, quoter, catName, connection.getConnection().getCatalog(), tableIsQualified);
        tableIsQualified = this.appendQualifiedName(fullTableName, quoter, schemaName, null, tableIsQualified);
        fullTableName.append(quoter.quoteIfNeeded(simpleTableName));
        return fullTableName.toString();
    }

    protected String getDefaultQuery(Node[] activatedNodes) {
        DatabaseConnection connection = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
        try {
            boolean isColumn;
            DatabaseMetaData dmd = connection.getConnection().getMetaData();
            SQLIdentifiers.Quoter quoter = SQLIdentifiers.createQuoter(dmd);
            SchemaNameProvider provider = (SchemaNameProvider)activatedNodes[0].getLookup().lookup(SchemaNameProvider.class);
            boolean bl = isColumn = activatedNodes[0].getLookup().lookup(ColumnNode.class) != null;
            if (!isColumn) {
                String onome = this.getQualifiedTableName(activatedNodes[0].getName(), connection, provider, quoter);
                return "select * from " + onome;
            }
            String parentName = ((ColumnNameProvider)activatedNodes[0].getLookup().lookup(ColumnNameProvider.class)).getParentName();
            String onome = this.getQualifiedTableName(parentName, connection, provider, quoter);
            StringBuilder cols = new StringBuilder();
            for (Node node : activatedNodes) {
                if (cols.length() > 0) {
                    cols.append(", ");
                }
                cols.append(quoter.quoteIfNeeded(node.getName()));
            }
            return "select " + cols.toString() + " from " + onome;
        }
        catch (SQLException ex) {
            String message = NbBundle.getMessage(QueryAction.class, (String)"ShowDataError", (Object)ex.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            return "";
        }
    }
}

