/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

final class J2eeVersionWarningPanel
extends JPanel {
    public static final String WARN_SET_JDK_14 = "warnSetJdk14";
    public static final String WARN_SET_JDK_15 = "warnSetJdk15";
    public static final String WARN_SET_SOURCE_LEVEL_14 = "warnSetSourceLevel14";
    public static final String WARN_SET_SOURCE_LEVEL_15 = "warnSetSourceLevel15";
    private String warningType;
    private String javaPlatformName;
    private JCheckBox downgradeJdk14CheckBox;
    private JCheckBox downgradeJdk15CheckBox;
    private JCheckBox downgradeSourceLevel14CheckBox;
    private JCheckBox downgradeSourceLevel15CheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel setJdk14Panel;
    private JPanel setJdk15Panel;
    private JPanel setSourceLevel14Panel;
    private JPanel setSourceLevel15Panel;
    private JLabel warningJdk14Label;
    private JLabel warningSourceLevel14Label;

    public J2eeVersionWarningPanel(String string) {
        this.initComponents();
        this.setWarningType(string);
    }

    public String getWarningType() {
        return this.warningType;
    }

    public void setWarningType(String string) {
        this.warningType = string;
        this.setJdk14Panel.setVisible(false);
        this.setSourceLevel14Panel.setVisible(false);
        this.setJdk15Panel.setVisible(false);
        this.setSourceLevel15Panel.setVisible(false);
        if (WARN_SET_JDK_14.equals(string)) {
            this.setJdk14Panel.setVisible(true);
            this.downgradeJdk14CheckBox.setSelected(UserProjectSettings.getDefault().isAgreedSetJdk14());
        } else if (WARN_SET_SOURCE_LEVEL_14.equals(string)) {
            this.setSourceLevel14Panel.setVisible(true);
            this.downgradeSourceLevel14CheckBox.setSelected(UserProjectSettings.getDefault().isAgreedSetSourceLevel14());
        } else if (WARN_SET_JDK_15.equals(string)) {
            this.setJdk15Panel.setVisible(true);
            this.downgradeJdk15CheckBox.setSelected(UserProjectSettings.getDefault().isAgreedSetJdk15());
        } else if (WARN_SET_SOURCE_LEVEL_15.equals(string)) {
            this.setSourceLevel15Panel.setVisible(true);
            this.downgradeSourceLevel15CheckBox.setSelected(UserProjectSettings.getDefault().isAgreedSetSourceLevel15());
        }
    }

    public boolean getDowngradeAllowed() {
        if (WARN_SET_JDK_14.equals(this.warningType)) {
            return this.downgradeJdk14CheckBox.isSelected();
        }
        if (WARN_SET_SOURCE_LEVEL_14.equals(this.warningType)) {
            return this.downgradeSourceLevel14CheckBox.isSelected();
        }
        if (WARN_SET_JDK_15.equals(this.warningType)) {
            return this.downgradeJdk15CheckBox.isSelected();
        }
        if (WARN_SET_SOURCE_LEVEL_15.equals(this.warningType)) {
            return this.downgradeSourceLevel15CheckBox.isSelected();
        }
        return false;
    }

    public String getSuggestedJavaPlatformName() {
        JavaPlatform[] javaPlatformArray;
        if (this.javaPlatformName == null && WARN_SET_JDK_14.equals(this.warningType)) {
            javaPlatformArray = J2eeVersionWarningPanel.getJavaPlatforms("1.4");
            this.javaPlatformName = javaPlatformArray[0].getDisplayName();
        }
        if (this.javaPlatformName == null && WARN_SET_JDK_15.equals(this.warningType)) {
            javaPlatformArray = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            this.javaPlatformName = javaPlatformArray[0].getDisplayName();
        }
        return this.javaPlatformName;
    }

    public static String findWarningType(Profile profile) {
        JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        String string = specificationVersion.toString();
        if (string.equals("1.6") || string.equals("1.7")) {
            string = "1.5";
        }
        if (new SpecificationVersion("1.4").equals((Object)specificationVersion) && profile == Profile.J2EE_14) {
            return null;
        }
        if ("1.5".equals(string) && profile == Profile.JAVA_EE_5) {
            return null;
        }
        if (profile == Profile.J2EE_14) {
            JavaPlatform[] javaPlatformArray = J2eeVersionWarningPanel.getJavaPlatforms("1.4");
            if (javaPlatformArray.length > 0) {
                return WARN_SET_JDK_14;
            }
            return WARN_SET_SOURCE_LEVEL_14;
        }
        if (profile == Profile.JAVA_EE_5) {
            JavaPlatform[] javaPlatformArray = J2eeVersionWarningPanel.getJavaPlatforms("1.5");
            if (javaPlatformArray.length > 0) {
                return WARN_SET_JDK_15;
            }
            return WARN_SET_SOURCE_LEVEL_15;
        }
        return null;
    }

    @Deprecated
    public static String findWarningType(String string) {
        return J2eeVersionWarningPanel.findWarningType(Profile.fromPropertiesString((String)string));
    }

    private static JavaPlatform[] getJavaPlatforms(String string) {
        return JavaPlatformManager.getDefault().getPlatforms(null, new Specification("J2SE", new SpecificationVersion(string)));
    }

    private void initComponents() {
        this.setJdk14Panel = new JPanel();
        this.downgradeJdk14CheckBox = new JCheckBox();
        this.warningJdk14Label = new JLabel();
        this.setSourceLevel15Panel = new JPanel();
        this.downgradeSourceLevel15CheckBox = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.setJdk15Panel = new JPanel();
        this.downgradeJdk15CheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setSourceLevel14Panel = new JPanel();
        this.downgradeSourceLevel14CheckBox = new JCheckBox();
        this.warningSourceLevel14Label = new JLabel();
        this.downgradeJdk14CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetJdk14").charAt(0));
        this.downgradeJdk14CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk14"));
        this.downgradeJdk14CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2eeVersionWarningPanel.this.downgradeJdk14CheckBoxActionPerformed(actionEvent);
            }
        });
        this.warningJdk14Label.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetJdk14"));
        GroupLayout groupLayout = new GroupLayout((Container)this.setJdk14Panel);
        this.setJdk14Panel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.warningJdk14Label, -1, 318, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.downgradeJdk14CheckBox).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.warningJdk14Label).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.downgradeJdk14CheckBox)));
        this.downgradeJdk14CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetJdk14"));
        this.downgradeSourceLevel15CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetSourceLevel15").charAt(0));
        this.downgradeSourceLevel15CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel15"));
        this.downgradeSourceLevel15CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2eeVersionWarningPanel.this.downgradeSourceLevel15CheckBoxActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetSourceLevel15"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.setSourceLevel15Panel);
        this.setSourceLevel15Panel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel2, -1, 318, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.downgradeSourceLevel15CheckBox).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.downgradeSourceLevel15CheckBox)));
        this.downgradeSourceLevel15CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetSourceLevel15"));
        this.downgradeJdk15CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetJdk15").charAt(0));
        this.downgradeJdk15CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetJdk15"));
        this.downgradeJdk15CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2eeVersionWarningPanel.this.downgradeJdk15CheckBoxActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetJdk15"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.setJdk15Panel);
        this.setJdk15Panel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jLabel1, -1, 318, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.downgradeJdk15CheckBox).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.downgradeJdk15CheckBox)));
        this.downgradeJdk15CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetJdk15"));
        this.downgradeSourceLevel14CheckBox.setMnemonic(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"MNE_AgreeSetSourceLevel14").charAt(0));
        this.downgradeSourceLevel14CheckBox.setText(NbBundle.getMessage(J2eeVersionWarningPanel.class, (String)"CTL_AgreeSetSourceLevel14"));
        this.downgradeSourceLevel14CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2eeVersionWarningPanel.this.downgradeSourceLevel14CheckBoxActionPerformed(actionEvent);
            }
        });
        this.warningSourceLevel14Label.setText(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("MSG_RecommendationSetSourceLevel14"));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.setSourceLevel14Panel);
        this.setSourceLevel14Panel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.warningSourceLevel14Label, -1, 318, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.downgradeSourceLevel14CheckBox).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.warningSourceLevel14Label).addPreferredGap(0).add((Component)this.downgradeSourceLevel14CheckBox)));
        this.downgradeSourceLevel14CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2eeVersionWarningPanel.class).getString("ACS_AgreeSetSourceLevel14"));
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.setJdk14Panel, -1, -1, Short.MAX_VALUE).add((Component)this.setJdk15Panel, -1, -1, Short.MAX_VALUE).add((Component)this.setSourceLevel14Panel, -1, -1, Short.MAX_VALUE).add((Component)this.setSourceLevel15Panel, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.setJdk14Panel, -2, -1, -2).add(0, 0, 0).add((Component)this.setSourceLevel14Panel, -2, -1, -2).add(0, 0, 0).add((Component)this.setJdk15Panel, -2, -1, -2).add(0, 0, 0).add((Component)this.setSourceLevel15Panel, -2, -1, -2)));
    }

    private void downgradeSourceLevel15CheckBoxActionPerformed(ActionEvent actionEvent) {
        UserProjectSettings.getDefault().setAgreedSetSourceLevel15(this.downgradeSourceLevel15CheckBox.isSelected());
    }

    private void downgradeJdk15CheckBoxActionPerformed(ActionEvent actionEvent) {
        UserProjectSettings.getDefault().setAgreedSetJdk15(this.downgradeJdk15CheckBox.isSelected());
    }

    private void downgradeSourceLevel14CheckBoxActionPerformed(ActionEvent actionEvent) {
        UserProjectSettings.getDefault().setAgreedSetSourceLevel14(this.downgradeSourceLevel14CheckBox.isSelected());
    }

    private void downgradeJdk14CheckBoxActionPerformed(ActionEvent actionEvent) {
        UserProjectSettings.getDefault().setAgreedSetJdk14(this.downgradeJdk14CheckBox.isSelected());
    }
}

