/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.netbeans.modules.bugzilla.commands.GetConfigurationCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.CustomIssueField;
import org.netbeans.modules.bugzilla.repository.IssueField;

public class BugzillaConfiguration {
    private RepositoryConfiguration rc;
    private List<IssueField> issueFields;

    public synchronized void initialize(BugzillaRepository repository, boolean forceRefresh) {
        this.rc = this.getRepositoryConfiguration(repository, forceRefresh);
    }

    protected RepositoryConfiguration getRepositoryConfiguration(BugzillaRepository repository, boolean forceRefresh) {
        GetConfigurationCommand cmd = new GetConfigurationCommand(forceRefresh, repository);
        repository.getExecutor().execute(cmd, true, false);
        return cmd.getConf();
    }

    public boolean isValid() {
        return this.rc != null;
    }

    public List<String> getProducts() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getProducts();
    }

    public List<String> getComponents(String product) {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        if (product == null) {
            return this.rc.getComponents();
        }
        return this.rc.getComponents(product);
    }

    public List<String> getResolutions() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getResolutions();
    }

    public List<String> getVersions(String product) {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        if (product == null) {
            return this.rc.getVersions();
        }
        return this.rc.getVersions(product);
    }

    public List<String> getStatusValues() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getStatusValues();
    }

    public List<String> getOpenStatusValues() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getOpenStatusValues();
    }

    public List<String> getPriorities() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getPriorities();
    }

    public List<String> getKeywords() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getKeywords();
    }

    public List<String> getPlatforms() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getPlatforms();
    }

    public List<String> getOSs() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getOSs();
    }

    public List<String> getSeverities() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getSeverities();
    }

    public List<String> getIssueTypes() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        List fields = this.rc.getCustomFields();
        for (BugzillaCustomField field : fields) {
            if (!field.getName().equals("cf_bug_type")) continue;
            return field.getOptions();
        }
        return Collections.emptyList();
    }

    public List<BugzillaCustomField> getCustomFields() {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        return this.rc.getCustomFields();
    }

    public List<String> getTargetMilestones(String product) {
        if (this.rc == null) {
            return Collections.emptyList();
        }
        if (product == null) {
            return this.rc.getTargetMilestones();
        }
        return this.rc.getTargetMilestones(product);
    }

    public BugzillaVersion getInstalledVersion() {
        if (this.rc == null) {
            return null;
        }
        return this.rc.getInstallVersion();
    }

    public List<IssueField> getFields() {
        if (this.issueFields == null) {
            ArrayList<IssueField> fields = new ArrayList<IssueField>(40);
            fields.add(IssueField.SUMMARY);
            fields.add(IssueField.WHITEBOARD);
            fields.add(IssueField.STATUS);
            fields.add(IssueField.PRIORITY);
            fields.add(IssueField.RESOLUTION);
            fields.add(IssueField.PRODUCT);
            fields.add(IssueField.COMPONENT);
            fields.add(IssueField.VERSION);
            fields.add(IssueField.PLATFORM);
            fields.add(IssueField.OS);
            fields.add(IssueField.MILESTONE);
            fields.add(IssueField.REPORTER);
            fields.add(IssueField.REPORTER_NAME);
            fields.add(IssueField.ASSIGNED_TO);
            fields.add(IssueField.ASSIGNED_TO_NAME);
            fields.add(IssueField.QA_CONTACT);
            fields.add(IssueField.QA_CONTACT_NAME);
            fields.add(IssueField.DEPENDS_ON);
            fields.add(IssueField.BLOCKS);
            fields.add(IssueField.URL);
            fields.add(IssueField.KEYWORDS);
            fields.add(IssueField.SEVERITY);
            fields.add(IssueField.ISSUE_TYPE);
            fields.add(IssueField.DESCRIPTION);
            fields.add(IssueField.CREATION);
            fields.add(IssueField.CC);
            fields.add(IssueField.MODIFICATION);
            fields.add(IssueField.NEWCC);
            fields.add(IssueField.REMOVECC);
            fields.add(IssueField.COMMENT_COUNT);
            fields.add(IssueField.ATTACHEMENT_COUNT);
            if (this.rc != null) {
                for (BugzillaCustomField field : this.rc.getCustomFields()) {
                    fields.add(new CustomIssueField(field));
                }
            }
            this.issueFields = fields;
        }
        return this.issueFields;
    }

    public IssueField getField(String key) {
        for (IssueField issueField : this.getFields()) {
            if (!issueField.getKey().equals(key)) continue;
            return issueField;
        }
        return null;
    }
}

