/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.kenai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;

public class KenaiConfiguration
extends BugzillaConfiguration {
    private List<String> products;
    private KenaiRepository repository;
    private static Map<String, RepositoryConfiguration> rcs;

    public KenaiConfiguration(KenaiRepository repository, String product) {
        this.repository = repository;
        ArrayList<String> l = new ArrayList<String>();
        l.add(product);
        this.products = Collections.unmodifiableList(l);
    }

    @Override
    public List<String> getProducts() {
        this.ensureProduct();
        if (!BugzillaUtil.isNbRepository(this.repository)) {
            return this.products;
        }
        return super.getProducts();
    }

    @Override
    public List<String> getComponents(String product) {
        this.ensureProduct();
        return super.getComponents(product);
    }

    @Override
    public List<String> getVersions(String product) {
        this.ensureProduct();
        return super.getVersions(product);
    }

    private synchronized void ensureProduct() {
        List<String> knownProducts = super.getProducts();
        for (String product : this.products) {
            if (knownProducts.contains(product)) continue;
            this.initialize(this.repository, true);
            break;
        }
    }

    void reset() {
        if (rcs != null) {
            rcs.remove(this.repository.getUrl());
        }
    }

    @Override
    protected RepositoryConfiguration getRepositoryConfiguration(BugzillaRepository repository, boolean forceRefresh) {
        RepositoryConfiguration rc;
        if (rcs == null) {
            rcs = new HashMap<String, RepositoryConfiguration>(1);
        }
        if ((rc = rcs.get(repository.getUrl())) == null) {
            rc = super.getRepositoryConfiguration(repository, forceRefresh);
            rcs.put(repository.getUrl(), rc);
        }
        return rc;
    }
}

