/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.util;

import com.sun.perseus.j2d.Transform;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import java.util.zip.GZIPInputStream;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableImage;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreSettings;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class Util {
    private static final int MAX_WORKUNITS = 300;

    public static void launchExternalEditor(final FileObject fo) {
        assert (fo != null) : "File object is null";
        final InputOutput io = IOProvider.getDefault().getIO(NbBundle.getMessage(Util.class, (String)"LBL_EditedSvgFile", (Object)fo.getName()), false);
        ExecutionEngine.getDefault().execute(NbBundle.getMessage(Util.class, (String)"LBL_SvgEditor"), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String path = SvgcoreSettings.getDefault().getExternalEditorPath();
                if (path == null || path.length() == 0 || !new File(path).exists()) {
                    if (path == null || path.length() == 0) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"ERR_SvgEditorNotSet", (Object)path), 0));
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"ERR_SvgEditor", (Object)path), 0));
                    }
                    io.closeInputOutput();
                    return;
                }
                io.getOut().println(NbBundle.getMessage(Util.class, (String)"LBL_LaunchingFile", (Object)FileUtil.toFile((FileObject)fo).toString()));
                NbProcessDescriptor descriptor = new NbProcessDescriptor(path, '\"' + FileUtil.toFile((FileObject)fo).getAbsoluteFile().toString() + '\"');
                try {
                    Process p = descriptor.exec();
                    p.waitFor();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(16, (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                finally {
                    if (io != null) {
                        io.closeInputOutput();
                    }
                }
            }
        }, io);
    }

    public static SVGImage createSVGImage(FileObject fo, boolean showProgress) throws IOException {
        assert (fo != null) : "File object is null";
        if (!showProgress) {
            return Util.loadImage(fo.getURL().toString());
        }
        return Util.loadImageWithProgress(fo);
    }

    private static SVGImage loadImage(String url) throws IOException {
        return (SVGImage)ScalableImage.createImage((String)url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVGImage loadImageWithProgress(FileObject fo) throws IOException {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Util.class, (String)"MSG_Loading", (Object)fo.getNameExt()));
        handle.start(300);
        if ("svg".equals(fo.getExt().toLowerCase())) {
            ProgressInputStream pis = null;
            try {
                pis = new ProgressInputStream(fo.getInputStream(), fo.getSize(), handle);
                SVGImage sVGImage = (SVGImage)ScalableImage.createImage((InputStream)pis, null);
                return sVGImage;
            }
            finally {
                handle.finish();
                try {
                    if (pis != null) {
                        pis.close();
                    }
                }
                catch (IOException ioEx) {}
            }
        }
        BufferedInputStream pis = null;
        try {
            pis = new ProgressInputStream(new GZIPInputStream(fo.getInputStream()), fo.getSize(), handle);
            SVGImage sVGImage = (SVGImage)ScalableImage.createImage((InputStream)pis, null);
            return sVGImage;
        }
        finally {
            handle.finish();
            try {
                if (pis != null) {
                    pis.close();
                }
            }
            catch (IOException ioEx) {}
        }
    }

    public static String getPropertyValue(String text, String propName) {
        int to;
        int from;
        int index;
        if (text != null && (index = text.indexOf(propName)) != -1 && (from = text.indexOf(34, index += propName.length())) != -1 && (to = text.indexOf(34, ++from)) != -1) {
            return text.substring(from, to);
        }
        return null;
    }

    public static SVGElement getElementById(SVGImage svgImage, String elementId) {
        if (svgImage != null && elementId != null) {
            SVGSVGElement svg = (SVGSVGElement)svgImage.getDocument().getDocumentElement();
            return PerseusController.findElementById(svg, elementId);
        }
        return null;
    }

    public static Rectangle getElementRectangle(SVGImage svgImage, String elementId) {
        SVGSVGElement svg;
        SVGElement elem;
        Rectangle boundRect = null;
        if (svgImage != null && elementId != null && (elem = PerseusController.findElementById(svg = (SVGSVGElement)svgImage.getDocument().getDocumentElement(), elementId)) != null && elem instanceof SVGLocatableElement) {
            SVGLocatableElement svgElement = (SVGLocatableElement)elem;
            SVGRect bBox = PerseusController.getFullBBox(svgElement);
            SVGMatrix svgCTM = svg.getScreenCTM();
            SVGMatrix eltCTM = svgElement.getScreenCTM();
            SVGMatrix svgICTM = svgCTM.inverse();
            SVGMatrix eltToSvg = svgICTM.mMultiply(eltCTM);
            float[][] coords = SVGObjectOutline.transformRectangle(bBox, (Transform)eltToSvg, new float[4][2]);
            Rectangle rect2 = SVGObjectOutline.getShapeBoundingBox(coords);
            boundRect = new Rectangle((int)rect2.getX(), (int)rect2.getY(), (int)rect2.getWidth(), (int)rect2.getHeight());
        }
        return boundRect;
    }

    private static class ProgressInputStream
    extends BufferedInputStream {
        private ProgressHandle handle;
        private long expectedSize;
        private long alreadyRead;
        private int lastProgress;

        public ProgressInputStream(InputStream in, long expectedSize, ProgressHandle handle) {
            super(in);
            this.handle = handle;
            this.expectedSize = expectedSize;
            this.lastProgress = 0;
        }

        @Override
        public synchronized int read() throws IOException {
            int i = super.read();
            this.alreadyRead += (long)i;
            this.updateProgress();
            return i;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int i = super.read(b, off, len);
            this.alreadyRead += (long)i;
            this.updateProgress();
            return i;
        }

        private void updateProgress() throws IOException {
            double current = (double)this.alreadyRead / (double)this.expectedSize * 100.0;
            if (current >= 300.0) {
                current = 295.0;
            }
            if (this.lastProgress < (int)current) {
                this.lastProgress = (int)current;
            }
            this.handle.progress(this.lastProgress);
        }
    }

    public static interface SVGImageLoadedListener
    extends EventListener {
        public void svgImageLoaded(SVGImage var1, Exception var2);
    }
}

