/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Dimension;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;

public class ScreenSizeHelper {
    public static Dimension getCurrentDeviceScreenSize(FileObject primaryFile, String configuration) {
        Project p = FileOwnerQuery.getOwner((FileObject)primaryFile);
        if (p == null || !(p instanceof J2MEProject)) {
            return new Dimension(320, 240);
        }
        Dimension dim = ScreenSizeHelper.getDeviceScreenSizeFromProject((J2MEProject)p, configuration);
        if (dim == null || dim.getHeight() < 10.0 || dim.getWidth() < 10.0) {
            return new Dimension(320, 240);
        }
        return dim;
    }

    private static Dimension getDeviceScreenSizeFromProject(J2MEProject project, String configuration) {
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ProjectConfigurationsHelper confs = project.getConfigurationHelper();
        String activeConfiguration = configuration;
        String platformActive = ScreenSizeHelper.evaluateProperty(ep, "platform.active", activeConfiguration);
        String deviceActive = ScreenSizeHelper.evaluateProperty(ep, "platform.device", activeConfiguration);
        if (platformActive != null && deviceActive != null) {
            J2MEPlatform.Device[] devices;
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            J2MEPlatform platform = null;
            if (platforms != null) {
                for (int i = 0; i < platforms.length; ++i) {
                    JavaPlatform javaPlatform = platforms[i];
                    if (!(javaPlatform instanceof J2MEPlatform) || !platformActive.equals(((J2MEPlatform)javaPlatform).getName())) continue;
                    platform = (J2MEPlatform)javaPlatform;
                    break;
                }
            }
            if (platform != null && (devices = platform.getDevices()) != null) {
                for (int i = 0; i < devices.length; ++i) {
                    J2MEPlatform.Screen screen;
                    J2MEPlatform.Device device = devices[i];
                    if (!deviceActive.equals(device.getName()) || (screen = device.getScreen()) == null) continue;
                    Integer height = screen.getHeight();
                    Integer width = screen.getWidth();
                    if (height == null || width == null) continue;
                    return new Dimension(width, height);
                }
            }
        }
        return null;
    }

    private static String evaluateProperty(EditableProperties ep, String propertyName, String configuration) {
        if (configuration == null) {
            return ep.getProperty(propertyName);
        }
        String value = ep.getProperty("configs." + configuration + "." + propertyName);
        return value != null ? value : ScreenSizeHelper.evaluateProperty(ep, propertyName, null);
    }
}

