/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DecoratedNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SVG;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeAttributesNode;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.platform.URLResolver;
import org.w3c.dom.DOMException;

public abstract class MediaElement
extends TimeAttributesNode
implements DecoratedNode {
    protected String href = "";
    protected String type = "";
    protected String syncBehavior;
    protected Time syncTolerance;
    protected boolean syncMaster = false;
    protected float audioLevel = 1.0f;
    protected int markers = 0;
    static final String[][] REQUIRED_TRAITS_NS = new String[][]{{"http://www.w3.org/1999/xlink", "href"}};
    private boolean mediaStarted = false;
    private long sampleTime;

    public MediaElement(DocumentNode ownerDocument, String localName) {
        super(ownerDocument, localName);
        ModelNode mn = ownerDocument.getFirstChildNode();
        if (mn != null && mn instanceof SVG) {
            SVG svg = (SVG)mn;
            this.syncBehavior = svg.getSyncBehaviorDefault();
            this.syncTolerance = svg.getSyncToleranceDefault();
        } else {
            this.syncBehavior = "canSlip";
            this.syncTolerance = new Time(2000L);
        }
    }

    String getHref() {
        String uriBase = this.getURIBase();
        try {
            if (uriBase != null) {
                String url = URLResolver.resolve(uriBase, this.href);
                return url;
            }
            return this.href;
        }
        catch (IllegalArgumentException mue) {
            return null;
        }
    }

    void setHref(String newHref) {
        if (newHref == null) {
            throw new IllegalArgumentException();
        }
        if (MediaElement.equal(newHref, this.href)) {
            return;
        }
        this.modifyingNode();
        this.href = newHref;
        this.modifiedNode();
    }

    String getType() {
        return this.type;
    }

    void setType(String newType) {
        if (newType == null) {
            throw new IllegalArgumentException();
        }
        if (MediaElement.equal(newType, this.type)) {
            return;
        }
        this.modifyingNode();
        this.type = newType;
        this.modifiedNode();
    }

    final float getAudioLevel() {
        return this.audioLevel;
    }

    final void setAudioLevel(float newAudioLevel) {
        if (newAudioLevel < 0.0f || newAudioLevel > 1.0f) {
            throw new IllegalArgumentException();
        }
        if (this.audioLevel == newAudioLevel) {
            return;
        }
        this.modifyingNode();
        this.audioLevel = newAudioLevel;
        this.setVolume(this.audioLevel);
        this.modifiedNode();
    }

    boolean supportsTrait(String traitName) {
        if ("audio-level" == traitName || "type" == traitName || "syncBehavior" == traitName || "syncTolerance" == traitName || "syncMaster" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == traitName) {
            return true;
        }
        return super.supportsTraitNS(namespaceURI, traitName);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("audio-level" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        return super.createTraitAnimImpl(traitName);
    }

    TraitAnim createTraitAnimNSImpl(String traitNamespace, String traitName) {
        if (traitNamespace == "http://www.w3.org/1999/xlink" && traitName == "href") {
            return new StringTraitAnim(this, traitNamespace, traitName);
        }
        return super.createTraitAnimNSImpl(traitNamespace, traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("audio-level" == name) {
            return Float.toString(this.audioLevel);
        }
        if ("type" == name) {
            return this.type;
        }
        if ("syncBehavior" == name) {
            return this.syncBehavior;
        }
        if ("syncTolerance" == name) {
            return Time.toStringTrait(this.syncTolerance);
        }
        if ("syncMaster" == name) {
            return String.valueOf(this.syncMaster);
        }
        return super.getTraitImpl(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("audio-level" == name) {
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setAudioLevel(this.parseFloatTrait(name, value));
            return;
        } else if ("type" == name) {
            this.setType(value);
            return;
        } else if ("syncBehavior" == name) {
            if ("canSlip".equals(value) || "independent".equals(value) || "locked".equals(value)) {
                this.syncBehavior = value;
                return;
            } else {
                if (!"default".equals(value)) throw this.illegalTraitValue(name, value);
                ModelNode mn = this.getOwnerDocument().getFirstChildNode();
                if (mn != null && mn instanceof SVG) {
                    SVG svg = (SVG)mn;
                    this.syncBehavior = svg.getSyncBehaviorDefault();
                    return;
                } else {
                    this.syncBehavior = "canSlip";
                }
            }
            return;
        } else if ("syncTolerance" == name) {
            if (value.equals("default")) {
                ModelNode mn = this.getOwnerDocument().getFirstChildNode();
                if (mn != null && mn instanceof SVG) {
                    SVG svg = (SVG)mn;
                    this.syncTolerance = svg.getSyncToleranceDefault();
                    return;
                } else {
                    this.syncTolerance = new Time(2000L);
                }
                return;
            } else {
                this.syncTolerance = this.parseClockTrait(name, value);
            }
            return;
        } else if ("syncMaster" == name) {
            if ("true".equals(value)) {
                this.syncMaster = true;
                return;
            } else {
                if (!"false".equals(value)) throw this.illegalTraitValue(name, value);
                this.syncMaster = false;
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    String getTraitNSImpl(String namespaceURI, String name) throws DOMException {
        if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
            return this.href;
        }
        return super.getTraitNSImpl(namespaceURI, name);
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        try {
            if ("http://www.w3.org/1999/xlink" == namespaceURI && "href" == name) {
                if (value == null) {
                    throw this.illegalTraitValue(name, value);
                }
                this.setHref(value);
            } else {
                super.setTraitNSImpl(namespaceURI, name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("audio-level" == name) {
            return this.audioLevel;
        }
        return super.getFloatTraitImpl(name);
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("audio-level" == name) {
            this.setAudioLevel(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("audio-level" == name) {
            return Float.toString(value[0][0]);
        }
        if ("type" == name) {
            return this.type;
        }
        return super.toStringTrait(name, value);
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("audio-level" == traitName) {
            float v = this.parseFloatTrait(traitName, value);
            return new float[][]{{v}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("audio-level" == name) {
            this.setAudioLevel(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public void dispatchEvent(ModelEvent evt) {
        super.dispatchEvent(evt);
        if ("beginEvent".equals(evt.getType())) {
            this.ownerDocument.activeMediaElements.addElement(this);
        } else if ("repeat".equals(evt.getType())) {
            this.ownerDocument.activeMediaElements.addElement(this);
        } else if ("endEvent".equals(evt.getType())) {
            this.endMedia();
            this.ownerDocument.activeMediaElements.removeElement(this);
        }
    }

    void clearMarker(int marker) {
        this.markers &= ~marker;
    }

    final boolean isMarkerSet(int marker) {
        return (this.markers & marker) != 0;
    }

    void setMarker(int marker) {
        this.markers |= marker;
    }

    public boolean isInherited(int propertyIndex) {
        return this.isMarkerSet(propertyIndex);
    }

    public void setInherited(int propertyIndex, boolean inherit) {
        if (this.isInherited(propertyIndex) == inherit) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(propertyIndex, inherit);
        if (inherit) {
            Object inheritedValue = this.getInheritedPropertyState(propertyIndex);
            this.setPropertyState(propertyIndex, inheritedValue);
            this.propagatePropertyState(propertyIndex, inheritedValue);
        }
        this.modifiedNode();
    }

    protected void setInheritedQuiet(int propertyIndex, boolean inherit) {
        if (inherit) {
            this.setMarker(propertyIndex);
        } else {
            this.clearMarker(propertyIndex);
        }
    }

    public void setFloatInherited(int propertyIndex, boolean inherit) {
        if (this.isInherited(propertyIndex) == inherit) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(propertyIndex, inherit);
        if (inherit) {
            float inheritedValue = this.getInheritedFloatPropertyState(propertyIndex);
            this.setFloatPropertyState(propertyIndex, inheritedValue);
            this.propagateFloatPropertyState(propertyIndex, inheritedValue);
        }
        this.modifiedNode();
    }

    public void setPackedInherited(int propertyIndex, boolean inherit) {
        if (this.isInherited(propertyIndex) == inherit) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(propertyIndex, inherit);
        if (inherit) {
            int inheritedValue = this.getInheritedPackedPropertyState(propertyIndex);
            this.setPackedPropertyState(propertyIndex, inheritedValue);
            this.propagatePackedPropertyState(propertyIndex, inheritedValue);
        }
        this.modifiedNode();
    }

    public int getNumberOfProperties() {
        return 2;
    }

    protected void recomputePropertyState(int propertyIndex, Object parentPropertyValue) {
        if (!this.isInherited(propertyIndex) || this.isPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setPropertyState(propertyIndex, parentPropertyValue);
        this.propagatePropertyState(propertyIndex, parentPropertyValue);
    }

    protected void recomputeFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        if (!this.isInherited(propertyIndex) || this.isFloatPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setFloatPropertyState(propertyIndex, parentPropertyValue);
        this.propagateFloatPropertyState(propertyIndex, parentPropertyValue);
    }

    public void playMedia() {
        if (!this.mediaStarted) {
            try {
                this.init();
                this.play(this.timedElementSupport.lastSampleTime);
            }
            catch (Exception e) {
                System.err.println("Cannot initialize media player");
            }
            this.mediaStarted = true;
        } else if (this.timedElementSupport.lastSampleTime < this.sampleTime) {
            this.play(this.timedElementSupport.lastSampleTime);
        }
        if (this.mediaStarted) {
            this.updateFrame();
        }
        this.sampleTime = this.timedElementSupport.lastSampleTime;
    }

    public void endMedia() {
        if (this.mediaStarted) {
            this.stop();
            this.mediaStarted = false;
        }
    }

    void nodeUnhookedFromDocumentTree() {
        super.nodeUnhookedFromDocumentTree();
        this.endMedia();
        this.ownerDocument.activeMediaElements.removeElement(this);
    }

    abstract void init() throws Exception;

    abstract void play(long var1);

    abstract void stop();

    abstract void close();

    abstract void updateFrame();

    abstract void setVolume(float var1);
}

