/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.MethodFactory;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class CompiledMethod
extends JavaMethod
implements JumpTarget,
Cloneable {
    protected Object $scriptObject;

    public CompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, CallConfiguration callConfig) {
        super(implementationClass, visibility, callConfig, staticScope, arity);
        this.$scriptObject = scriptObject;
    }

    protected CompiledMethod() {
    }

    protected void init(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, CallConfiguration callConfig) {
        this.$scriptObject = scriptObject;
        super.init(implementationClass, arity, visibility, staticScope, callConfig);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
        return this.call(context, self, clazz, name, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg) {
        return this.call(context, self, clazz, name, arg, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self, clazz, name, arg1, arg2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.call(context, self, clazz, name, arg1, arg2, arg3, Block.NULL_BLOCK);
    }

    @Override
    public DynamicMethod dup() {
        try {
            CompiledMethod msm = (CompiledMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public boolean isNative() {
        return false;
    }

    public static class LazyCompiledMethod
    extends DynamicMethod
    implements JumpTarget,
    Cloneable {
        private final String method;
        private final Arity arity;
        private final StaticScope scope;
        private final Object scriptObject;
        private MethodFactory factory;
        private DynamicMethod compiledMethod;

        public LazyCompiledMethod(RubyModule implementationClass, String method, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, MethodFactory factory) {
            super(implementationClass, visibility, callConfig);
            this.method = method;
            this.arity = arity;
            this.scope = scope;
            this.scriptObject = scriptObject;
            this.factory = factory;
        }

        private synchronized void initializeMethod() {
            if (this.compiledMethod != null) {
                return;
            }
            this.compiledMethod = this.factory.getCompiledMethod(this.implementationClass, this.method, this.arity, this.visibility, this.scope, this.scriptObject, this.callConfig);
            this.factory = null;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1, arg2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, args);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, arg0, arg1, arg2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.call(context, self, clazz, name, args, block);
        }

        @Override
        public Arity getArity() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getArity();
        }

        @Override
        public CallConfiguration getCallConfig() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getCallConfig();
        }

        @Override
        public RubyModule getImplementationClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getImplementationClass();
        }

        @Override
        protected RubyModule getProtectedClass() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getProtectedClass();
        }

        @Override
        public DynamicMethod getRealMethod() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getRealMethod();
        }

        @Override
        public Visibility getVisibility() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.getVisibility();
        }

        @Override
        public boolean isCallableFrom(IRubyObject caller, CallType callType) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isCallableFrom(caller, callType);
        }

        @Override
        public boolean isNative() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.isNative();
        }

        @Override
        public void setCallConfig(CallConfiguration callConfig) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setCallConfig(callConfig);
        }

        @Override
        public void setImplementationClass(RubyModule implClass) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setImplementationClass(implClass);
        }

        @Override
        public void setVisibility(Visibility visibility) {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            this.compiledMethod.setVisibility(visibility);
        }

        @Override
        public DynamicMethod dup() {
            if (this.compiledMethod == null) {
                this.initializeMethod();
            }
            return this.compiledMethod.dup();
        }
    }
}

