/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyMatchData;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class NthRefNode
extends Node {
    private final int matchNumber;

    public NthRefNode(ISourcePosition position, int matchNumber) {
        super(position, NodeType.NTHREFNODE);
        this.matchNumber = matchNumber;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitNthRefNode(this);
    }

    public int getMatchNumber() {
        return this.matchNumber;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return RubyRegexp.nth_match(this.matchNumber, context.getCurrentFrame().getBackRef());
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
            if (!((RubyMatchData)backref).group(this.matchNumber).isNil()) {
                return "$" + this.matchNumber;
            }
        }
        return null;
    }
}

