/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.api;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.LocalProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcReaderImpl;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider64;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessUsageProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.RemoteProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.ThreadsInfoProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public final class ProcReaderFactory {
    private ProcReaderFactory() {
    }

    public static ProcReader getReader(ExecutionEnvironment execEnv, int pid) {
        ProcReader reader = null;
        try {
            HostInfo info = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            ByteOrder byteOrder = info.getCpuFamily() == HostInfo.CpuFamily.SPARC ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            DataModel dataModel = ProcReaderFactory.getDataModel(execEnv, pid);
            ProcessStatusProvider _statusProvider = null;
            ProcessUsageProvider _usageProvider = null;
            ThreadsInfoProvider _threadsInfoProvider = null;
            ProcReaderImpl _reader = null;
            _reader = execEnv.isLocal() ? new LocalProcReader(pid, byteOrder, dataModel) : new RemoteProcReader(execEnv, pid, byteOrder, dataModel);
            _usageProvider = _reader;
            _threadsInfoProvider = _reader;
            _statusProvider = dataModel == DataModel._LP64 ? new ProcessStatusProvider64(execEnv, pid) : (ProcessStatusProvider)_reader;
            final ProcessStatusProvider statusProvider = _statusProvider;
            final ProcessUsageProvider usageProvider = _usageProvider;
            final ThreadsInfoProvider threadsInfoProvider = _threadsInfoProvider;
            reader = new ProcReader(){

                @Override
                public PUsage getProcessUsage() throws IOException {
                    return usageProvider.getProcessUsage();
                }

                @Override
                public List<LWPUsage> getThreadsInfo() throws IOException {
                    return threadsInfoProvider.getThreadsInfo();
                }

                @Override
                public PStatus getProcessStatus() throws IOException {
                    return statusProvider.getProcessStatus();
                }
            };
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return reader;
    }

    private static DataModel getDataModel(ExecutionEnvironment execEnv, int pid) {
        DataModel dataModel;
        block4: {
            dataModel = DataModel._LP64;
            try {
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
                npb.setExecutable("/bin/pflags").setArguments(new String[]{"" + pid});
                NativeProcess p = npb.call();
                List lines = ProcessUtils.readProcessOutput((Process)p);
                int rc = p.waitFor();
                Pattern pattern = Pattern.compile("[ \t]+data model = ([^ ]+).*");
                if (rc != 0) break block4;
                for (String line : lines) {
                    Matcher m = pattern.matcher(line);
                    if (!m.matches()) continue;
                    String model = m.group(1);
                    dataModel = DataModel.valueOf(model);
                    break;
                }
            }
            catch (InterruptedException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return dataModel;
    }
}

