/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunnerAction;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class RakeRunner {
    private final RubyBaseProject project;
    private boolean showWarnings;
    private boolean debug;
    private FileObject rakeFile;
    private RubyFileLocator fileLocator;
    private File pwd;
    private String displayName;
    private final List<String> parameters = new ArrayList<String>();

    public RakeRunner(RubyBaseProject project) {
        this.project = project;
    }

    static void runTask(RubyBaseProject project, RakeTask task, String taskParams, boolean debug) {
        RakeRunner runner = new RakeRunner(project);
        runner.showWarnings(true);
        if (taskParams != null) {
            runner.setParameters(Utilities.parseParameters((String)taskParams));
        }
        runner.setDebug(debug);
        runner.run(task);
    }

    public void setRakeFile(FileObject rakeFile) {
        this.rakeFile = rakeFile;
    }

    public void showWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFileLocator(RubyFileLocator fileLocator) {
        this.fileLocator = fileLocator;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setPWD(File pwd) {
        this.pwd = pwd;
    }

    public void setParameters(String ... parameters) {
        Parameters.notNull((CharSequence)"parameters", (Object)parameters);
        for (String each : parameters) {
            this.parameters.add(each);
        }
    }

    public List<Future<Integer>> run(String ... taskNames) {
        if (taskNames.length == 0) {
            taskNames = new String[]{"default"};
        }
        if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)this.showWarnings)) {
            return null;
        }
        RakeTask[] rakeTasks = new RakeTask[taskNames.length];
        for (int i = 0; i < taskNames.length; ++i) {
            RakeTask rakeTask = RakeSupport.getRakeTask(this.project, taskNames[i]);
            if (rakeTask == null) {
                if (this.showWarnings) {
                    Util.notifyLocalized(RakeRunner.class, (String)"RakeRunner.task.does.not.exist", (Object[])new Object[]{taskNames[i]});
                }
                return null;
            }
            rakeTasks[i] = rakeTask;
        }
        return this.run(rakeTasks);
    }

    private List<Future<Integer>> run(RakeTask ... tasks) {
        assert (tasks.length > 0) : "must pass at least one task";
        if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)this.showWarnings)) {
            return null;
        }
        LifecycleManager.getDefault().saveAll();
        if (this.fileLocator == null) {
            this.fileLocator = new RubyFileLocator(Lookup.EMPTY, this.project);
        }
        if (this.rakeFile == null) {
            this.rakeFile = RakeSupport.findRakeFile(this.project);
        }
        if (this.rakeFile == null) {
            this.pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        if (this.pwd == null) {
            this.pwd = FileUtil.toFile((FileObject)this.rakeFile.getParent());
        }
        List<RakeTask> tasksToRun = Arrays.asList(tasks);
        this.computeAndSetDisplayName(tasksToRun);
        List<ExecutionService> services = this.getExecutionServices(tasksToRun);
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(services.size());
        for (ExecutionService each : services) {
            futures.add(each.run());
        }
        return futures;
    }

    private List<ExecutionService> getExecutionServices(List<? extends RakeTask> tasks) {
        ArrayList<ExecutionService> result = new ArrayList<ExecutionService>(tasks.size());
        for (RubyExecutionDescriptor descriptor : this.getDescriptors(tasks)) {
            result.add(this.buildExecutionService(descriptor));
        }
        return result;
    }

    private ExecutionService buildExecutionService(RubyExecutionDescriptor descriptor) {
        PropertyEvaluator evaluator;
        String charsetName = null;
        if (this.project != null && (evaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null) {
            charsetName = evaluator.getProperty("source.encoding");
        }
        final Runnable original = descriptor.getPostBuild();
        descriptor.postBuild(new Runnable(){

            @Override
            public void run() {
                if (original != null) {
                    original.run();
                }
                FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)RakeRunner.this.project.getProjectDirectory())});
            }
        });
        RubyProcessCreator processCreator = new RubyProcessCreator(descriptor, charsetName);
        return ExecutionService.newService((Callable)processCreator, (ExecutionDescriptor)descriptor.toExecutionDescriptor(), (String)this.displayName);
    }

    List<RubyExecutionDescriptor> getDescriptors(List<? extends RakeTask> tasks) {
        RubyPlatform platform = RubyPlatform.platformFor((Project)this.project);
        String rake = platform.getRake();
        Collection customizers = Lookup.getDefault().lookupAll(RakeTaskCustomizer.class);
        ArrayList<RubyExecutionDescriptor> result = new ArrayList<RubyExecutionDescriptor>(tasks.size());
        RubyCoverageProvider coverageProvider = RubyCoverageProvider.get((Project)this.project);
        if (coverageProvider == null || !coverageProvider.isEnabled()) {
            coverageProvider = null;
        }
        for (RakeTask rakeTask : tasks) {
            String[] existingAdditionalArgs;
            RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, this.displayName, this.pwd, rake);
            this.doStandardConfiguration(desc);
            String[] existingInitialArgs = desc.getInitialArgs() != null ? desc.getInitialArgs() : new String[]{};
            ArrayList<String> initialArgs = new ArrayList<String>(Arrays.asList(existingInitialArgs));
            for (RakeTaskCustomizer customizer : customizers) {
                customizer.customize(this.project, rakeTask, desc, this.debug);
            }
            initialArgs.addAll(rakeTask.getRakeParameters());
            String resultingInitialArgs = "";
            Iterator it = initialArgs.iterator();
            while (it.hasNext()) {
                resultingInitialArgs = resultingInitialArgs + (String)it.next();
                if (!it.hasNext()) continue;
                resultingInitialArgs = resultingInitialArgs + " ";
            }
            desc.initialArgs(resultingInitialArgs);
            ArrayList<String> additionalArgs = new ArrayList<String>();
            String railsEnv = this.project.evaluator().getProperty("rails.env");
            if (railsEnv != null && !"".equals(railsEnv.trim())) {
                additionalArgs.add("RAILS_ENV=" + railsEnv);
            }
            if ((existingAdditionalArgs = desc.getAdditionalArgs()) != null && existingAdditionalArgs.length > 0) {
                additionalArgs.addAll(Arrays.asList(existingAdditionalArgs));
            }
            RakeRunner.addTaskParameters(rakeTask, this.parameters, additionalArgs);
            additionalArgs.addAll(rakeTask.getTaskParameters());
            desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
            if (coverageProvider != null) {
                desc = coverageProvider.wrapWithCoverage(desc, true, null);
            }
            result.add(desc);
        }
        return result;
    }

    private static void addTaskParameters(RakeTask task, List<String> parameters, List<String> additionalArgs) {
        if (!task.acceptsExplicitParameters()) {
            additionalArgs.add(task.getTask());
            additionalArgs.addAll(parameters);
        } else {
            StringBuilder paramsArg = new StringBuilder();
            paramsArg.append(task.getTask());
            if (!parameters.isEmpty()) {
                Iterator<String> it = parameters.iterator();
                paramsArg.append("[");
                paramsArg.append(it.next());
                while (it.hasNext()) {
                    paramsArg.append(",");
                    paramsArg.append(it.next());
                }
                paramsArg.append("]");
            }
            additionalArgs.add(paramsArg.toString());
        }
    }

    private void doStandardConfiguration(RubyExecutionDescriptor desc) {
        String[] args;
        PropertyEvaluator evaluator;
        String charsetName = null;
        String classPath = null;
        String extraArgs = null;
        String jrubyProps = null;
        String options = null;
        if (this.project != null && (evaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null) {
            charsetName = evaluator.getProperty("source.encoding");
            classPath = evaluator.getProperty("javac.classpath");
            extraArgs = evaluator.getProperty("rake.args");
            jrubyProps = evaluator.getProperty("jvm.args");
            options = evaluator.getProperty("ruby.options");
        }
        ArrayList<String> additionalArgs = new ArrayList<String>();
        if (extraArgs != null && (args = Utilities.parseParameters(extraArgs)) != null) {
            for (String arg : args) {
                additionalArgs.add(arg);
            }
        }
        if (this.rakeFile != null) {
            additionalArgs.add("-f");
            additionalArgs.add(FileUtil.toFile((FileObject)this.rakeFile).getAbsolutePath());
        }
        if (!additionalArgs.isEmpty()) {
            desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
        }
        if (options != null) {
            desc.initialArgs(options);
        }
        desc.allowInput();
        desc.classPath(classPath);
        desc.jvmArguments(jrubyProps);
        desc.fileLocator((LineConvertors.FileLocator)this.fileLocator);
        desc.addStandardRecognizers();
        if (RubyPlatform.platformFor((Project)this.project).isJRuby()) {
            desc.appendJdkToPath(true);
        }
        desc.addOutConvertor((LineConvertor)new RakeErrorLineConvertor(desc, charsetName, this.displayName));
        desc.addErrConvertor((LineConvertor)new RakeErrorLineConvertor(desc, charsetName, this.displayName));
        desc.debug(this.debug);
    }

    private void computeAndSetDisplayName(List<? extends RakeTask> tasks) {
        ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
        String baseDisplayName = info == null ? NbBundle.getMessage(RakeRunnerAction.class, (String)"RakeRunnerAction.Rake") : info.getDisplayName();
        StringBuilder displayNameSB = new StringBuilder(baseDisplayName).append(" (");
        for (int i = 0; i < tasks.size(); ++i) {
            displayNameSB.append(tasks.get(i).getTask());
            if (i == tasks.size() - 1) continue;
            displayNameSB.append(", ");
        }
        displayNameSB.append(')');
        this.setDisplayName(displayNameSB.toString());
    }

    private static class RakeErrorLineConvertor
    implements LineConvertor {
        private final RubyExecutionDescriptor template;
        private final String charsetName;
        private final String displayName;

        public RakeErrorLineConvertor(RubyExecutionDescriptor desc, String charsetName, String displayName) {
            this.template = desc;
            this.charsetName = charsetName;
            this.displayName = displayName;
        }

        public List<ConvertedLine> convert(String line) {
            if (line.indexOf("(See full trace by running task with --trace)") != -1) {
                return Collections.singletonList(ConvertedLine.forText((String)NbBundle.getMessage(RakeRunner.class, (String)"RakeSupport.RerunRakeWithTrace"), (OutputListener)new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                    }

                    public void outputLineAction(OutputEvent ev) {
                        RubyProcessCreator rpc = new RubyProcessCreator(this.buildDescriptor(), RakeErrorLineConvertor.this.charsetName);
                        ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)RakeErrorLineConvertor.this.template.toExecutionDescriptor(), (String)RakeErrorLineConvertor.this.displayName).run();
                    }

                    private RubyExecutionDescriptor buildDescriptor() {
                        String[] existing = RakeErrorLineConvertor.this.template.getAdditionalArgs() != null ? RakeErrorLineConvertor.this.template.getAdditionalArgs() : new String[]{};
                        String[] args = new String[existing.length + 1];
                        for (int i = 0; i < existing.length; ++i) {
                            args[i] = existing[i];
                        }
                        args[args.length - 1] = "--trace";
                        return new RubyExecutionDescriptor(RakeErrorLineConvertor.this.template).additionalArgs(args);
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }
                }));
            }
            return null;
        }
    }
}

