/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ListenersImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class LibraryManager {
    private static final LibraryManager instance = new LibraryManager();
    private final Map<String, LibraryEntry> librariesEntries = new ConcurrentHashMap<String, LibraryEntry>();
    private final Object lock = new Lock();

    public static LibraryManager getInstance() {
        return instance;
    }

    private LibraryManager() {
    }

    public void shutdown() {
        this.librariesEntries.clear();
    }

    public List<LibProjectImpl> getLibraries(ProjectImpl projectImpl) {
        ArrayList<LibProjectImpl> arrayList = new ArrayList<LibProjectImpl>();
        CsmUID<CsmProject> csmUID = projectImpl.getUID();
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            LibProjectImpl libProjectImpl;
            if (!libraryEntry.containsProject((CsmUID<CsmProject>)csmUID) || (libProjectImpl = (LibProjectImpl)libraryEntry.getLibrary().getObject()) == null) continue;
            arrayList.add(libProjectImpl);
        }
        return arrayList;
    }

    public Collection<CsmUID<CsmProject>> getLirariesKeys(CsmUID<CsmProject> csmUID) {
        ArrayList<CsmUID<CsmProject>> arrayList = new ArrayList<CsmUID<CsmProject>>();
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            if (!libraryEntry.containsProject((CsmUID<CsmProject>)csmUID)) continue;
            arrayList.add((CsmUID<CsmProject>)libraryEntry.getLibrary());
        }
        return arrayList;
    }

    private void trace(String string, FileImpl fileImpl, ResolvedPath resolvedPath, ProjectBase projectBase, ProjectBase projectBase2) {
        System.out.println("Resolved Path " + resolvedPath.getPath());
        System.out.println("    start project " + projectBase2);
        System.out.println("    found in " + string + " " + projectBase);
        System.out.println("    included from " + fileImpl);
        System.out.println("    file from project " + fileImpl.getProject());
        for (CsmProject csmProject : projectBase2.getLibraries()) {
            System.out.println("    search lib " + csmProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase resolveFileProjectOnInclude(ProjectBase projectBase, FileImpl fileImpl, ResolvedPath resolvedPath) {
        String string = ((Object)resolvedPath.getPath()).toString();
        File file = new File(string);
        ProjectBase projectBase2 = this.searchInProjectFiles(projectBase, file);
        if (projectBase2 != null) {
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Projects", fileImpl, resolvedPath, projectBase2, projectBase);
            }
            return projectBase2;
        }
        String string2 = CndFileUtils.normalizeAbsolutePath((String)((Object)resolvedPath.getFolder()).toString());
        projectBase2 = this.searchInProjectRoots(projectBase, this.getPathToFolder(string2, string));
        if (projectBase2 != null) {
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Projects roots", fileImpl, resolvedPath, projectBase2, projectBase);
            }
            return projectBase2;
        }
        projectBase2 = this.searchInProjectFilesArtificial(projectBase, file);
        if (projectBase2 != null) {
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Libraries", fileImpl, resolvedPath, projectBase2, projectBase);
            }
            return projectBase2;
        }
        Object object = this.lock;
        synchronized (object) {
            projectBase2 = this.searchInProjectRootsArtificial(projectBase, this.getPathToFolder(string2, string));
            if (projectBase2 == null) {
                if (resolvedPath.isDefaultSearchPath()) {
                    projectBase2 = fileImpl.getProjectImpl(true);
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Base Project as Default Search Path", fileImpl, resolvedPath, projectBase2, projectBase);
                    }
                } else if (!projectBase.isArtificial()) {
                    projectBase2 = this.getLibrary((ProjectImpl)projectBase, string2);
                    if (projectBase2 == null) {
                        if (CndUtils.isDebugMode()) {
                            this.trace("Not created library for folder " + string2, fileImpl, resolvedPath, projectBase2, projectBase);
                        }
                        projectBase2 = projectBase;
                    }
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Library for folder " + string2, fileImpl, resolvedPath, projectBase2, projectBase);
                    }
                } else {
                    projectBase2 = projectBase;
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Base Project", fileImpl, resolvedPath, projectBase2, projectBase);
                    }
                }
            } else if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Libraries roots", fileImpl, resolvedPath, projectBase2, projectBase);
            }
        }
        return projectBase2;
    }

    private List<String> getPathToFolder(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        if (string2.startsWith(string)) {
            String string3;
            for (File file = CndFileUtils.normalizeFile((File)new File(string2)); file != null && !string.equals(string3 = file.getParent()) && string3.startsWith(string); file = file.getParentFile()) {
                arrayList.add(string3);
                if (arrayList.size() == 3) break;
            }
        }
        return arrayList;
    }

    private ProjectBase searchInProjectFiles(ProjectBase projectBase, File file) {
        return this.searchInProjectFiles(projectBase, file, new HashSet<ProjectBase>());
    }

    private ProjectBase searchInProjectFiles(ProjectBase projectBase, File file, Set<ProjectBase> set) {
        CsmProject csmProject;
        if (set.contains(projectBase)) {
            return null;
        }
        set.add(projectBase);
        projectBase.ensureFilesCreated();
        FileImpl fileImpl = projectBase.getFile(file, true);
        if (fileImpl != null) {
            return projectBase;
        }
        Collection collection = projectBase.getLibraries();
        int n = collection.size();
        for (int i = 0; i < n && !(csmProject = (CsmProject)collection.get(i)).isArtificial(); ++i) {
            ((ProjectBase)csmProject).ensureFilesCreated();
            ProjectBase projectBase2 = this.searchInProjectFiles((ProjectBase)csmProject, file, set);
            if (projectBase2 == null) continue;
            return projectBase2;
        }
        return null;
    }

    private ProjectBase searchInProjectFilesArtificial(ProjectBase projectBase, File file) {
        Collection collection = projectBase.getLibraries();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            CsmProject csmProject = (CsmProject)collection.get(i);
            if (!csmProject.isArtificial()) continue;
            ((ProjectBase)csmProject).ensureFilesCreated();
            ProjectBase projectBase2 = this.searchInProjectFiles((ProjectBase)csmProject, file);
            if (projectBase2 == null) continue;
            return projectBase2;
        }
        return null;
    }

    private ProjectBase searchInProjectRoots(ProjectBase projectBase, List<String> list) {
        return this.searchInProjectRoots(projectBase, list, new HashSet<ProjectBase>());
    }

    private ProjectBase searchInProjectRoots(ProjectBase projectBase, List<String> list, HashSet<ProjectBase> hashSet) {
        CsmProject csmProject;
        if (hashSet.contains(projectBase)) {
            return null;
        }
        hashSet.add(projectBase);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (!projectBase.isMySource(string)) continue;
            return projectBase;
        }
        Collection collection = projectBase.getLibraries();
        int n2 = collection.size();
        for (int i = 0; i < n2 && !(csmProject = (CsmProject)collection.get(i)).isArtificial(); ++i) {
            ProjectBase projectBase2 = this.searchInProjectRoots((ProjectBase)csmProject, list, hashSet);
            if (projectBase2 == null) continue;
            return projectBase2;
        }
        return null;
    }

    private ProjectBase searchInProjectRootsArtificial(ProjectBase projectBase, List<String> list) {
        Collection collection = projectBase.getLibraries();
        int n = collection.size();
        ProjectBase projectBase2 = null;
        for (int i = 0; i < n; ++i) {
            ProjectBase projectBase3;
            CsmProject csmProject = (CsmProject)collection.get(i);
            if (!csmProject.isArtificial() || (projectBase3 = this.searchInProjectRoots((ProjectBase)csmProject, list)) == null) continue;
            if (projectBase2 == null) {
                projectBase2 = projectBase3;
                continue;
            }
            CharSequence charSequence = ((LibProjectImpl)projectBase2).getPath();
            CharSequence charSequence2 = ((LibProjectImpl)projectBase3).getPath();
            if (charSequence2.length() <= charSequence.length()) continue;
            projectBase2 = projectBase3;
        }
        return projectBase2;
    }

    private LibProjectImpl getLibrary(ProjectImpl projectImpl, String string) {
        CsmUID<CsmProject> csmUID = projectImpl.getUID();
        LibraryEntry libraryEntry = this.librariesEntries.get(string);
        if (libraryEntry == null) {
            libraryEntry = this.getOrCreateLibrary(projectImpl.getModel(), string);
        }
        if (!libraryEntry.containsProject((CsmUID<CsmProject>)csmUID)) {
            libraryEntry.addProject((CsmUID<CsmProject>)csmUID);
        }
        return (LibProjectImpl)libraryEntry.getLibrary().getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LibraryEntry getOrCreateLibrary(ModelImpl modelImpl, String string) {
        LibraryEntry libraryEntry = this.librariesEntries.get(string);
        if (libraryEntry == null) {
            boolean bl = false;
            Object object = this.lock;
            synchronized (object) {
                libraryEntry = this.librariesEntries.get(string);
                if (libraryEntry == null) {
                    libraryEntry = new LibraryEntry(string);
                    this.librariesEntries.put(string, libraryEntry);
                    bl = true;
                }
            }
            if (bl) {
                object = libraryEntry;
                ModelImpl.instance().enqueueModelTask(new Runnable((LibraryEntry)object){
                    final /* synthetic */ LibraryEntry val$passEntry;
                    {
                        this.val$passEntry = libraryEntry;
                    }

                    @Override
                    public void run() {
                        ListenersImpl.getImpl().fireProjectOpened((ProjectBase)this.val$passEntry.getLibrary().getObject());
                    }
                }, "postponed library opened " + string);
            }
        }
        return libraryEntry;
    }

    public void onProjectPropertyChanged(CsmUID<CsmProject> csmUID) {
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            libraryEntry.removeProject((CsmUID<CsmProject>)csmUID);
        }
    }

    public void onProjectClose(CsmUID<CsmProject> csmUID) {
        ArrayList<LibraryEntry> arrayList = new ArrayList<LibraryEntry>();
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            libraryEntry.removeProject((CsmUID<CsmProject>)csmUID);
            if (!libraryEntry.isEmpty()) continue;
            arrayList.add(libraryEntry);
        }
        if (arrayList.size() > 0) {
            for (LibraryEntry libraryEntry : arrayList) {
                this.librariesEntries.remove(libraryEntry.getFolder());
            }
        }
        this.closeLibraries(arrayList);
    }

    final void cleanLibrariesData(Collection<LibProjectImpl> collection) {
        for (LibProjectImpl libProjectImpl : collection) {
            this.librariesEntries.remove(((Object)libProjectImpl.getPath()).toString());
            UIDManager.instance().clearProjectCache(RepositoryUtils.UIDtoKey(libProjectImpl.getUID()));
            libProjectImpl.dispose(true);
        }
    }

    private void closeLibraries(Collection<LibraryEntry> collection) {
        ModelImpl modelImpl = (ModelImpl)CsmModelAccessor.getModel();
        for (LibraryEntry libraryEntry : collection) {
            CsmUID csmUID = libraryEntry.getLibrary();
            ProjectBase projectBase = (ProjectBase)csmUID.getObject();
            assert (projectBase != null) : "Null project for UID " + csmUID;
            modelImpl.disposeProject(projectBase);
        }
    }

    void writeProjectLibraries(CsmUID<CsmProject> csmUID, DataOutput dataOutput) throws IOException {
        assert (dataOutput != null);
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
        for (LibraryEntry libraryEntry : this.librariesEntries.values()) {
            if (!libraryEntry.containsProject((CsmUID<CsmProject>)csmUID)) continue;
            hashSet.add(FilePathCache.getManager().getString((CharSequence)libraryEntry.getFolder()));
        }
        PersistentUtils.writeCollectionStrings(hashSet, dataOutput);
    }

    void readProjectLibraries(CsmUID<CsmProject> csmUID, DataInput dataInput) throws IOException {
        ModelImpl modelImpl = (ModelImpl)CsmModelAccessor.getModel();
        assert (dataInput != null);
        Collection<CharSequence> collection = PersistentUtils.readCollectionStrings(dataInput, FilePathCache.getManager());
        for (CharSequence charSequence : collection) {
            LibraryEntry libraryEntry = this.getOrCreateLibrary(modelImpl, ((Object)charSequence).toString());
            libraryEntry.addProject((CsmUID<CsmProject>)csmUID);
        }
    }

    private static class LibraryEntry {
        private String folder;
        private CsmUID<CsmProject> libraryUID;
        private ConcurrentMap<CsmUID<CsmProject>, Boolean> dependentProjects;

        private LibraryEntry(String string) {
            this.folder = string;
            this.dependentProjects = new ConcurrentHashMap<CsmUID<CsmProject>, Boolean>();
        }

        private String getFolder() {
            return this.folder;
        }

        private CsmUID<CsmProject> getLibrary() {
            if (this.libraryUID == null) {
                this.createUID();
            }
            return this.libraryUID;
        }

        private synchronized void createUID() {
            if (this.libraryUID == null) {
                ModelImpl modelImpl = (ModelImpl)CsmModelAccessor.getModel();
                LibProjectImpl libProjectImpl = LibProjectImpl.createInstance(modelImpl, this.folder);
                this.libraryUID = libProjectImpl.getUID();
            }
        }

        private boolean isEmpty() {
            return this.dependentProjects.size() == 0;
        }

        private boolean containsProject(CsmUID<CsmProject> csmUID) {
            return this.dependentProjects.containsKey(csmUID);
        }

        private void addProject(CsmUID<CsmProject> csmUID) {
            this.dependentProjects.put(csmUID, Boolean.TRUE);
        }

        private void removeProject(CsmUID<CsmProject> csmUID) {
            this.dependentProjects.remove(csmUID);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

