/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.Graphics;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import javax.swing.JPanel;

public class SVGImageComponent
extends JPanel {
    private SVGImage image;
    private int originalVieportWidth;
    private int originalVieportHeight;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int correctionX = 0;
    private int correctionY = 0;

    public SVGImageComponent() {
        this.setOpaque(false);
    }

    public SVGImage getImage() {
        return this.image;
    }

    public void setImage(SVGImage image) {
        SVGImage old = this.image;
        if (old == image) {
            return;
        }
        this.image = image;
        if (image != null) {
            this.originalVieportWidth = image.getViewportWidth();
            this.originalVieportHeight = image.getViewportHeight();
        }
        this.firePropertyChange("svg-image", old, image);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.image != null) {
            this.updateScale();
            if (this.getHeight() < this.originalVieportHeight || this.getWidth() < this.originalVieportWidth) {
                this.image.setViewportHeight(this.getHeight());
                this.image.setViewportWidth(this.getWidth());
            } else {
                this.image.setViewportHeight(this.originalVieportHeight);
                this.image.setViewportWidth(this.originalVieportWidth);
            }
            ScalableGraphics gr = ScalableGraphics.createInstance();
            gr.bindTarget((Object)g);
            gr.render(0, 0, (ScalableImage)this.image);
            gr.releaseTarget();
        }
    }

    protected float getScaleX() {
        return this.scaleX;
    }

    protected float getScaleY() {
        return this.scaleY;
    }

    protected int getCorrectionX() {
        return this.correctionX;
    }

    protected int getCorrectionY() {
        return this.correctionY;
    }

    private void updateScale() {
        assert (this.image != null);
        if (this.getHeight() < this.originalVieportHeight || this.getWidth() < this.originalVieportWidth) {
            float sx = (float)this.getWidth() / (float)this.originalVieportWidth;
            float sy = (float)this.getHeight() / (float)this.originalVieportHeight;
            this.scaleY = this.scaleX = Math.min(sx, sy);
            if (sy < sx) {
                int realViewWidth = (int)((float)this.originalVieportWidth * this.scaleY);
                this.correctionX = (this.getWidth() - realViewWidth) / 2;
                this.correctionY = 0;
            } else {
                this.correctionX = 0;
                int realViewHeight = (int)((float)this.originalVieportHeight * this.scaleX);
                this.correctionY = (this.getHeight() - realViewHeight) / 2;
            }
        } else {
            this.scaleX = 1.0f;
            this.scaleY = 1.0f;
            this.correctionX = 0;
            this.correctionY = 0;
        }
    }
}

