/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

public final class RubyEmbeddingProvider
extends EmbeddingProvider {
    public static final String RUBY_MIMETYPE = "text/x-ruby";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        List<Embedding> ems = this.extractRuby(snapshot);
        if (ems.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(ems));
    }

    public int getPriority() {
        return 10;
    }

    public void cancel() {
    }

    private List<Embedding> extractRuby(Snapshot snapshot) {
        ArrayList<Embedding> ems = new ArrayList<Embedding>(40);
        ems.add(snapshot.create((CharSequence)"class ActionView::Base\n", RUBY_MIMETYPE));
        ems.add(snapshot.create((CharSequence)"_buf='';", RUBY_MIMETYPE));
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)snapshot.getText(), RhtmlTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        boolean skipNewline = false;
        while (tokenSequence.moveNext()) {
            String text;
            int sourceEnd;
            int sourceStart;
            Token token = tokenSequence.token();
            if (token.id() == RhtmlTokenId.HTML) {
                int i;
                sourceStart = token.offset(tokenHierarchy);
                sourceEnd = sourceStart + token.length();
                text = ((Object)token.text()).toString();
                boolean found = false;
                for (i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '\n') {
                        ++i;
                        found = true;
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                if (found) {
                    ems.add(snapshot.create((CharSequence)text.substring(0, i), RUBY_MIMETYPE));
                    text = text.substring(i);
                } else {
                    ems.add(snapshot.create((CharSequence)";", RUBY_MIMETYPE));
                }
                ems.add(snapshot.create((CharSequence)"_buf << '", RUBY_MIMETYPE));
                if (skipNewline && text.startsWith("\n")) {
                    text = text.substring(1);
                    --sourceEnd;
                }
                text = text.replace("'", "\\'");
                ems.add(snapshot.create((CharSequence)text, RUBY_MIMETYPE));
                ems.add(snapshot.create((CharSequence)"';\n", RUBY_MIMETYPE));
                skipNewline = false;
                continue;
            }
            if (token.id() == RhtmlTokenId.RUBY) {
                sourceStart = token.offset(tokenHierarchy);
                sourceEnd = sourceStart + token.length();
                text = ((Object)token.text()).toString();
                skipNewline = false;
                if (text.endsWith("-")) {
                    skipNewline = true;
                }
                ems.add(snapshot.create(sourceStart, sourceEnd - sourceStart - (skipNewline ? 1 : 0), RUBY_MIMETYPE));
                if (tokenSequence.moveNext()) {
                    int delimiterEnd;
                    Token nextToken = tokenSequence.token();
                    if (nextToken != null && nextToken.id() == RhtmlTokenId.DELIMITER && (delimiterEnd = tokenSequence.offset() + nextToken.length()) <= snapshot.getText().length()) {
                        char c;
                        for (int i = delimiterEnd; i < snapshot.getText().length() && (c = snapshot.getText().charAt(i)) != '\n'; ++i) {
                            if (Character.isWhitespace(c)) continue;
                            ems.add(snapshot.create((CharSequence)";", RUBY_MIMETYPE));
                            break;
                        }
                    }
                    tokenSequence.movePrevious();
                }
                skipNewline = false;
                continue;
            }
            if (token.id() != RhtmlTokenId.RUBY_EXPR) continue;
            ems.add(snapshot.create((CharSequence)"_buf << (", RUBY_MIMETYPE));
            sourceStart = token.offset(tokenHierarchy);
            sourceEnd = sourceStart + token.length();
            text = ((Object)token.text()).toString();
            skipNewline = false;
            if (text.endsWith("-")) {
                skipNewline = true;
            }
            ems.add(snapshot.create(sourceStart, sourceEnd - sourceStart - (skipNewline ? 1 : 0), RUBY_MIMETYPE));
            ems.add(snapshot.create((CharSequence)").to_s;", RUBY_MIMETYPE));
        }
        ems.add(snapshot.create((CharSequence)"\nend\n", RUBY_MIMETYPE));
        return ems;
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (snapshot.getSource().getMimeType().equals("application/x-httpd-eruby")) {
                return Collections.singleton(new RubyEmbeddingProvider());
            }
            return Collections.emptyList();
        }
    }
}

