/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.indent.FortranIndentSupport;
import org.netbeans.modules.cnd.editor.fortran.indent.TokenItem;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;

public class FortranIndentTask
extends FortranIndentSupport
implements IndentTask {
    private Context context;
    private Document doc;

    public FortranIndentTask(Context context) {
        this.context = context;
        this.doc = context.document();
    }

    public void reindent() throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = FortranCodeStyle.get(this.doc);
        }
        this.codeStyle.setupLexerAttributes(this.doc);
        int caretOffset = this.context.caretOffset();
        int lineOffset = this.context.lineStartOffset(caretOffset);
        this.ts = CndLexerUtilities.getFortranTokenSequence((Document)this.doc, (int)lineOffset);
        if (this.ts == null || !this.ts.moveNext()) {
            return;
        }
        int indent = this.indentLine(new TokenItem((TokenSequence<FortranTokenId>)this.ts), caretOffset);
        if (indent >= 0) {
            this.context.modifyIndent(lineOffset, indent);
        }
    }

    public ExtraLock indentLock() {
        return null;
    }

    public int indentLine(TokenItem token, int caretOffset) {
        if (this.isFixedFormatComment(token = this.moveToFirstLineImportantToken(token)) || this.isPreprocessor(token)) {
            return 0;
        }
        if (this.isFreeFormatComment(token)) {
            return this.findIndent(token);
        }
        if (this.isFixedFormatLabel(token)) {
            TokenItem nexToken = token.getNext();
            while (nexToken.getTokenID() == this.getWhitespaceTokenID()) {
                TokenItem nt = nexToken.getNext();
                this.removeToken(nexToken);
                nexToken = nt;
            }
            int indent = this.findInlineSpacing(token);
            for (int i = 0; i < indent - 5; ++i) {
                this.insertToken(nexToken, this.getWhitespaceTokenID(), " ");
            }
            return 1;
        }
        if (this.isFixedFormatLineContinuation(token)) {
            TokenItem nexToken = token.getNext();
            while (nexToken.getTokenID() == this.getWhitespaceTokenID()) {
                TokenItem nt = nexToken.getNext();
                this.removeToken(nexToken);
                nexToken = nt;
            }
            int indent = this.findInlineSpacing(token);
            for (int i = 0; i < indent - 5; ++i) {
                this.insertToken(nexToken, this.getWhitespaceTokenID(), " ");
            }
            return 5;
        }
        if (!this.getFreeFormat() && token.getTokenID() == FortranTokenId.KW_SUBROUTINE || token.getTokenID() == FortranTokenId.KW_ENTRY || token.getTokenID() == FortranTokenId.KW_FUNCTION) {
            return 6;
        }
        int indent = this.findIndent(token);
        if (!this.getFreeFormat() && indent < 6) {
            indent = 6;
        }
        return indent;
    }

    public void insertToken(TokenItem beforeToken, FortranTokenId tokenID, String tokenImage) {
    }

    public void removeToken(TokenItem token) {
    }

    public int findIndent(TokenItem token) {
        int indent = -1;
        if (token == null) {
            return 0;
        }
        TokenItem matchToken = null;
        switch (token.getTokenID()) {
            case KW_CASE: 
            case KW_DEFAULT: {
                matchToken = this.findMatchingToken(token, FortranTokenId.KW_SELECT, FortranTokenId.KW_ENDSELECT);
                if (matchToken == null) {
                    matchToken = this.findMatchingToken(token, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_ENDSELECT);
                }
                if (matchToken == null) break;
                indent = this.getTokenIndent(matchToken) + this.getShiftWidth();
                break;
            }
            case KW_PROGRAM: 
            case KW_ENDPROGRAM: {
                indent = 0;
                break;
            }
            case KW_END: {
                TokenItem nextToken = token.getNext();
                if (nextToken == null) {
                    if (this.getFreeFormat()) {
                        indent = 0;
                        break;
                    }
                    indent = 6;
                    break;
                }
                if (nextToken.getTokenID() == FortranTokenId.WHITESPACE) {
                    nextToken = nextToken.getNext();
                }
                if (nextToken == null) {
                    indent = 0;
                    break;
                }
                if (nextToken.getTokenID() == FortranTokenId.NEW_LINE) {
                    indent = 0;
                    break;
                }
                switch (nextToken.getTokenID()) {
                    case KW_IF: 
                    case KW_ELSE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_IF, FortranTokenId.KW_ENDIF);
                        break;
                    }
                    case KW_BLOCK: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_BLOCK, FortranTokenId.KW_ENDBLOCK);
                        if (matchToken != null) break;
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_BLOCKDATA: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_DO: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_DO, FortranTokenId.KW_ENDDO);
                        break;
                    }
                    case KW_FORALL: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_FORALL, FortranTokenId.KW_ENDFORALL);
                        break;
                    }
                    case KW_FUNCTION: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_FUNCTION, FortranTokenId.KW_ENDFUNCTION);
                        break;
                    }
                    case KW_INTERFACE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_INTERFACE, FortranTokenId.KW_ENDINTERFACE);
                        break;
                    }
                    case KW_MAP: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_MAP, FortranTokenId.KW_ENDMAP);
                        break;
                    }
                    case KW_MODULE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_MODULE, FortranTokenId.KW_ENDMODULE);
                        break;
                    }
                    case KW_PROGRAM: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_PROGRAM, FortranTokenId.KW_ENDPROGRAM);
                        break;
                    }
                    case KW_SELECT: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_SELECT, FortranTokenId.KW_ENDSELECT);
                        if (matchToken != null) break;
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_ENDSELECT);
                        break;
                    }
                    case KW_STRUCTURE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_STRUCTURE, FortranTokenId.KW_ENDSTRUCTURE);
                        break;
                    }
                    case KW_SUBROUTINE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_ENDSUBROUTINE);
                        break;
                    }
                    case KW_TYPE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_TYPE, FortranTokenId.KW_ENDTYPE);
                        break;
                    }
                    case KW_ENUM: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_ENUM, FortranTokenId.KW_ENDENUM);
                        break;
                    }
                    case KW_UNION: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_UNION, FortranTokenId.KW_ENDUNION);
                        break;
                    }
                    case KW_WHERE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_WHERE, FortranTokenId.KW_ENDWHERE);
                        break;
                    }
                    case KW_WHILE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_WHILE, FortranTokenId.KW_ENDWHILE);
                    }
                }
                if (matchToken == null) break;
                indent = this.getTokenIndent(matchToken);
                break;
            }
            default: {
                switch (token.getTokenID()) {
                    case KW_ELSE: 
                    case KW_ELSEIF: 
                    case KW_ENDIF: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_IF, FortranTokenId.KW_ENDIF);
                        if (matchToken != null) break;
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_WHERE, FortranTokenId.KW_ENDWHERE);
                        break;
                    }
                    case KW_ENDBLOCK: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_BLOCK, FortranTokenId.KW_ENDBLOCK);
                        if (matchToken != null) break;
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_ENDBLOCKDATA: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_ENDBLOCKDATA);
                        break;
                    }
                    case KW_ENDDO: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_DO, FortranTokenId.KW_ENDDO);
                        break;
                    }
                    case KW_ENDFORALL: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_FORALL, FortranTokenId.KW_ENDFORALL);
                        break;
                    }
                    case KW_ENDFUNCTION: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_FUNCTION, FortranTokenId.KW_ENDFUNCTION);
                        break;
                    }
                    case KW_ENDINTERFACE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_INTERFACE, FortranTokenId.KW_ENDINTERFACE);
                        break;
                    }
                    case KW_ENDMAP: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_MAP, FortranTokenId.KW_ENDMAP);
                        break;
                    }
                    case KW_ENDMODULE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_MODULE, FortranTokenId.KW_ENDMODULE);
                        break;
                    }
                    case KW_ENDSELECT: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_SELECT, FortranTokenId.KW_ENDSELECT);
                        if (matchToken != null) break;
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_ENDSELECT);
                        break;
                    }
                    case KW_ENDSTRUCTURE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_STRUCTURE, FortranTokenId.KW_ENDSTRUCTURE);
                        break;
                    }
                    case KW_ENDSUBROUTINE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_ENDSUBROUTINE);
                        break;
                    }
                    case KW_ENDTYPE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_TYPE, FortranTokenId.KW_ENDTYPE);
                        break;
                    }
                    case KW_ENDENUM: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_ENUM, FortranTokenId.KW_ENDENUM);
                        break;
                    }
                    case KW_ENDUNION: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_UNION, FortranTokenId.KW_ENDUNION);
                        break;
                    }
                    case KW_ENDWHERE: 
                    case KW_ELSEWHERE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_WHERE, FortranTokenId.KW_ENDWHERE);
                        break;
                    }
                    case KW_ENDWHILE: {
                        matchToken = this.findMatchingToken(token, FortranTokenId.KW_WHILE, FortranTokenId.KW_ENDWHILE);
                    }
                }
                if (matchToken == null) break;
                indent = this.getTokenIndent(matchToken);
            }
        }
        if (indent < 0) {
            TokenItem impToken = this.findImportantToken(token, null, true);
            TokenItem startToken = this.findLineStartToken(impToken);
            if (startToken == null) {
                return 0;
            }
            while (this.isFixedFormatLineContinuation(startToken) || this.isPreprocessor(startToken) || startToken.getTokenID() == FortranTokenId.KW_ENTRY) {
                impToken = this.findImportantToken(startToken, null, true);
                if ((startToken = this.findLineStartToken(impToken)) != null) continue;
                return 0;
            }
            if (impToken != null) {
                while (this.isFixedFormatLabel(startToken) || startToken.getTokenID() == FortranTokenId.WHITESPACE) {
                    if ((startToken = startToken.getNext()) != null) continue;
                    return 0;
                }
                block44 : switch (startToken.getTokenID()) {
                    case KW_DO: {
                        if (!this.getFreeFormat()) {
                            TokenItem nexToken = startToken.getNext();
                            while (nexToken.getTokenID() == FortranTokenId.WHITESPACE) {
                                nexToken = nexToken.getNext();
                            }
                            if (nexToken.getTokenID() == FortranTokenId.NUM_LITERAL_INT) {
                                indent = this.getTokenIndent(startToken);
                                break;
                            }
                        }
                        indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                        break;
                    }
                    case KW_ELSE: 
                    case KW_BLOCK: 
                    case KW_BLOCKDATA: 
                    case KW_FORALL: 
                    case KW_FUNCTION: 
                    case KW_INTERFACE: 
                    case KW_MAP: 
                    case KW_PROGRAM: 
                    case KW_SELECT: 
                    case KW_STRUCTURE: 
                    case KW_SUBROUTINE: 
                    case KW_ENUM: 
                    case KW_UNION: 
                    case KW_WHERE: 
                    case KW_ELSEWHERE: 
                    case KW_CASE: 
                    case KW_RECURSIVE: 
                    case KW_DOUBLEPRECISION: 
                    case KW_SELECTCASE: {
                        indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                        break;
                    }
                    case KW_TYPE: {
                        TokenItem next = this.findImportantToken(startToken.getNext(), null, false);
                        if (next != null && next.getTokenID() == FortranTokenId.LPAREN) {
                            indent = this.getTokenIndent(startToken);
                            break;
                        }
                        indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                        break;
                    }
                    case KW_MODULE: {
                        TokenItem next = this.findImportantToken(startToken.getNext(), null, false);
                        if (next != null) {
                            switch (next.getTokenID()) {
                                case KW_FUNCTION: 
                                case KW_SUBROUTINE: 
                                case KW_PROCEDURE: {
                                    indent = this.getTokenIndent(startToken);
                                    break block44;
                                }
                            }
                            indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                            break;
                        }
                        indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                        break;
                    }
                    case KW_ELSEIF: {
                        indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                        break;
                    }
                    case KW_IF: {
                        if (this.isIfThenStatement(startToken)) {
                            indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                            break;
                        }
                        indent = this.getTokenIndent(startToken);
                        break;
                    }
                    default: {
                        indent = this.getTokenIndent(startToken);
                    }
                }
                if (indent < 0) {
                    indent = this.getTokenIndent(impToken);
                }
            }
        }
        if (indent < 0) {
            indent = 0;
        }
        return indent;
    }

    public FortranIndentTask(Document doc) {
        this.doc = doc;
    }

    public void reindent(int caretOffset) throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = FortranCodeStyle.get(this.doc);
        }
        int lineOffset = IndentUtils.lineStartOffset((Document)this.doc, (int)caretOffset);
        this.ts = CndLexerUtilities.getFortranTokenSequence((Document)this.doc, (int)lineOffset);
        if (this.ts == null || !this.ts.moveNext() && !this.ts.movePrevious()) {
            return;
        }
        int indent = this.indentLine(new TokenItem((TokenSequence<FortranTokenId>)this.ts), caretOffset);
        if (indent >= 0) {
            this.modifyIndent(lineOffset, indent);
        }
    }

    private void modifyIndent(int lineStartOffset, int newIndent) throws BadLocationException {
        char ch;
        int oldIndentEndOffset;
        int indent = 0;
        int tabSize = -1;
        String docText = this.doc.getText(0, this.doc.getLength());
        for (oldIndentEndOffset = lineStartOffset; oldIndentEndOffset < docText.length() && (ch = docText.charAt(oldIndentEndOffset)) != '\n'; ++oldIndentEndOffset) {
            if (ch == '\t') {
                if (tabSize == -1) {
                    tabSize = IndentUtils.tabSize((Document)this.doc);
                }
                indent = (indent + tabSize) / tabSize * tabSize;
                continue;
            }
            if (!Character.isWhitespace(ch)) break;
            ++indent;
        }
        String newIndentString = IndentUtils.createIndentString((Document)this.doc, (int)newIndent);
        int offset = lineStartOffset;
        for (int i = 0; i < newIndentString.length() && lineStartOffset + i < oldIndentEndOffset; ++i) {
            if (newIndentString.charAt(i) == docText.charAt(lineStartOffset + i)) continue;
            offset = lineStartOffset + i;
            newIndentString = newIndentString.substring(i);
            break;
        }
        if (offset < oldIndentEndOffset) {
            this.doc.remove(offset, oldIndentEndOffset - offset);
        }
        if (newIndentString.length() > 0) {
            this.doc.insertString(offset, newIndentString, null);
        }
    }
}

