/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui.support;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.identity.profile.ui.support.J2eeProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SunDDHelper {
    private static final String SUN_WEB_APP_TAG = "sun-web-app";
    private static final String HTTPSERVLET_SECURITY_PROVIDER = "httpservlet-security-provider";
    private static final String AM_HTTP_PROVIDER = "AMHttpProvider";
    private static final String SECURITY_ROLE_MAPPING_TAG = "security-role-mapping";
    private static final String ROLE_NAME_TAG = "role-name";
    private static final String PRINCIPAL_NAME_TAG = "principal-name";
    private static final String SERVLET_TAG = "servlet";
    private static final String SERVLET_NAME_TAG = "servlet-name";
    private static final String ENTERPRISE_BEANS_TAG = "enterprise-beans";
    private static final String EJB_TAG = "ejb";
    private static final String EJB_NAME_TAG = "ejb-name";
    private static final String SUN_APPLICATION_CLIENT_TAG = "sun-application-client";
    private static final String SERVICE_REF_TAG = "service-ref";
    private static final String SERVICE_REF_NAME_TAG = "service-ref-name";
    private static final String WEBSERVICE_ENDPOINT_TAG = "webservice-endpoint";
    private static final String PORT_COMPONENT_NAME_TAG = "port-component-name";
    private static final String PORT_INFO_TAG = "port-info";
    private static final String WSDL_PORT_TAG = "wsdl-port";
    private static final String NAMESPACE_URI_TAG = "namespaceURI";
    private static final String LOCALPART_TAG = "localpart";
    private static final String MESSAGE_SECURITY_BINDING_TAG = "message-security-binding";
    private static final String MESSAGE_SECURITY_TAG = "message-security";
    private static final String MESSAGE_TAG = "message";
    private static final String REQUEST_PROTECTION_TAG = "request-protection";
    private static final String RESPONSE_PROTECTION_TAG = "response-protection";
    private static final String AUTH_LAYER_ATTR = "auth-layer";
    private static final String PROVIDER_ID_ATTR = "provider-id";
    private static final String AUTH_SOURCE_ATTR = "auth-source";
    private static final String AM_SERVER_PROVIDER_PREFIX = "AMServerProvider-";
    private static final String AM_CLIENT_PROVIDER = "AMClientProvider";
    private static final String REQUEST_POLICY_AUTH_SOURCE = "content";
    private static final String RESPONSE_POLICY_AUTH_SOURCE = "content";
    private static final String AUTH_LAYER = "SOAP";
    private static final String AUTHENTICATED_USERS = "AUTHENTICATED_USERS";
    private static final String CONTEXT_ROOT_TAG = "context-root";
    private static final String CLASS_LOADER_TAG = "class-loader";
    private static final String SUN_WEB_SYSTEM_ID_2_4 = "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-1.dtd";
    private static final String SUN_WEB_SYSTEM_ID_2_5 = "http://www.sun.com/software/appserver/dtds/sun-web-app_2_5-0.dtd";
    private static final String SUN_EJB_SYSTEM_ID_3_0 = "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_0-0.dtd";
    private static final String SUN_APPCLIENT_SYSTEM_ID_5_0 = "http://www.sun.com/software/appserver/dtds/sun-application-client_5_0-0.dtd";
    private static final String SUN_WEB_DTD_2_4 = "resources/sun-web-app_2_4-1.dtd";
    private static final String SUN_WEB_DTD_2_5 = "resources/sun-web-app_2_5-0.dtd";
    private static final String SUN_EJB_DTD_3_0 = "resources/sun-ejb-jar_3_0-0.dtd";
    private static final String SUN_APPCLIENT_DTD_5_0 = "resources/sun-application-client_5_0-0.dtd";
    private static final String IDENT = "    ";
    private static int TIME_TO_WAIT = 300;
    private FileObject sunDD;
    private Document document;
    private J2eeProjectHelper.ProjectType type;

    public SunDDHelper(FileObject fileObject, J2eeProjectHelper.ProjectType projectType) {
        this.sunDD = fileObject;
        this.type = projectType;
    }

    public void addSecurityRoleMapping() {
        Element element;
        boolean bl = false;
        Element element2 = this.getRootElement();
        String string = element2.getAttribute(HTTPSERVLET_SECURITY_PROVIDER);
        if (string == null || !string.equals(AM_HTTP_PROVIDER)) {
            element2.setAttribute(HTTPSERVLET_SECURITY_PROVIDER, AM_HTTP_PROVIDER);
            bl = true;
        }
        if ((element = this.getSecurityRoleMapping(AUTHENTICATED_USERS)) == null) {
            element2.appendChild(this.createSecurityRoleMapping(AUTHENTICATED_USERS));
            bl = true;
        } else {
            Element element3 = this.getPrincipalName(element, AUTHENTICATED_USERS);
            if (element3 == null) {
                element.appendChild(this.createElement(PRINCIPAL_NAME_TAG, AUTHENTICATED_USERS));
                bl = true;
            }
        }
        if (bl) {
            this.writeDocument();
        }
    }

    public void removeSecurityRoleMapping() {
        Element element;
        boolean bl = false;
        Element element2 = this.getRootElement();
        String string = element2.getAttribute(HTTPSERVLET_SECURITY_PROVIDER);
        if (string != null && string.equals(AM_HTTP_PROVIDER)) {
            element2.removeAttribute(HTTPSERVLET_SECURITY_PROVIDER);
            bl = true;
        }
        if ((element = this.getSecurityRoleMapping(AUTHENTICATED_USERS)) != null) {
            Element element3 = this.getPrincipalName(element, AUTHENTICATED_USERS);
            if (element3 != null) {
                element.removeChild(element3);
                bl = true;
            }
            if (element.getElementsByTagName(PRINCIPAL_NAME_TAG).getLength() == 0) {
                element2.removeChild(element);
                bl = true;
            }
        }
        if (bl) {
            this.writeDocument();
        }
    }

    public void setServiceMessageSecurityBinding(String string, String string2, String string3) {
        Element element;
        Element element2;
        Element element3 = this.getRootElement();
        Element element4 = null;
        String string4 = null;
        String string5 = null;
        if (this.type == J2eeProjectHelper.ProjectType.WEB) {
            string4 = SERVLET_TAG;
            string5 = SERVLET_NAME_TAG;
        } else if (this.type == J2eeProjectHelper.ProjectType.EJB) {
            string4 = EJB_TAG;
            string5 = EJB_NAME_TAG;
        }
        element4 = this.getComponentElement(element3, string4, string5, string2);
        if (element4 == null) {
            element4 = this.createComponentElement(string4, string5, string2);
            if (this.type == J2eeProjectHelper.ProjectType.WEB) {
                this.insertSunWebComponent(element3, element4);
            } else {
                element3.appendChild(element4);
            }
        }
        if ((element2 = this.getElement(element4, WEBSERVICE_ENDPOINT_TAG)) == null) {
            element2 = this.createWebServiceEndpointElement(string2);
            element4.appendChild(element2);
        }
        if ((element = this.getElement(element2, MESSAGE_SECURITY_BINDING_TAG)) == null) {
            element = this.createSecurityBindingElement();
            element2.appendChild(element);
        }
        element.setAttribute(PROVIDER_ID_ATTR, AM_SERVER_PROVIDER_PREFIX + string3);
        this.writeDocument();
    }

    public void setServiceRefMessageSecurityBinding(String string, String string2, String string3) {
        Element element;
        Element element2;
        Object object;
        Element element3 = this.getRootElement();
        if (this.type == J2eeProjectHelper.ProjectType.EJB) {
            object = this.getEjbName(string);
            element2 = this.getComponentElement(element3, EJB_TAG, EJB_NAME_TAG, (String)object);
            if (element2 == null) {
                element2 = this.createEjbElement((String)object);
                element3.appendChild(element2);
            }
            element3 = element2;
        }
        if ((object = this.getServiceRefElement(element3, string, string2, string3)) == null) {
            object = this.createServiceRefElement(string, string2, string3);
            if (this.type == J2eeProjectHelper.ProjectType.WEB) {
                this.insertSunWebComponent(element3, (Element)object);
            } else {
                element3.appendChild((Node)object);
            }
        }
        if ((element = this.getElement(element2 = this.getElement((Element)object, PORT_INFO_TAG), MESSAGE_SECURITY_BINDING_TAG)) == null) {
            element = this.createSecurityBindingElement();
            element2.appendChild(element);
        }
        element.setAttribute(PROVIDER_ID_ATTR, AM_CLIENT_PROVIDER);
        this.writeDocument();
    }

    public void removeServiceMessageSecurityBinding(String string, String string2) {
        Element element;
        Element element2 = this.getRootElement();
        Element element3 = null;
        String string3 = null;
        String string4 = null;
        if (this.type == J2eeProjectHelper.ProjectType.WEB) {
            string3 = SERVLET_TAG;
            string4 = SERVLET_NAME_TAG;
        } else if (this.type == J2eeProjectHelper.ProjectType.EJB) {
            string3 = EJB_TAG;
            string4 = EJB_NAME_TAG;
        }
        element3 = this.getComponentElement(element2, string3, string4, string2);
        if (element3 != null && (element = this.getElement(element3, WEBSERVICE_ENDPOINT_TAG)) != null) {
            element3.removeChild(element);
        }
        this.writeDocument();
    }

    public void removeServiceRefMessageSecurityBinding(String string, String string2, String string3) {
        Object object;
        Element element = this.getRootElement();
        if (this.type == J2eeProjectHelper.ProjectType.EJB && (element = this.getComponentElement(element, EJB_TAG, EJB_NAME_TAG, (String)(object = this.getEjbName(string)))) == null) {
            return;
        }
        object = this.getServiceRefElement(element, string, string2, string3);
        if (object != null) {
            element.removeChild((Node)object);
        }
        this.writeDocument();
    }

    public boolean isServiceSecurityEnabled(String string, String string2) {
        Element element;
        Element element2;
        Element element3 = this.getRootElement();
        Element element4 = null;
        String string3 = null;
        String string4 = null;
        if (this.type == J2eeProjectHelper.ProjectType.WEB) {
            string3 = SERVLET_TAG;
            string4 = SERVLET_NAME_TAG;
        } else if (this.type == J2eeProjectHelper.ProjectType.EJB) {
            string3 = EJB_TAG;
            string4 = EJB_NAME_TAG;
        } else {
            return false;
        }
        element4 = this.getComponentElement(element3, string3, string4, string2);
        return element4 != null && (element2 = this.getElement(element4, WEBSERVICE_ENDPOINT_TAG)) != null && (element = this.getElement(element2, MESSAGE_SECURITY_BINDING_TAG)) != null && element.getAttribute(PROVIDER_ID_ATTR).startsWith(AM_SERVER_PROVIDER_PREFIX);
    }

    public boolean isClientSecurityEnabled(String string, String string2, String string3) {
        Object object;
        Element element = this.getRootElement();
        if (this.type == J2eeProjectHelper.ProjectType.EJB && (element = this.getComponentElement(element, EJB_TAG, EJB_NAME_TAG, (String)(object = this.getEjbName(string)))) == null) {
            return false;
        }
        object = this.getServiceRefElement(element, string, string2, string3);
        if (object != null) {
            Element element2 = this.getElement((Element)object, PORT_INFO_TAG);
            Element element3 = this.getElement((Element)object, MESSAGE_SECURITY_BINDING_TAG);
            if (element3 != null && AM_CLIENT_PROVIDER.equals(element3.getAttribute(PROVIDER_ID_ATTR))) {
                return true;
            }
        }
        return false;
    }

    private Element getRootElement() {
        String string = null;
        if (this.type == J2eeProjectHelper.ProjectType.WEB) {
            string = SUN_WEB_APP_TAG;
        } else if (this.type == J2eeProjectHelper.ProjectType.EJB) {
            string = ENTERPRISE_BEANS_TAG;
        } else if (this.type == J2eeProjectHelper.ProjectType.CLIENT) {
            string = SUN_APPLICATION_CLIENT_TAG;
        }
        return this.getElement(string);
    }

    private Element getComponentElement(Element element, String string, String string2, String string3) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Element element3 = (Element)nodeList.item(0);
            NodeList nodeList2 = element3.getElementsByTagName(string2);
            if (nodeList2.getLength() <= 0 || !this.containsValue(element2 = (Element)nodeList2.item(0), string3)) continue;
            return element3;
        }
        return null;
    }

    private Element getServiceRefElement(Element element, String string, String string2, String string3) {
        Document document = this.getDocument();
        NodeList nodeList = document.getElementsByTagName(SERVICE_REF_TAG);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Element element3;
            Element element4;
            Element element5;
            Element element6 = (Element)nodeList.item(i);
            Element element7 = this.getElement(element6, SERVICE_REF_NAME_TAG);
            if (element7 == null || !this.containsValue(element7, string) || (element5 = this.getElement(element6, PORT_INFO_TAG)) == null || (element4 = this.getElement(element5, WSDL_PORT_TAG)) == null || (element3 = this.getElement(element4, NAMESPACE_URI_TAG)) == null || !this.containsValue(element3, string2) || (element2 = this.getElement(element4, LOCALPART_TAG)) == null || !this.containsValue(element2, string3)) continue;
            return element6;
        }
        return null;
    }

    private Element createComponentElement(String string, String string2, String string3) {
        Document document = this.getDocument();
        Element element = document.createElement(string);
        element.appendChild(this.createElement(string2, string3));
        return element;
    }

    private Element createServiceRefElement(String string, String string2, String string3) {
        Document document = this.getDocument();
        Element element = document.createElement(SERVICE_REF_TAG);
        element.appendChild(this.createElement(SERVICE_REF_NAME_TAG, string));
        Element element2 = document.createElement(PORT_INFO_TAG);
        element.appendChild(element2);
        Element element3 = document.createElement(WSDL_PORT_TAG);
        element3.appendChild(this.createElement(NAMESPACE_URI_TAG, string2));
        element3.appendChild(this.createElement(LOCALPART_TAG, string3));
        element2.appendChild(element3);
        return element;
    }

    private Element getElement(String string) {
        Document document = this.getDocument();
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private Element getElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private Element createEjbElement(String string) {
        Document document = this.getDocument();
        Element element = document.createElement(EJB_TAG);
        element.appendChild(this.createElement(EJB_NAME_TAG, string));
        return element;
    }

    private Element createWebServiceEndpointElement(String string) {
        Document document = this.getDocument();
        Element element = document.createElement(WEBSERVICE_ENDPOINT_TAG);
        element.appendChild(this.createElement(PORT_COMPONENT_NAME_TAG, string));
        return element;
    }

    private Element createSecurityBindingElement() {
        Document document = this.getDocument();
        Element element = document.createElement(MESSAGE_SECURITY_BINDING_TAG);
        element.setAttribute(AUTH_LAYER_ATTR, AUTH_LAYER);
        Element element2 = document.createElement(MESSAGE_SECURITY_TAG);
        element2.appendChild(document.createElement(MESSAGE_TAG));
        Element element3 = document.createElement(REQUEST_PROTECTION_TAG);
        element3.setAttribute(AUTH_SOURCE_ATTR, "content");
        element2.appendChild(element3);
        Element element4 = document.createElement(RESPONSE_PROTECTION_TAG);
        element4.setAttribute(AUTH_SOURCE_ATTR, "content");
        element2.appendChild(element4);
        element.appendChild(element2);
        return element;
    }

    private void insertSunWebComponent(Element element, Element element2) {
        Element element3 = this.getElement(element, CLASS_LOADER_TAG);
        element.insertBefore(element2, element3);
    }

    private Element getSecurityRoleMapping(String string) {
        Document document = this.getDocument();
        NodeList nodeList = document.getElementsByTagName(SECURITY_ROLE_MAPPING_TAG);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName(ROLE_NAME_TAG);
            if (nodeList2.getLength() <= 0 || !this.containsValue(element = (Element)nodeList2.item(0), string)) continue;
            return element2;
        }
        return null;
    }

    private Element createSecurityRoleMapping(String string) {
        Document document = this.getDocument();
        Element element = document.createElement(SECURITY_ROLE_MAPPING_TAG);
        Element element2 = this.createElement(ROLE_NAME_TAG, string);
        Element element3 = this.createElement(PRINCIPAL_NAME_TAG, string);
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }

    private Element createElement(String string, String string2) {
        Document document = this.getDocument();
        Element element = document.createElement(string);
        Text text = document.createTextNode(string2);
        element.appendChild(text);
        return element;
    }

    private Element getPrincipalName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(PRINCIPAL_NAME_TAG);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!this.containsValue(element2, string)) continue;
            return element2;
        }
        return null;
    }

    private String getEjbName(String string) {
        String string2 = string.substring(0, string.indexOf("/"));
        string2 = string2.substring(string2.lastIndexOf(".") + 1);
        return string2;
    }

    private boolean containsValue(Element element, String string) {
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            return ((Text)node).getWholeText().equals(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument() {
        this.beautify();
        OutputStream outputStream = null;
        try {
            Document document = this.getDocument();
            DocumentType documentType = document.getDoctype();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            outputStream = new FileOutputStream(FileUtil.toFile((FileObject)this.sunDD));
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.setOutputProperty("doctype-public", documentType.getPublicId());
            transformer.setOutputProperty("doctype-system", documentType.getSystemId());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument() {
        if (this.document == null) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            if (documentBuilder == null) {
                return null;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(FileUtil.toFile((FileObject)this.sunDD));
                this.document = documentBuilder.parse(fileInputStream);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            }
        }
        return this.document;
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setIgnoringComments(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setCoalescing(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new SunDTDResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorManager.getDefault().notify(1, (Throwable)parserConfigurationException);
        }
        return documentBuilder;
    }

    private void beautify() {
        this.beautify(this.getDocument().getDocumentElement(), "\n");
    }

    private void beautify(Node node, String string) {
        int n;
        Document document = this.getDocument();
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(nodeList.item(n));
        }
        for (n = 0; n < n2; ++n) {
            Node node2 = (Node)arrayList.get(n);
            if (node2 instanceof Text) continue;
            node.insertBefore(document.createTextNode(string + IDENT), node2);
            this.beautify(node2, string + IDENT);
            if (n + 1 != n2) continue;
            node.appendChild(document.createTextNode(string));
        }
    }

    private static class SunDTDResolver
    implements EntityResolver {
        private SunDTDResolver() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            String string3 = null;
            if (SunDDHelper.SUN_WEB_SYSTEM_ID_2_4.equals(string2)) {
                string3 = SunDDHelper.SUN_WEB_DTD_2_4;
            } else if (SunDDHelper.SUN_WEB_SYSTEM_ID_2_5.equals(string2)) {
                string3 = SunDDHelper.SUN_WEB_DTD_2_5;
            } else if (SunDDHelper.SUN_EJB_SYSTEM_ID_3_0.equals(string2)) {
                string3 = SunDDHelper.SUN_EJB_DTD_3_0;
            } else if (SunDDHelper.SUN_APPCLIENT_SYSTEM_ID_5_0.equals(string2)) {
                string3 = SunDDHelper.SUN_APPCLIENT_DTD_5_0;
            }
            if (string3 != null) {
                InputStream inputStream = this.getClass().getResourceAsStream(string3);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                return new InputSource(inputStreamReader);
            }
            return null;
        }
    }
}

