/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.CompoundXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemMarker;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;

public final class ThreadsGraphPanel
extends GraphPanel {
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final VMTelemetryModels models;
    private final boolean smallPanel;

    public static ThreadsGraphPanel createBigPanel(VMTelemetryModels models) {
        return new ThreadsGraphPanel(models, false, null);
    }

    public static ThreadsGraphPanel createSmallPanel(VMTelemetryModels models, Action chartAction) {
        return new ThreadsGraphPanel(models, true, chartAction);
    }

    private ThreadsGraphPanel(VMTelemetryModels models, boolean smallPanel, Action chartAction) {
        this.models = models;
        this.smallPanel = smallPanel;
        this.initComponents(chartAction);
        models.getDataManager().addDataListener(new DataManagerListener(){

            public void dataChanged() {
                ThreadsGraphPanel.this.updateData();
            }

            public void dataReset() {
                ThreadsGraphPanel.this.resetData();
            }
        });
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    private void updateData() {
        VMTelemetryDataManager manager;
        long[] timestamps;
        if (this.smallPanel && this.chart.fitsWidth() && (timestamps = manager.timeStamps)[(manager = this.models.getDataManager()).getItemCount() - 1] - timestamps[0] >= 180000L) {
            this.chart.setFitsWidth(false);
        }
    }

    private void resetData() {
        if (this.smallPanel) {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(true);
        } else {
            this.chart.setScale(0.02, 1.0);
            this.chart.setOffset(0L, 0L);
            this.chart.setFitsWidth(false);
        }
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 3L));
    }

    private void initComponents(final Action chartAction) {
        PaintersModel paintersModel = this.createThreadsPaintersModel();
        this.chart = this.createChart(this.models.threadsItemsModel(), paintersModel, this.smallPanel);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent hAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.threadsItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 5, 2);
        SynchronousXYItem threadsItem = this.models.threadsItemsModel().getItem(0);
        XYItemPainter threadsPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)threadsItem);
        SimpleLongMarksPainter threadsMarksPainter = new SimpleLongMarksPainter();
        threadsMarksPainter.setForeground(GraphsUI.THREADS_PAINTER_LINE_COLOR);
        AxisComponent tAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)threadsItem, threadsPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)threadsMarksPainter, 7, 2);
        SynchronousXYItem classesItem = this.models.threadsItemsModel().getItem(1);
        XYItemPainter classesPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)classesItem);
        SimpleLongMarksPainter classesMarksPainter = new SimpleLongMarksPainter();
        classesMarksPainter.setForeground(GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR);
        AxisComponent cAxis = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)classesItem, classesPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)classesMarksPainter, 3, 0);
        JPanel chartPanel = new JPanel((LayoutManager)new CrossBorderLayout());
        chartPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        chartPanel.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, GraphsUI.CHART_BACKGROUND_COLOR));
        chartPanel.add((Component)((Object)this.chart), new Integer[]{0});
        chartPanel.add((Component)hAxis, new Integer[]{5, 4, 6});
        chartPanel.add((Component)tAxis, new Integer[]{7, 6});
        chartPanel.add((Component)cAxis, new Integer[]{3, 4});
        if (this.smallPanel) {
            this.chart.setMouseZoomingEnabled(false);
            this.chart.getSelectionModel().setHoverMode(100);
            JLabel heapSizeSmall = new JLabel(GraphsUI.THREADS_NAME, new ColorIcon(GraphsUI.THREADS_PAINTER_LINE_COLOR, null, 8, 8), 10);
            heapSizeSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            heapSizeSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JLabel usedHeapSmall = new JLabel(GraphsUI.LOADED_CLASSES_NAME, new ColorIcon(GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR, null, 8, 8), 10);
            usedHeapSmall.setFont(this.getFont().deriveFont((float)this.getFont().getSize() - 1.0f));
            usedHeapSmall.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            JPanel smallLegendPanel = new JPanel(new FlowLayout(1, 0, 1));
            smallLegendPanel.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            smallLegendPanel.setBorder(new LineBorder(GraphsUI.SMALL_LEGEND_BORDER_COLOR, 1));
            smallLegendPanel.add(heapSizeSmall);
            smallLegendPanel.add(usedHeapSmall);
            JPanel smallLegendContainer = new JPanel(new FlowLayout(1));
            smallLegendContainer.setBackground(GraphsUI.SMALL_LEGEND_BACKGROUND_COLOR);
            smallLegendContainer.add(smallLegendPanel);
            this.setLayout(new BorderLayout());
            this.add((Component)chartPanel, "Center");
            this.add((Component)smallLegendContainer, "South");
            this.chart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        chartAction.actionPerformed(null);
                    }
                }
            });
            this.chartActions = new Action[0];
        } else {
            ProfilerXYTooltipPainter tooltipPainter = new ProfilerXYTooltipPainter(2.1f, GraphsUI.TOOLTIP_OVERLAY_LINE_COLOR, GraphsUI.TOOLTIP_OVERLAY_FILL_COLOR, this.getTooltipModel());
            this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, tooltipPainter));
            JScrollBar hScrollBar = new JScrollBar(0);
            this.chart.attachHorizontalScrollBar(hScrollBar);
            JPanel chartContainer = new JPanel(new BorderLayout());
            chartContainer.setBorder(new BevelBorder(1));
            chartContainer.add((Component)chartPanel, "Center");
            chartContainer.add((Component)hScrollBar, "South");
            JLabel heapSizeBig = new JLabel(GraphsUI.THREADS_NAME, new ColorIcon(GraphsUI.THREADS_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            heapSizeBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JLabel usedHeapBig = new JLabel(GraphsUI.LOADED_CLASSES_NAME, new ColorIcon(GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
            usedHeapBig.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel bigLegendPanel = new JPanel(new FlowLayout(4, 10, 10));
            bigLegendPanel.add(heapSizeBig);
            bigLegendPanel.add(usedHeapBig);
            this.setLayout(new BorderLayout());
            this.add((Component)chartContainer, "Center");
            this.add((Component)bigLegendPanel, "South");
            this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
        }
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long timestamp) {
                return GraphPanel.DATE_FORMATTER.format(new Date(timestamp));
            }

            @Override
            public int getRowsCount() {
                return 2;
            }

            @Override
            public String getRowName(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.THREADS_NAME;
                    }
                    case 1: {
                        return GraphsUI.LOADED_CLASSES_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int index) {
                switch (index) {
                    case 0: {
                        return GraphsUI.THREADS_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int index, long itemValue) {
                return GraphPanel.INT_FORMATTER.format(itemValue);
            }

            @Override
            public String getRowUnits(int index, long itemValue) {
                return "";
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int index) {
                return ThreadsGraphPanel.this.getMaxValueString(this.getRowName(index));
            }

            @Override
            public Color getExtraRowColor(int index) {
                return this.getRowColor(index);
            }

            @Override
            public String getExtraRowValue(int index) {
                SynchronousXYItem item = ThreadsGraphPanel.this.models.threadsItemsModel().getItem(index);
                return GraphPanel.INT_FORMATTER.format(item.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int index) {
                return this.getRowUnits(index, -1L);
            }
        };
    }

    private PaintersModel createThreadsPaintersModel() {
        SynchronousXYItemPainter threadsPainter = SynchronousXYItemPainter.absolutePainter((float)3.0f, (Color)GraphsUI.THREADS_PAINTER_LINE_COLOR, (Color)GraphsUI.THREADS_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker threadsMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.THREADS_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.THREADS_MARKER_LINE2_COLOR, (Color)GraphsUI.THREADS_MARKER_FILL_COLOR);
        CompoundXYItemPainter thp = new CompoundXYItemPainter((XYItemPainter)threadsPainter, (XYItemPainter)threadsMarker);
        SynchronousXYItemPainter loadedClassesPainter = SynchronousXYItemPainter.relativePainter((float)3.0f, (Color)GraphsUI.LOADED_CLASSES_PAINTER_LINE_COLOR, (Color)GraphsUI.LOADED_CLASSES_PAINTER_FILL_COLOR, (int)10);
        SynchronousXYItemMarker loadedClassesMarker = SynchronousXYItemMarker.relativePainter((int)5, (float)0.75f, (Color)GraphsUI.LOADED_CLASSES_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.LOADED_CLASSES_MARKER_LINE2_COLOR, (Color)GraphsUI.LOADED_CLASSES_MARKER_FILL_COLOR, (int)10);
        CompoundXYItemPainter lcp = new CompoundXYItemPainter((XYItemPainter)loadedClassesPainter, (XYItemPainter)loadedClassesMarker);
        SynchronousXYItemsModel items = this.models.threadsItemsModel();
        PaintersModel.Default model = new PaintersModel.Default(new ChartItem[]{items.getItem(0), items.getItem(1)}, (ItemPainter[])new XYItemPainter[]{thp, lcp});
        return model;
    }
}

