/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.game.model.CodeUtils;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.netbeans.modules.vmd.game.view.GameDesignNavigator;
import org.netbeans.modules.vmd.game.view.GameDesignOverViewPanel;
import org.netbeans.modules.vmd.game.view.main.MainView;
import org.openide.util.NbBundle;

public class GlobalRepository
implements PropertyChangeListener,
Editable {
    private JComponent editor;
    private DesignDocument designDocument;
    private MainView mainView;
    public static final boolean DEBUG = false;
    EventListenerList listenerList = new EventListenerList();
    private GameDesignNavigator navigator;
    private HashMap<String, Layer> layers = new HashMap();
    private ArrayList<TiledLayer> tiledLayers = new ArrayList();
    private ArrayList<Sprite> sprites = new ArrayList();
    private ArrayList<Scene> scenes = new ArrayList();
    private Map<String, ImageResource> imgResourceMap = new HashMap<String, ImageResource>();

    public GlobalRepository(DesignDocument designDocument) {
        this.designDocument = designDocument;
    }

    public DesignDocument getDesignDocument() {
        return this.designDocument;
    }

    public void addGlobalRepositoryListener(GlobalRepositoryListener globalRepositoryListener) {
        this.listenerList.add(GlobalRepositoryListener.class, globalRepositoryListener);
    }

    public void removeGlobalRepositoryListener(GlobalRepositoryListener globalRepositoryListener) {
        this.listenerList.remove(GlobalRepositoryListener.class, globalRepositoryListener);
    }

    public MainView getMainView() {
        if (this.mainView == null) {
            this.mainView = new MainView(this);
            this.addGlobalRepositoryListener(this.mainView);
        }
        return this.mainView;
    }

    public boolean removeIdentifiable(long l) {
        ArrayList<Scene> arrayList = new ArrayList<Scene>();
        arrayList.addAll(this.scenes);
        for (Scene object2 : arrayList) {
            if (object2.getId() != l) continue;
            this.removeScene(object2);
            return true;
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.layers.values());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (layer.getId() != l) continue;
            this.removeLayer(layer);
            return true;
        }
        return false;
    }

    public void removeAllComponents() {
        this.removeAllScenes();
        this.removeAllLayers();
        this.imgResourceMap.clear();
    }

    private void removeAllScenes() {
        ArrayList<Scene> arrayList = new ArrayList<Scene>();
        arrayList.addAll(this.scenes);
        for (Scene scene : arrayList) {
            this.removeScene(scene);
        }
    }

    private void removeAllLayers() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        arrayList.addAll(this.layers.values());
        for (Layer layer : arrayList) {
            this.removeLayer(layer);
        }
    }

    public ImageResource getImageResource(String string) {
        return this.imgResourceMap.get(string);
    }

    public ImageResource getImageResource(URL uRL, String string) {
        ImageResource imageResource = this.imgResourceMap.get(string);
        if (imageResource == null) {
            imageResource = new ImageResource(this, uRL, string);
            this.imgResourceMap.put(string, imageResource);
            this.fireImageResourceAdded(imageResource);
        }
        return imageResource;
    }

    public Collection<ImageResource> getImageResources() {
        return Collections.unmodifiableCollection(this.imgResourceMap.values());
    }

    public ImageResource getImageResource(long l) {
        for (ImageResource imageResource : this.getImageResources()) {
            if (imageResource.getId() != l) continue;
            return imageResource;
        }
        return null;
    }

    private void fireImageResourceAdded(ImageResource imageResource) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GlobalRepositoryListener.class) continue;
            ((GlobalRepositoryListener)objectArray[i + 1]).imageResourceAdded(imageResource);
        }
    }

    private void addTiledLayer(TiledLayer tiledLayer) {
        this.tiledLayers.add(tiledLayer);
        this.layers.put(tiledLayer.getName(), tiledLayer);
        tiledLayer.addPropertyChangeListener(this);
        Collections.sort(this.tiledLayers, new Layer.NameComparator());
        int n = this.tiledLayers.indexOf(tiledLayer);
        this.fireTiledLayerAdded(tiledLayer, n);
    }

    private void fireTiledLayerAdded(TiledLayer tiledLayer, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GlobalRepositoryListener.class) continue;
            ((GlobalRepositoryListener)objectArray[i + 1]).tiledLayerAdded(tiledLayer, n);
        }
    }

    private void addSprite(Sprite sprite) {
        this.sprites.add(sprite);
        this.layers.put(sprite.getName(), sprite);
        sprite.addPropertyChangeListener(this);
        Collections.sort(this.sprites, new Layer.NameComparator());
        int n = this.sprites.indexOf(sprite);
        this.fireSpriteAdded(sprite, n);
    }

    private void fireSpriteAdded(Sprite sprite, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GlobalRepositoryListener.class) continue;
            ((GlobalRepositoryListener)objectArray[i + 1]).spriteAdded(sprite, n);
        }
    }

    private void removeTiledLayer(TiledLayer tiledLayer) {
        this.removeLayerfromLayers(tiledLayer);
        int n = this.tiledLayers.indexOf(tiledLayer);
        this.tiledLayers.remove(tiledLayer);
        this.fireTiledLayerRemoved(tiledLayer, n);
    }

    private void fireTiledLayerRemoved(TiledLayer tiledLayer, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GlobalRepositoryListener.class) continue;
            ((GlobalRepositoryListener)objectArray[i + 1]).tiledLayerRemoved(tiledLayer, n);
        }
    }

    private void removeSprite(Sprite sprite) {
        this.removeLayerfromLayers(sprite);
        int n = this.sprites.indexOf(sprite);
        this.sprites.remove(sprite);
        this.fireSpriteRemoved(sprite, n);
    }

    private void fireSpriteRemoved(Sprite sprite, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GlobalRepositoryListener.class) continue;
            ((GlobalRepositoryListener)objectArray[i + 1]).spriteRemoved(sprite, n);
        }
    }

    void removeLayer(Layer layer) {
        Object object;
        List<Scene> list = this.getScenes();
        for (Scene scene : list) {
            scene.remove(layer);
        }
        if (layer instanceof TiledLayer) {
            object = (TiledLayer)layer;
            this.removeTiledLayer((TiledLayer)object);
        } else if (layer instanceof Sprite) {
            object = (Sprite)layer;
            this.removeSprite((Sprite)object);
        }
    }

    private void removeLayerfromLayers(Layer layer) {
        this.layers.remove(layer.getName());
        layer.removePropertyChangeListener(this);
    }

    public Layer getLayerByName(String string) {
        return this.layers.get(string);
    }

    public Layer getLayer(long l) {
        for (Layer layer : this.layers.values()) {
            if (layer.getId() != l) continue;
            return layer;
        }
        return null;
    }

    private void addScene(Scene scene) {
        this.scenes.add(scene);
        Collections.sort(this.scenes, new Scene.NameComparator());
        int n = this.scenes.indexOf(scene);
        this.fireSceneAdded(scene, n);
    }

    private void fireSceneAdded(Scene scene, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GlobalRepositoryListener.class) continue;
            ((GlobalRepositoryListener)objectArray[i + 1]).sceneAdded(scene, n);
        }
    }

    void removeScene(Scene scene) {
        int n = this.scenes.indexOf(scene);
        this.scenes.remove(scene);
        this.fireSceneRemoved(scene, n);
    }

    private void fireSceneRemoved(Scene scene, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GlobalRepositoryListener.class) continue;
            ((GlobalRepositoryListener)objectArray[i + 1]).sceneRemoved(scene, n);
        }
    }

    public boolean isComponentNameAvailable(String string) {
        List<String> list = GlobalRepository.deriveUsedNames(string);
        for (String string2 : list) {
            if (this.isNameAvailable(string2)) continue;
            return false;
        }
        return true;
    }

    public static List<String> deriveUsedNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(CodeUtils.decapitalize(string));
        arrayList.add(CodeUtils.capitalize(string));
        arrayList.add(CodeUtils.createGetterMethodName(string));
        arrayList.add(CodeUtils.createSetterMethodName(string));
        return arrayList;
    }

    private boolean isNameAvailable(String string) {
        if (this.getLayerByName(string) != null) {
            return false;
        }
        if (this.getSceneByName(string) != null) {
            return false;
        }
        for (ImageResource imageResource : this.getImageResources()) {
            if (imageResource.getName(false).equals(string)) {
                return false;
            }
            if (imageResource.getSequenceByName(string) != null) {
                return false;
            }
            if (imageResource.getAnimatedTileByName(string) == null) continue;
            return false;
        }
        return true;
    }

    public String getNextAvailableComponentName(String string) {
        String string2 = string;
        int n = 1;
        while (!this.isComponentNameAvailable(string2)) {
            string2 = string;
            if (n < 100) {
                string2 = string2 + "0";
            }
            if (n < 10) {
                string2 = string2 + "0";
            }
            string2 = string2 + n++;
        }
        return string2;
    }

    public Scene getScene(long l) {
        for (Scene scene : this.scenes) {
            if (scene.getId() != l) continue;
            return scene;
        }
        return null;
    }

    public Scene getSceneByName(String string) {
        for (Scene scene : this.scenes) {
            if (!scene.getName().equals(string)) continue;
            return scene;
        }
        return null;
    }

    public List<Scene> getScenes() {
        return Collections.unmodifiableList(this.scenes);
    }

    public List<TiledLayer> getTiledLayers() {
        return Collections.unmodifiableList(this.tiledLayers);
    }

    public List<Sprite> getSprites() {
        return Collections.unmodifiableList(this.sprites);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Layer) {
            Layer layer = (Layer)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getPropertyName().equals("editable.prop.name")) {
                this.layers.remove(propertyChangeEvent.getOldValue());
                this.layers.put((String)propertyChangeEvent.getNewValue(), layer);
            }
        }
    }

    public Scene createScene(String string) {
        if (!this.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Scene cannot be created because component name '" + string + "' already exists.");
        }
        Scene scene = new Scene(this, string);
        this.addScene(scene);
        return scene;
    }

    public Scene createScene(String string, Scene scene) {
        if (!this.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Scene cannot be created because component name '" + string + "' already exists.");
        }
        Scene scene2 = new Scene(this, string, scene);
        this.addScene(scene2);
        return scene2;
    }

    public TiledLayer createTiledLayer(String string, ImageResource imageResource, int n, int n2, int n3, int n4) {
        if (!this.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Scene cannot be created because component name '" + string + "' already exists.");
        }
        TiledLayer tiledLayer = new TiledLayer(this, string, imageResource, n, n2, n3, n4);
        this.addTiledLayer(tiledLayer);
        return tiledLayer;
    }

    public TiledLayer createTiledLayer(String string, ImageResource imageResource, int[][] nArray, int n, int n2) {
        if (!this.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("TiledLayer cannot be created because component name '" + string + "' already exists.");
        }
        TiledLayer tiledLayer = new TiledLayer(this, string, imageResource, nArray, n, n2);
        this.addTiledLayer(tiledLayer);
        return tiledLayer;
    }

    public TiledLayer duplicateTiledLayer(String string, TiledLayer tiledLayer) {
        if (!this.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("TiledLayer cannot be created because component name '" + string + "' already exists.");
        }
        TiledLayer tiledLayer2 = new TiledLayer(this, string, tiledLayer);
        this.addTiledLayer(tiledLayer2);
        return tiledLayer2;
    }

    public Sprite createSprite(String string, ImageResource imageResource, int n, int n2, int n3) {
        assert (n >= 1);
        if (!this.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Sprite cannot be created because component name '" + string + "' already exists.");
        }
        Sprite sprite = new Sprite(this, string, imageResource, n, n2, n3);
        this.addSprite(sprite);
        return sprite;
    }

    public Sprite createSprite(String string, ImageResource imageResource, Sequence sequence) {
        assert (sequence != null);
        if (!this.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Sprite cannot be created because component name '" + string + "' already exists.");
        }
        Sprite sprite = new Sprite(this, string, imageResource, sequence);
        this.addSprite(sprite);
        return sprite;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public JComponent getEditor() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(new GameDesignOverViewPanel(this));
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jPanel.add((Component)jScrollPane, "Center");
        this.editor = jPanel;
        return this.editor;
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return null;
    }

    @Override
    public JComponent getNavigator() {
        return this.navigator == null ? (this.navigator = new GameDesignNavigator(this)) : this.navigator;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(GlobalRepository.class, (String)"GlobalRepository.name");
    }

    @Override
    public List<Action> getActions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

