/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.errors;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.errors.SearchClassDependencyHint;
import org.netbeans.modules.maven.hints.ui.SearchDependencyUI;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SearchClassDependencyInRepo
implements ErrorRule<Void> {
    private AtomicBoolean cancel = new AtomicBoolean(false);

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist", "compiler.err.not.stmt"));
    }

    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.cancel.set(false);
        if (!SearchClassDependencyHint.isHintEnabled()) {
            return Collections.emptyList();
        }
        int n2 = n + 1;
        if (n2 == -1) {
            return Collections.emptyList();
        }
        FileObject fileObject = compilationInfo.getFileObject();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return Collections.emptyList();
        }
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject == null) {
            return Collections.emptyList();
        }
        TreePath treePath2 = compilationInfo.getTreeUtilities().pathFor(n2);
        if (treePath2.getParentPath() == null) {
            return Collections.emptyList();
        }
        Tree tree = treePath2.getParentPath().getLeaf();
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                if (!methodInvocationTree.getTypeArguments().contains(treePath2.getLeaf())) {
                    return Collections.emptyList();
                }
            }
            case MEMBER_SELECT: {
                return Collections.emptyList();
            }
            case PARAMETERIZED_TYPE: {
                tree = treePath2.getParentPath().getParentPath().getLeaf();
                break;
            }
            case ARRAY_TYPE: {
                tree = treePath2.getParentPath().getParentPath().getLeaf();
            }
        }
        switch (tree.getKind()) {
            case VARIABLE: {
                Tree tree2;
                object6 = null;
                object5 = (VariableTree)tree;
                if (object5.getType() != null) {
                    switch (object5.getType().getKind()) {
                        case IDENTIFIER: {
                            object6 = ((IdentifierTree)object5.getType()).getName();
                            break;
                        }
                        case PARAMETERIZED_TYPE: {
                            tree2 = (ParameterizedTypeTree)object5.getType();
                            if (tree2.getType() == null || tree2.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                            object6 = ((IdentifierTree)tree2.getType()).getName();
                            break;
                        }
                        case ARRAY_TYPE: {
                            tree2 = (ArrayTypeTree)object5.getType();
                            if (tree2.getType() == null || tree2.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                            object6 = ((IdentifierTree)tree2.getType()).getName();
                        }
                    }
                }
                tree2 = object5.getInitializer();
                if (object6 == null || tree2 == null) break;
                object4 = null;
                switch (tree2.getKind()) {
                    case NEW_CLASS: {
                        object3 = null;
                        object2 = (NewClassTree)tree2;
                        object3 = object2.getIdentifier();
                        if (object3 != null) {
                            switch (object3.getKind()) {
                                case IDENTIFIER: {
                                    object4 = ((IdentifierTree)object3).getName();
                                    break;
                                }
                                case PARAMETERIZED_TYPE: {
                                    object = (ParameterizedTypeTree)object3;
                                    if (object.getType() == null || object.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                                    object4 = ((IdentifierTree)object.getType()).getName();
                                }
                            }
                        }
                        break;
                    }
                    case NEW_ARRAY: {
                        object3 = (NewArrayTree)tree2;
                        object2 = object3.getType();
                        if (object2 == null || !object2.getKind().equals((Object)Tree.Kind.IDENTIFIER)) break;
                        object4 = ((IdentifierTree)object2).getName();
                    }
                }
                if (!object6.equals(object4)) break;
                return Collections.emptyList();
            }
        }
        object6 = null;
        try {
            object6 = SearchClassDependencyInRepo.findUnresolvedElementToken(compilationInfo, n);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (object6 == null) {
            return Collections.emptyList();
        }
        object5 = ((Object)object6.text()).toString();
        if (this.cancel.get()) {
            return Collections.emptyList();
        }
        boolean bl = false;
        object4 = nbMavenProject.getMavenProject();
        object3 = object4.getBuild().getTestSourceDirectory();
        object2 = new File((String)object3);
        object = FileUtil.toFileObject((File)object2);
        if (object != null) {
            bl = FileUtil.isParentOf((FileObject)object, (FileObject)fileObject);
        }
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        if (SearchClassDependencyHint.isSearchDialog()) {
            arrayList.add((Fix)new MavenSearchFix(project, (String)object5, bl));
        } else {
            Collection<NBVersionInfo> collection = this.filter(nbMavenProject, RepositoryQueries.findVersionsByClass((String)object5, (RepositoryInfo[])new RepositoryInfo[0]), bl);
            for (NBVersionInfo nBVersionInfo : collection) {
                arrayList.add((Fix)new MavenFixImport(project, nBVersionInfo, bl));
            }
        }
        return arrayList;
    }

    private Collection<NBVersionInfo> filter(NbMavenProject nbMavenProject, List<NBVersionInfo> list, boolean bl) {
        HashMap<String, NBVersionInfo> hashMap = new HashMap<String, NBVersionInfo>();
        ArrayList arrayList = new ArrayList();
        MavenProject mavenProject = nbMavenProject.getMavenProject();
        if (bl) {
            arrayList.addAll(mavenProject.getTestDependencies());
        } else {
            arrayList.addAll(mavenProject.getDependencies());
        }
        for (NBVersionInfo nBVersionInfo : list) {
            String string = nBVersionInfo.getGroupId() + ":" + nBVersionInfo.getArtifactId();
            boolean bl2 = hashMap.containsKey(string);
            if (!bl2) {
                hashMap.put(string, nBVersionInfo);
            }
            for (Dependency dependency : arrayList) {
                if (dependency.getGroupId() == null || !dependency.getGroupId().equals(nBVersionInfo.getGroupId()) || dependency.getArtifactId() == null || !dependency.getArtifactId().equals(nBVersionInfo.getArtifactId()) || bl || dependency.getScope() == null || !"compile".equals(dependency.getScope())) continue;
                return Collections.emptyList();
            }
        }
        ArrayList arrayList2 = new ArrayList(hashMap.values());
        return arrayList2;
    }

    public static Token findUnresolvedElementToken(CompilationInfo compilationInfo, int n) throws IOException {
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language());
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() == JavaTokenId.DOT) {
                tokenSequence.moveNext();
                token = tokenSequence.token();
            } else if (token.id() == JavaTokenId.LT) {
                tokenSequence.moveNext();
                token = tokenSequence.token();
            } else if (token.id() == JavaTokenId.NEW) {
                boolean bl = tokenSequence.moveNext();
                while (bl && tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                    bl = tokenSequence.moveNext();
                }
                if (!bl) {
                    return null;
                }
                token = tokenSequence.token();
            }
            if (token.id() == JavaTokenId.IDENTIFIER) {
                return tokenSequence.offsetToken();
            }
        }
        return null;
    }

    public String getId() {
        return "MAVEN_MISSING_CLASS";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SearchClassDependencyInRepo.class, (String)"LBL_Class_Search_DisplayName");
    }

    public void cancel() {
        this.cancel.set(true);
    }

    static final class MavenSearchFix
    implements EnhancedFix {
        private Project mavProj;
        private String clazz;
        private boolean test;

        public MavenSearchFix(Project project, String string, boolean bl) {
            this.mavProj = project;
            this.clazz = string;
            this.test = bl;
        }

        public CharSequence getSortText() {
            return this.getText();
        }

        public String getText() {
            return NbBundle.getMessage(SearchClassDependencyInRepo.class, (String)"LBL_Class_Search_ALL_Fix", (Object)this.clazz);
        }

        public ChangeInfo implement() throws Exception {
            NBVersionInfo nBVersionInfo = null;
            SearchDependencyUI searchDependencyUI = new SearchDependencyUI(this.clazz, this.mavProj);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)searchDependencyUI, NbBundle.getMessage(SearchClassDependencyInRepo.class, (String)"LBL_Search_Repo"));
            dialogDescriptor.setClosingOptions(new Object[]{searchDependencyUI.getAddButton(), DialogDescriptor.CANCEL_OPTION});
            dialogDescriptor.setOptions(new Object[]{searchDependencyUI.getAddButton(), DialogDescriptor.CANCEL_OPTION});
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (searchDependencyUI.getAddButton() == object) {
                nBVersionInfo = searchDependencyUI.getSelectedVersion();
            }
            if (nBVersionInfo != null) {
                ModelUtils.addDependency((FileObject)this.mavProj.getProjectDirectory().getFileObject("pom.xml"), (String)nBVersionInfo.getGroupId(), (String)nBVersionInfo.getArtifactId(), (String)nBVersionInfo.getVersion(), (String)nBVersionInfo.getType(), (String)(this.test ? "test" : null), null, (boolean)true);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ((NbMavenProject)MavenSearchFix.this.mavProj.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
                    }
                });
            }
            return null;
        }
    }

    static final class MavenFixImport
    implements EnhancedFix {
        private Project mavProj;
        private NBVersionInfo nbvi;
        private boolean test;

        public MavenFixImport(Project project, NBVersionInfo nBVersionInfo, boolean bl) {
            this.mavProj = project;
            this.nbvi = nBVersionInfo;
            this.test = bl;
        }

        public CharSequence getSortText() {
            return this.getText();
        }

        public String getText() {
            return NbBundle.getMessage(SearchClassDependencyInRepo.class, (String)"LBL_Class_Search_Fix", (Object)(this.nbvi.getGroupId() + " : " + this.nbvi.getArtifactId() + " : " + this.nbvi.getVersion()));
        }

        public ChangeInfo implement() throws Exception {
            ModelUtils.addDependency((FileObject)this.mavProj.getProjectDirectory().getFileObject("pom.xml"), (String)this.nbvi.getGroupId(), (String)this.nbvi.getArtifactId(), (String)this.nbvi.getVersion(), (String)this.nbvi.getType(), (String)(this.test ? "test" : null), null, (boolean)true);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ((NbMavenProject)MavenFixImport.this.mavProj.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
                }
            });
            return null;
        }
    }
}

