/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;

public class MemberAccessFilter
implements MemberVisitor {
    private static final int ACCESS_MASK = 7;
    private final int requiredSetAccessFlags;
    private final int requiredUnsetAccessFlags;
    private final int requiredOneSetAccessFlags;
    private final MemberVisitor memberVisitor;

    public MemberAccessFilter(int n, int n2, MemberVisitor memberVisitor) {
        this.requiredSetAccessFlags = n & 0xFFFFFFF8;
        this.requiredUnsetAccessFlags = n2;
        this.requiredOneSetAccessFlags = n & 7;
        this.memberVisitor = memberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.accepted(programField.getAccessFlags())) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.accepted(programMethod.getAccessFlags())) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.accepted(libraryField.getAccessFlags())) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.accepted(libraryMethod.getAccessFlags())) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean accepted(int n) {
        return (this.requiredSetAccessFlags & ~n) == 0 && (this.requiredUnsetAccessFlags & n) == 0 && (this.requiredOneSetAccessFlags == 0 || (this.requiredOneSetAccessFlags & n) != 0);
    }
}

