/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.BasicWizardPanel;
import org.netbeans.modules.maven.newproject.NbmWizardPanel;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SimpleWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor wiz;
    private final Archetype archetype;
    private boolean isNBM = false;
    private final List<ChangeListener> listeners;

    private SimpleWizardIterator(Archetype archetype) {
        this.archetype = archetype;
        this.isNBM = archetype.equals(ArchetypeWizardUtils.NB_APP_ARCH) || archetype.equals(ArchetypeWizardUtils.NB_MODULE_ARCH) || archetype.equals(ArchetypeWizardUtils.NB_SUITE_ARCH);
        this.listeners = new ArrayList<ChangeListener>();
    }

    public static SimpleWizardIterator createNbModuleIterator() {
        return new SimpleWizardIterator(ArchetypeWizardUtils.NB_MODULE_ARCH);
    }

    public static SimpleWizardIterator createNbAppIterator() {
        return new SimpleWizardIterator(ArchetypeWizardUtils.NB_APP_ARCH);
    }

    public static SimpleWizardIterator createNbSuiteIterator() {
        return new SimpleWizardIterator(ArchetypeWizardUtils.NB_SUITE_ARCH);
    }

    public static SimpleWizardIterator createOSGiIterator() {
        return new SimpleWizardIterator(ArchetypeWizardUtils.OSGI_ARCH);
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] createPanels(ValidationGroup vg) {
        if (this.isNBM) {
            return new WizardDescriptor.Panel[]{new BasicWizardPanel(vg, true), new NbmWizardPanel(vg, this.archetype)};
        }
        return new WizardDescriptor.Panel[]{new BasicWizardPanel(vg, true)};
    }

    private String[] createSteps() {
        if (this.isNBM) {
            return new String[]{NbBundle.getMessage(SimpleWizardIterator.class, (String)"LBL_CreateProjectStep2"), NbBundle.getMessage(SimpleWizardIterator.class, (String)"LBL_CreateProjectStepNbm")};
        }
        return new String[]{NbBundle.getMessage(SimpleWizardIterator.class, (String)"LBL_CreateProjectStep2")};
    }

    public Set<FileObject> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        return ArchetypeWizardUtils.instantiate(handle, this.wiz);
    }

    public void initialize(WizardDescriptor wiz) {
        this.index = 0;
        ValidationGroup vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz)});
        this.panels = this.createPanels(vg);
        this.wiz = wiz;
        this.wiz.putProperty("archetype", (Object)this.archetype);
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(SimpleWizardIterator.class, (String)"NameFormat"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            for (ChangeListener list2 : this.listeners) {
                list2.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

