/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.SelectReactorDirectoryPanel;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReactorChecker
implements PrerequisitesChecker {
    private static final ArtifactVersion BORDER_VERSION = new DefaultArtifactVersion("2.1.0");

    private boolean isAtLeast211Maven() {
        String version = MavenSettings.getCommandLineMavenVersion();
        if (version != null) {
            DefaultArtifactVersion dav = new DefaultArtifactVersion(version);
            return BORDER_VERSION.compareTo((Object)dav) <= 0;
        }
        return false;
    }

    @Override
    public boolean checkRunConfig(RunConfig config) {
        Properties props;
        ArrayList<String> goals;
        BeanRunConfig beanRunConfig;
        boolean showDialog = false;
        if (config.getProject() == null) {
            return true;
        }
        boolean is211 = this.isAtLeast211Maven();
        boolean isReactor = config.getReactorStyle() != RunConfig.ReactorStyle.NONE;
        boolean isOldSchoolReactor = false;
        for (String goal : config.getGoals()) {
            if (!goal.contains("reactor:")) continue;
            isReactor = true;
            isOldSchoolReactor = true;
        }
        if (isReactor) {
            File dir = config.getExecutionDirectory();
            FileObject fo = FileUtil.toFileObject((File)dir);
            if (fo == null) {
                showDialog = true;
            } else {
                try {
                    Project prj = ProjectManager.getDefault().findProject(fo);
                    if (prj == null) {
                        showDialog = true;
                    } else {
                        NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                        if (nbprj == null) {
                            showDialog = true;
                        } else if (!"pom".equals(nbprj.getPackagingType())) {
                            showDialog = true;
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (isOldSchoolReactor && is211 && config instanceof BeanRunConfig) {
            beanRunConfig = (BeanRunConfig)config;
            goals = new ArrayList<String>(beanRunConfig.getGoals());
            if (goals.remove("reactor:make")) {
                beanRunConfig.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE);
            }
            if (goals.remove("reactor:make-dependents")) {
                beanRunConfig.setReactorStyle(RunConfig.ReactorStyle.ALSO_MAKE_DEPENDENTS);
            }
            props = beanRunConfig.getProperties();
            List<String> profiles = beanRunConfig.getActivatedProfiles();
            String newGoals = props.getProperty("make.goals");
            if (newGoals != null) {
                String[] gls;
                for (String g : gls = StringUtils.split((String)newGoals, (String)",")) {
                    if (g.startsWith("-D")) continue;
                    if (g.startsWith("-P")) {
                        profiles.add(g.substring("-P".length()));
                        continue;
                    }
                    goals.add(g);
                }
            } else {
                goals.add("install");
            }
            beanRunConfig.setProperties(props);
            beanRunConfig.setGoals(goals);
            beanRunConfig.setActivatedProfiles(profiles);
        }
        if (isReactor && !isOldSchoolReactor && !is211 && config instanceof BeanRunConfig) {
            beanRunConfig = (BeanRunConfig)config;
            goals = new ArrayList<String>(beanRunConfig.getGoals());
            props = beanRunConfig.getProperties();
            props.setProperty("make.goals", StringUtils.join(goals.iterator(), (String)","));
            goals.clear();
            if (config.getReactorStyle() == RunConfig.ReactorStyle.ALSO_MAKE) {
                goals.add("reactor:make");
            }
            if (config.getReactorStyle() == RunConfig.ReactorStyle.ALSO_MAKE_DEPENDENTS) {
                goals.add("reactor:make-dependents");
            }
            props.setProperty("make.artifacts", config.getMavenProject().getGroupId() + ":" + config.getMavenProject().getArtifactId());
            beanRunConfig.setReactorStyle(RunConfig.ReactorStyle.NONE);
            beanRunConfig.setProperties(props);
            beanRunConfig.setGoals(goals);
        }
        if (showDialog) {
            SelectReactorDirectoryPanel pnl = new SelectReactorDirectoryPanel(config.getExecutionDirectory(), config.getProject());
            DialogDescriptor nd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(ReactorChecker.class, (String)"LBL_SELECT_REACTOR_ROOT"));
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (ret == NotifyDescriptor.OK_OPTION) {
                String path = pnl.getRelativePath();
                File selected = FileUtilities.resolveFilePath(FileUtil.toFile((FileObject)config.getProject().getProjectDirectory()), path);
                config.setExecutionDirectory(selected);
                M2ConfigProvider usr = (M2ConfigProvider)config.getProject().getLookup().lookup(M2ConfigProvider.class);
                NetbeansBuildActionXpp3Reader reader = new NetbeansBuildActionXpp3Reader();
                try {
                    ActionToGoalMapping mapping = reader.read(new StringReader(usr.getDefaultConfig().getRawMappingsAsString()));
                    NetbeansActionMapping m = this.findAction(mapping.getActions(), config.getActionName());
                    if (m == null) {
                        m = ActionToGoalUtils.getDefaultMapping(config.getActionName(), config.getProject());
                        if (m == null) {
                            return true;
                        }
                        mapping.addAction(m);
                    }
                    m.setBasedir(path);
                    CustomizerProviderImpl.writeNbActionsModel(config.getProject(), mapping, M2Configuration.getFileNameExt(M2Configuration.DEFAULT));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (XmlPullParserException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private NetbeansActionMapping findAction(List<NetbeansActionMapping> actions, String actionName) {
        for (NetbeansActionMapping m : actions) {
            if (!actionName.equals(m.getActionName())) continue;
            return m;
        }
        return null;
    }
}

