/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;

public abstract class AbstractProjectClassPathImpl
implements ClassPathImplementation {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> resources;
    private NbMavenProjectImpl project;

    protected AbstractProjectClassPathImpl(NbMavenProjectImpl proj) {
        this.project = proj;
        NbMavenProject.addPropertyChangeListener(proj, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    boolean hasChanged;
                    List oldvalue;
                    List newValues = AbstractProjectClassPathImpl.this.getPath();
                    AbstractProjectClassPathImpl abstractProjectClassPathImpl = AbstractProjectClassPathImpl.this;
                    synchronized (abstractProjectClassPathImpl) {
                        oldvalue = AbstractProjectClassPathImpl.this.resources;
                        hasChanged = AbstractProjectClassPathImpl.this.hasChanged(oldvalue, newValues);
                        if (hasChanged) {
                            AbstractProjectClassPathImpl.this.resources = newValues;
                        }
                    }
                    if (hasChanged) {
                        AbstractProjectClassPathImpl.this.support.firePropertyChange("resources", oldvalue, newValues);
                    }
                }
            }
        });
    }

    private boolean hasChanged(List<PathResourceImplementation> oldValues, List<PathResourceImplementation> newValues) {
        if (oldValues == null) {
            return newValues != null;
        }
        Iterator<PathResourceImplementation> it = oldValues.iterator();
        ArrayList<PathResourceImplementation> nl = new ArrayList<PathResourceImplementation>();
        nl.addAll(newValues);
        while (it.hasNext()) {
            PathResourceImplementation res = it.next();
            URL oldUrl = res.getRoots()[0];
            boolean found = false;
            if (nl.size() == 0) {
                return true;
            }
            Iterator inner = nl.iterator();
            while (inner.hasNext()) {
                PathResourceImplementation res2 = (PathResourceImplementation)inner.next();
                URL newUrl = res2.getRoots()[0];
                if (!newUrl.equals(oldUrl)) continue;
                inner.remove();
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return nl.size() != 0;
    }

    protected final NbMavenProjectImpl getMavenProject() {
        return this.project;
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    abstract URI[] createPath();

    protected FilteringPathResourceImplementation getFilteringResources() {
        return null;
    }

    private List<PathResourceImplementation> getPath() {
        List<PathResourceImplementation> base = AbstractProjectClassPathImpl.getPath(this.createPath());
        FilteringPathResourceImplementation filtering = this.getFilteringResources();
        if (filtering != null) {
            base.add((PathResourceImplementation)filtering);
        }
        return Collections.unmodifiableList(base);
    }

    public static List<PathResourceImplementation> getPath(URI[] pieces) {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        for (int i = 0; i < pieces.length; ++i) {
            try {
                URL entry = FileUtil.urlForArchiveOrDir((File)new File(pieces[i]));
                if (entry == null) continue;
                result.add(ClassPathSupport.createResource((URL)entry));
                continue;
            }
            catch (IllegalArgumentException exc) {
                Logger.getLogger(AbstractProjectClassPathImpl.class.getName()).log(Level.INFO, "Cannot use uri " + pieces[i] + " for classpath", exc);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

