/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.property;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;

public class ScreenStringPropertyEditor
implements ScreenPropertyEditor {
    private String propertyName;
    private int alignment;
    private String refComponentPropertyName;

    public ScreenStringPropertyEditor(String string) {
        this(string, null, 2);
    }

    public ScreenStringPropertyEditor(String string, int n) {
        this(string, null, n);
    }

    public ScreenStringPropertyEditor(String string, String string2, int n) {
        this.alignment = n;
        assert (string != null);
        this.propertyName = string;
        this.refComponentPropertyName = string2;
    }

    public JComponent createEditorComponent(ScreenPropertyDescriptor screenPropertyDescriptor) {
        DesignComponent designComponent = this.resolveRelatedComponent(screenPropertyDescriptor);
        if (designComponent == null) {
            return null;
        }
        StringTextField stringTextField = new StringTextField(screenPropertyDescriptor);
        stringTextField.setMinimumSize(new Dimension(128, 21));
        PropertyValue propertyValue = designComponent.readProperty(this.propertyName);
        String string = MidpTypes.getString(propertyValue);
        stringTextField.setText(string != null ? string : "");
        stringTextField.selectAll();
        return stringTextField;
    }

    private DesignComponent resolveRelatedComponent(ScreenPropertyDescriptor screenPropertyDescriptor) {
        DesignComponent designComponent = this.refComponentPropertyName == null ? screenPropertyDescriptor.getRelatedComponent() : screenPropertyDescriptor.getRelatedComponent().readProperty(this.refComponentPropertyName).getComponent();
        return designComponent;
    }

    public Insets getEditorComponentInsets(JComponent jComponent) {
        return jComponent.getBorder().getBorderInsets(jComponent);
    }

    private class StringTextField
    extends JTextField
    implements KeyListener {
        private ScreenPropertyDescriptor property;

        public StringTextField(ScreenPropertyDescriptor screenPropertyDescriptor) {
            this.property = screenPropertyDescriptor;
            this.addKeyListener(this);
            this.setHorizontalAlignment(ScreenStringPropertyEditor.this.alignment);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() != '\n') {
                return;
            }
            this.property.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue propertyValue = MidpTypes.createStringValue(StringTextField.this.getText());
                    ScreenStringPropertyEditor.this.resolveRelatedComponent(StringTextField.this.property).writeProperty(ScreenStringPropertyEditor.this.propertyName, propertyValue);
                    MidpDatabindingSupport.removeUnusedConnector(StringTextField.this.property.getRelatedComponent(), ScreenStringPropertyEditor.this.propertyName);
                }
            });
            PopupUtil.hidePopup();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

