/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.kenai.ui.SourceHandleImpl;
import org.netbeans.modules.kenai.ui.spi.NbProjectHandle;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class NbProjectHandleImpl
extends NbProjectHandle {
    private Icon icon;
    private String displayName;
    URL url;
    private SourceHandleImpl parent;

    NbProjectHandleImpl(Project p, SourceHandleImpl parent) throws IOException {
        this.displayName = ProjectUtils.getInformation((Project)p).getDisplayName();
        this.icon = ProjectUtils.getInformation((Project)p).getIcon();
        this.url = p.getProjectDirectory().getURL();
        p.getProjectDirectory().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fe) {
                try {
                    if (fe.getFile().getURL().equals(NbProjectHandleImpl.this.url)) {
                        NbProjectHandleImpl.this.remove();
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
        });
        this.parent = parent;
        assert (this.parent != null);
        assert (this.displayName != null);
        assert (this.icon != null);
        assert (this.url != null);
    }

    NbProjectHandleImpl(UnloadedProjectInformation i, SourceHandleImpl parent) {
        this.displayName = i.getDisplayName();
        this.icon = i.getIcon();
        this.url = i.getURL();
        this.parent = parent;
        assert (this.parent != null);
        assert (this.displayName != null);
        assert (this.icon != null);
        assert (this.url != null);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public Project getProject() {
        try {
            FileObject fo = URLMapper.findFileObject((URL)this.url);
            if (fo == null) {
                return null;
            }
            Project project = ProjectManager.getDefault().findProject(fo);
            if (project == null) {
                Logger.getLogger(NbProjectHandleImpl.class.getName()).severe("Cannot find project for " + fo.getPath());
            }
            return project;
        }
        catch (IOException ex) {
            Logger.getLogger(NbProjectHandleImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            this.remove();
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public void remove() {
        this.parent.remove(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NbProjectHandleImpl other = (NbProjectHandleImpl)obj;
        return this.url == other.url || this.url != null && this.url.equals(other.url);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }
}

