/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.netbeans.modules.kenai.api.KenaiNotification;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.NotificationExtension;
import org.xmlpull.v1.XmlPullParser;

public class NotificationExtensionProvider
implements PacketExtensionProvider {
    static final String NAMESPACE = "http://kenai.com/schema/XMPPNotification";

    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date stamp = formatter.parse(parser.getAttributeValue("", "stamp"));
        String serviceName = parser.getAttributeValue("", "service");
        String author = parser.getAttributeValue("", "user");
        URI uri = new URI(parser.getAttributeValue("", "uri"));
        String feature = parser.getAttributeValue("", "feature");
        KenaiService.Type type = KenaiService.Type.forId((String)parser.getAttributeValue("", "type"));
        int tag = parser.next();
        ArrayList<KenaiNotification.Modification> modifications = new ArrayList<KenaiNotification.Modification>();
        while (tag != 3 || !"notification".equals(parser.getName())) {
            if (tag == 2 && "modification".equals(parser.getName())) {
                KenaiNotification.Modification.Type mtype;
                String mid = parser.getAttributeValue("", "id");
                String mresource = parser.getAttributeValue("", "resource");
                try {
                    mtype = KenaiNotification.Modification.Type.valueOf((String)parser.getAttributeValue("", "type").toUpperCase());
                }
                catch (Exception e) {
                    mtype = KenaiNotification.Modification.Type.UNKNOWN;
                }
                modifications.add(new KenaiNotification.Modification(mresource, mid, mtype));
            }
            tag = parser.next();
        }
        return new NotificationExtension("notification", NAMESPACE, new KenaiNotification(stamp, type, uri, author, serviceName, feature, modifications));
    }
}

