/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.osgi.AccessQueryImpl;
import org.netbeans.modules.maven.osgi.OSGIRecoPrivTemplates;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MavenOSGILookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup lookup) {
        Project project = (Project)lookup.lookup(Project.class);
        assert (project != null);
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)new OSGIRecoPrivTemplates(project));
        return new Provider(project, instanceContent);
    }

    private static class Provider
    extends AbstractLookup
    implements PropertyChangeListener {
        private Project project;
        private InstanceContent content;
        private String lastType = "jar";
        private AccessQueryImpl lastAccess = null;

        public Provider(Project project, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.project = project;
            this.content = instanceContent;
            this.checkOSGI();
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.checkOSGI();
            }
        }

        private void checkOSGI() {
            NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            String string = nbMavenProject.getPackagingType();
            if (string == null) {
                string = "jar";
            }
            if ("bundle".equals(string) && !this.lastType.equals(string)) {
                if (this.lastAccess == null) {
                    this.lastAccess = new AccessQueryImpl(this.project);
                }
                this.content.add((Object)this.lastAccess);
            } else if (this.lastAccess != null && !"bundle".equals(string)) {
                this.content.remove((Object)this.lastAccess);
            }
            this.lastType = string;
        }
    }
}

