/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.spi;

import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.JComponent;
import org.netbeans.modules.apisupport.project.ui.wizard.TypeChooserPanelImpl;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class ModuleTypePanel {
    private static final String IS_STANDALONE_OR_SUITE_COMPONENT = "tc_isStandaloneOrSuiteComp";
    private static final String SUITE_ROOT = "tc_suiteRoot";
    private static final String ACTIVE_PLATFORM_ID = "tc_activePlatform_id";
    private static final String ACTIVE_NB_PLATFORM = "tc_activeNBPlatform";
    private static final String IS_NETBEANS_ORG = "isNetBeansOrg";
    private static final String PROJECT_FOLDER = "tc_projectFolderForTypeChooser";

    private ModuleTypePanel() {
    }

    public static JComponent createComponent(WizardDescriptor wizard) {
        return new TypeChooserPanelImpl(wizard);
    }

    public static boolean validate(WizardDescriptor settings) {
        if (ModuleTypePanel.isSuiteComponent(settings) && ModuleTypePanel.getSuiteRoot(settings) == null) {
            ModuleTypePanel.setErrorMessage(settings, NbBundle.getMessage(ModuleTypePanel.class, (String)"MSG_ChooseRegularSuite"));
            return false;
        }
        if (ModuleTypePanel.isStandalone(settings) && (ModuleTypePanel.getActiveNbPlatform(settings) == null || !ModuleTypePanel.getActiveNbPlatform(settings).isValid())) {
            ModuleTypePanel.setErrorMessage(settings, NbBundle.getMessage(ModuleTypePanel.class, (String)"MSG_ChosenPlatformIsInvalid"));
            return false;
        }
        return true;
    }

    public static boolean isPanelUpdated(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        return IS_STANDALONE_OR_SUITE_COMPONENT.equals(name) || SUITE_ROOT.equals(name) || ACTIVE_PLATFORM_ID.equals(name);
    }

    public static void setProjectFolder(WizardDescriptor settings, File value) {
        settings.putProperty(PROJECT_FOLDER, (Object)value);
    }

    public static boolean isSuiteComponent(WizardDescriptor wizard) {
        Object value = wizard.getProperty(IS_STANDALONE_OR_SUITE_COMPONENT);
        return !ModuleTypePanel.extractBoolean(value, true);
    }

    public static boolean isStandalone(WizardDescriptor wizard) {
        Object value = wizard.getProperty(IS_STANDALONE_OR_SUITE_COMPONENT);
        return ModuleTypePanel.extractBoolean(value, false);
    }

    public static boolean isNetBeansOrg(WizardDescriptor wizard) {
        Object value = wizard.getProperty(IS_NETBEANS_ORG);
        return ModuleTypePanel.extractBoolean(value, false);
    }

    public static String getSuiteRoot(WizardDescriptor wizard) {
        Object value = wizard.getProperty(SUITE_ROOT);
        return ModuleTypePanel.extractString(value, null);
    }

    public static String getActivePlatformId(WizardDescriptor wizard) {
        Object value = wizard.getProperty(ACTIVE_PLATFORM_ID);
        return ModuleTypePanel.extractString(value, null);
    }

    private static NbPlatform getActiveNbPlatform(WizardDescriptor wizard) {
        Object value = wizard.getProperty(ACTIVE_NB_PLATFORM);
        if (value != null && value instanceof NbPlatform) {
            return (NbPlatform)value;
        }
        return null;
    }

    private static boolean extractBoolean(Object value, boolean defaultValue) {
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    private static String extractString(Object value, String defaultValue) {
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    private static void setErrorMessage(WizardDescriptor settings, String message) {
        settings.putProperty("WizardPanel_errorMessage", (Object)message);
    }
}

