/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.io.PrintStream;

public class Tracer {
    private int step = 4;
    private PrintStream pstream;
    private StringBuilder indentBuffer = new StringBuilder();

    public Tracer() {
        this(System.err);
    }

    public Tracer(PrintStream pstream) {
        this.pstream = pstream;
    }

    public Tracer(PrintStream pstream, int step) {
        this.pstream = pstream;
        this.step = step;
    }

    public void indent() {
        this.setupIndentBuffer(this.indentBuffer.length() + this.step);
    }

    public void unindent() {
        this.setupIndentBuffer(this.indentBuffer.length() - this.step);
    }

    private void setupIndentBuffer(int len) {
        if (len <= 0) {
            this.indentBuffer.setLength(0);
        } else {
            this.indentBuffer.setLength(len);
            for (int i = 0; i < len; ++i) {
                this.indentBuffer.setCharAt(i, ' ');
            }
        }
    }

    public void trace(Object arg) {
        System.err.println(this.indentBuffer.toString() + arg);
    }
}

