/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class GrailsProjectSettings {
    private static final GrailsProjectSettings INSTANCE = new GrailsProjectSettings();
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";
    private static final String NEW_PROJECT_COUNT = "newProjectCount";

    public static GrailsProjectSettings getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(GrailsProjectSettings.class);
    }

    public int getNewProjectCount() {
        return GrailsProjectSettings.getPreferences().getInt(NEW_PROJECT_COUNT, 0);
    }

    public void setNewProjectCount(int count) {
        GrailsProjectSettings.getPreferences().putInt(NEW_PROJECT_COUNT, count);
    }

    public File getLastUsedArtifactFolder() {
        return new File(GrailsProjectSettings.getPreferences().get(LAST_USED_ARTIFACT_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedArtifactFolder(File folder) {
        assert (folder != null) : "Folder can not be null";
        String path = folder.getAbsolutePath();
        GrailsProjectSettings.getPreferences().put(LAST_USED_ARTIFACT_FOLDER, path);
    }
}

