/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class GeneratingBracketCompleter {
    static final String TYPE_PLACEHOLDER = "<type>";

    static void generateDocTags(final BaseDocument doc, final int offset, final int indent) {
        FileObject file = NavUtils.getFile((Document)doc);
        if (file == null) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    class Result
                    extends Error {
                        private ASTNode node;

                        public Result(ASTNode node) {
                            this.node = node;
                        }
                    }
                    final ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                    ASTNode n = null;
                    try {
                        new DefaultVisitor(){

                            @Override
                            public void scan(ASTNode node) {
                                Comment c;
                                if (node != null && (c = Utils.getCommentForNode(Utils.getRoot(parserResult), node)) != null && c.getStartOffset() <= offset && offset <= c.getEndOffset()) {
                                    throw new Result(node);
                                }
                                super.scan(node);
                            }
                        }.scan(Utils.getRoot(parserResult));
                    }
                    catch (Result r) {
                        n = r.node;
                    }
                    if (n == null) {
                        return;
                    }
                    if (n instanceof FunctionDeclaration) {
                        GeneratingBracketCompleter.generateFunctionDoc(doc, offset, indent, parserResult, (FunctionDeclaration)n);
                    }
                    if (n instanceof MethodDeclaration) {
                        GeneratingBracketCompleter.generateFunctionDoc(doc, offset, indent, parserResult, ((MethodDeclaration)n).getFunction());
                    }
                    if (n instanceof FieldsDeclaration) {
                        GeneratingBracketCompleter.generateFieldDoc(doc, offset, indent, parserResult, (FieldsDeclaration)n);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void generateFunctionDoc(BaseDocument doc, int offset, int indent, ParserResult info, FunctionDeclaration decl) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        ScannerImpl i = new ScannerImpl(info, decl);
        i.scan(decl);
        GeneratingBracketCompleter.addVariables(doc, toAdd, "@global", indent, i.globals);
        GeneratingBracketCompleter.addVariables(doc, toAdd, "@staticvar", indent, i.staticvars);
        GeneratingBracketCompleter.addVariables(doc, toAdd, "@param", indent, i.params);
        if (i.hasReturn) {
            GeneratingBracketCompleter.generateDocEntry(doc, toAdd, "@return", indent, null, i.returnType);
        }
        doc.insertString(offset - 1, toAdd.toString(), null);
    }

    private static void addVariables(BaseDocument doc, StringBuilder toAdd, String text, int indent, List<Pair<String, String>> vars) {
        for (Pair<String, String> p : vars) {
            GeneratingBracketCompleter.generateDocEntry(doc, toAdd, text, indent, p.getA(), p.getB());
        }
    }

    private static void generateDocEntry(BaseDocument doc, StringBuilder toAdd, String text, int indent, String name, String type) {
        toAdd.append("\n");
        toAdd.append(IndentUtils.createIndentString((Document)doc, (int)indent));
        toAdd.append(" * ");
        toAdd.append(text);
        if (type != null) {
            if (type != null) {
                toAdd.append(" ");
                toAdd.append(type);
            }
        } else {
            toAdd.append(" ");
            toAdd.append(TYPE_PLACEHOLDER);
        }
        if (name != null) {
            toAdd.append(" ");
            toAdd.append(name);
        }
    }

    private static void generateFieldDoc(BaseDocument doc, int offset, int indent, ParserResult info, FieldsDeclaration decl) throws BadLocationException {
        StringBuilder toAdd = new StringBuilder();
        GeneratingBracketCompleter.generateDocEntry(doc, toAdd, "@var", indent, null, null);
        doc.insertString(offset - 1, toAdd.toString(), null);
    }

    private static final class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }
    }

    private static class ScannerImpl
    extends DefaultVisitor {
        private List<Pair<String, String>> globals = new LinkedList<Pair<String, String>>();
        private List<Pair<String, String>> staticvars = new LinkedList<Pair<String, String>>();
        private List<Pair<String, String>> params = new LinkedList<Pair<String, String>>();
        final Set<VariableName> declaredVariables = new HashSet<VariableName>();
        private boolean hasReturn;
        private String returnType;
        private final FunctionDeclaration decl;
        private final FunctionScope fnc;

        public ScannerImpl(ParserResult info, FunctionDeclaration decl) {
            if (info instanceof PHPParseResult) {
                PHPParseResult parseResult = (PHPParseResult)info;
                Model model = parseResult.getModel();
                VariableScope variableScope = model.getVariableScope(decl.getEndOffset() - 1);
                if (variableScope instanceof FunctionScope) {
                    this.fnc = (FunctionScope)variableScope;
                    this.declaredVariables.addAll(this.fnc.getDeclaredVariables());
                } else {
                    this.fnc = null;
                }
            } else {
                this.fnc = null;
            }
            this.decl = decl;
        }

        @Override
        public void scan(ASTNode node) {
            if (this.fnc != null) {
                super.scan(node);
            }
        }

        @Override
        public void visit(FormalParameter p) {
            Reference ref;
            String name = "";
            Expression expr = p.getParameterName();
            Variable var = null;
            if (expr instanceof Variable) {
                var = (Variable)expr;
            }
            if (expr instanceof Reference && (ref = (Reference)expr).getExpression() instanceof Variable) {
                var = (Variable)ref.getExpression();
            }
            if (var != null && var.getName() instanceof Identifier) {
                name = ((Identifier)var.getName()).getName();
            }
            if (name != null) {
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (type != null && type.contains("@")) {
                        type = null;
                    }
                    this.params.add(new Pair<String, String>(variable.getName(), type));
                }
            }
            super.visit(p);
        }

        @Override
        public void visit(GlobalStatement node) {
            for (Variable v : node.getVariables()) {
                String name = CodeUtils.extractVariableName(v);
                if (name == null) continue;
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (type != null && type.contains("@")) {
                        type = null;
                    }
                    this.globals.add(new Pair<String, String>(variable.getName(), type));
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(ReturnStatement node) {
            String type;
            this.hasReturn = true;
            Collection<? extends String> typeNames = this.fnc.getReturnTypeNames();
            String string = type = typeNames.isEmpty() ? null : typeNames.iterator().next();
            if (type != null && type.contains("@")) {
                type = null;
            }
            this.returnType = type;
        }

        @Override
        public void visit(StaticStatement node) {
            for (Variable v : node.getVariables()) {
                String name = CodeUtils.extractVariableName(v);
                if (name == null) continue;
                for (VariableName variable : ElementFilter.forName(NameKind.exact(name)).filter(this.declaredVariables)) {
                    String type;
                    Collection typeNames = variable.getTypeNames(variable.getNameRange().getEnd());
                    String string = type = typeNames.isEmpty() ? null : (String)typeNames.iterator().next();
                    if (type != null && type.contains("@")) {
                        type = null;
                    }
                    this.staticvars.add(new Pair<String, String>(variable.getName(), type));
                }
            }
            super.visit(node);
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (node == this.decl) {
                super.visit(node);
            }
        }

        @Override
        public void visit(ClassDeclaration node) {
        }
    }
}

