/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.ServicePermissionCollection;

public final class ServicePermission
extends BasicPermission {
    static final long serialVersionUID = -7662148639076511574L;
    public static final String GET = "get";
    public static final String REGISTER = "register";
    private static final int ACTION_GET = 1;
    private static final int ACTION_REGISTER = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private transient int action_mask = 0;
    private String actions = null;

    public ServicePermission(String name, String actions) {
        this(name, ServicePermission.getMask(actions));
    }

    ServicePermission(String name, int mask) {
        super(name);
        this.init(mask);
    }

    private void init(int mask) {
        if (mask == 0 || (mask & 3) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    private static int getMask(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 2 || a[i - 2] != 'g' && a[i - 2] != 'G' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 't' && a[i] != 'T')) {
                matchlen = 3;
                mask |= 1;
            } else if (!(i < 7 || a[i - 7] != 'r' && a[i - 7] != 'R' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'g' && a[i - 5] != 'G' || a[i - 4] != 'i' && a[i - 4] != 'I' || a[i - 3] != 's' && a[i - 3] != 'S' || a[i - 2] != 't' && a[i - 2] != 'T' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 'r' && a[i] != 'R')) {
                matchlen = 8;
                mask |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p) {
        if (p instanceof ServicePermission) {
            ServicePermission target = (ServicePermission)p;
            return (this.action_mask & target.action_mask) == target.action_mask && super.implies(p);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            if ((this.action_mask & 1) == 1) {
                sb.append(GET);
                comma = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(REGISTER);
            }
            this.actions = ((Object)sb).toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new ServicePermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServicePermission)) {
            return false;
        }
        ServicePermission p = (ServicePermission)obj;
        return this.action_mask == p.action_mask && this.getName().equals(p.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(ServicePermission.getMask(this.actions));
    }
}

