/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.ruby.RubyPredefinedVariable;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;

public class Call {
    private static final Pattern CALL_TO_NEW = Pattern.compile(".+(\\.new(\\z|\\(.*\\)))");
    private static final Pattern CALL_TO_NEW_IN_CHAIN = Pattern.compile(".+(\\.new(\\z|\\(.*\\)\\.?\\w*|\\.\\w?.*))");
    public static final Call LOCAL = new Call(RubyType.unknown(), null, false, false);
    public static final Call NONE = new Call(RubyType.unknown(), null, false, false);
    public static final Call UNKNOWN = new Call(RubyType.unknown(), null, false, false);
    private final RubyType type;
    private final String lhs;
    private final boolean isStatic;
    private final boolean methodExpected;
    private final boolean constantExpected;
    private boolean isLHSConstant;
    private static final String EMPTY_LHS = "EMPTY_LHS";

    private Call(RubyType type, String lhs, boolean isStatic, boolean methodExpected) {
        this(type, lhs, isStatic, methodExpected, false);
    }

    private Call(RubyType type, String lhs, boolean isStatic, boolean methodExpected, boolean constantExpected) {
        this.type = type;
        this.lhs = lhs;
        this.methodExpected = methodExpected;
        if (lhs == null && type.isKnown()) {
            assert (type.isSingleton()) : "should be singleton, was: " + type;
            lhs = type.first();
        }
        this.isStatic = isStatic;
        this.constantExpected = constantExpected;
    }

    private void setLHSConstant(boolean isLHSConstant) {
        this.isLHSConstant = isLHSConstant;
    }

    public RubyType getType() {
        return this.type;
    }

    public String getLhs() {
        if (EMPTY_LHS.equals(this.lhs)) {
            return "";
        }
        return this.lhs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isLHSConstant() {
        return this.isLHSConstant;
    }

    public boolean isSimpleIdentifier() {
        if (this.lhs == null || this.lhs.equals(EMPTY_LHS)) {
            return false;
        }
        int n = this.lhs.length();
        for (int i = 0; i < n; ++i) {
            char c = this.lhs.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '@' || c == '$') continue;
            return false;
        }
        return true;
    }

    public boolean isConstantExpected() {
        return this.constantExpected;
    }

    public boolean isMethodExpected() {
        return this.methodExpected;
    }

    public String toString() {
        if (this == LOCAL) {
            return "LOCAL";
        }
        if (this == NONE) {
            return "NONE";
        }
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        return "Call(type: " + this.type + ", lhs: " + this.lhs + ", isStatic: " + this.isStatic + ", isLHSConstant: " + this.isLHSConstant + ')';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Call getCallType(BaseDocument doc, TokenHierarchy<Document> th, int offset) {
        int lastSeparatorOffset;
        Token token;
        TokenSequence ts = LexUtilities.getRubyTokenSequence(th, offset);
        if (ts == null) {
            return NONE;
        }
        ts.move(offset);
        boolean methodExpected = false;
        boolean constantExpected = false;
        if (!ts.moveNext() && !ts.movePrevious()) {
            return NONE;
        }
        if (ts.offset() == offset) {
            ts.movePrevious();
        }
        if ((token = ts.token()) == null) return LOCAL;
        TokenId id = token.id();
        if (id == RubyTokenId.WHITESPACE) {
            return LOCAL;
        }
        if (id == RubyTokenId.EMBEDDED_RUBY) {
            ts = ts.embedded();
            assert (ts != null);
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return NONE;
            }
            token = ts.token();
            id = token.id();
        }
        if (id == RubyTokenId.IDENTIFIER || id == RubyTokenId.CONSTANT || id.primaryCategory().equals("keyword")) {
            String tokenText = ((Object)token.text()).toString();
            if (".".equals(tokenText)) {
                methodExpected = true;
            } else if (!"::".equals(tokenText)) {
                methodExpected = true;
                if (Character.isUpperCase(tokenText.charAt(0))) {
                    methodExpected = false;
                }
                if (!ts.movePrevious()) {
                    return LOCAL;
                }
            }
            token = ts.token();
            id = token.id();
        }
        if (id == RubyTokenId.DOT) {
            methodExpected = true;
        } else if (id != RubyTokenId.COLON3) {
            if (id != RubyTokenId.IDENTIFIER) return LOCAL;
            String t = ((Object)token.text()).toString();
            if (t.equals(".")) {
                methodExpected = true;
            } else {
                if (!t.equals("::")) return LOCAL;
                constantExpected = true;
            }
        }
        int beginOffset = lastSeparatorOffset = ts.offset();
        int lineStart = 0;
        try {
            if (offset > doc.getLength()) {
                offset = doc.getLength();
            }
            lineStart = Utilities.getRowStart((BaseDocument)doc, (int)offset);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        boolean dotted = false;
        int inParens = 0;
        while (ts.movePrevious() && ts.offset() >= lineStart) {
            Call call;
            token = ts.token();
            id = token.id();
            if (id == RubyTokenId.LPAREN) {
                if (inParens <= 0) break;
                --inParens;
                continue;
            }
            if (id == RubyTokenId.RPAREN) {
                ++inParens;
                continue;
            }
            if (inParens > 0) continue;
            String tokenText = null;
            if (id == RubyTokenId.ANY_KEYWORD) {
                tokenText = ((Object)token.text()).toString();
            }
            if (id == RubyTokenId.WHITESPACE) break;
            if (!dotted && (call = Call.tryLiteral(id, methodExpected, tokenText)) != null) {
                return call;
            }
            if (id == RubyTokenId.GLOBAL_VAR || id == RubyTokenId.INSTANCE_VAR || id == RubyTokenId.CLASS_VAR || id == RubyTokenId.IDENTIFIER || id.primaryCategory().equals("keyword") || id == RubyTokenId.DOT || id == RubyTokenId.COLON3 || id == RubyTokenId.CONSTANT || id == RubyTokenId.SUPER || id == RubyTokenId.SELF || Call.isLiteral(id)) {
                beginOffset = ts.offset();
                if (id != RubyTokenId.DOT) continue;
                dotted = true;
                continue;
            }
            if (id == RubyTokenId.LBRACE || id == RubyTokenId.LBRACKET) break;
            return UNKNOWN;
        }
        if (beginOffset >= lastSeparatorOffset) return UNKNOWN;
        try {
            String lhs = doc.getText(beginOffset, lastSeparatorOffset - beginOffset);
            if (lhs.equals("super") || lhs.equals("self")) {
                return new Call(RubyType.create(lhs), lhs, false, true);
            }
            if (Character.isUpperCase(lhs.charAt(0))) {
                Object type;
                int constructorCallLength = Call.isCallToNew(lhs);
                if (constructorCallLength != -1 && RubyUtils.isValidConstantFQN((String)(type = lhs.substring(0, lhs.length() - constructorCallLength)))) {
                    return new Call(RubyType.create((String)type), lhs, false, methodExpected);
                }
                type = RubyPredefinedVariable.getType(lhs);
                boolean isStatic = type == null && !Call.containsCallToNew(lhs) && !Call.isChainedCall(lhs) || constantExpected;
                boolean isLHSConstant = RubyUtils.isValidConstantFQN(lhs);
                if (type == null && isLHSConstant) {
                    type = RubyType.create(lhs);
                }
                Object rubyType = type == null ? RubyType.unknown() : type;
                Call call = new Call((RubyType)rubyType, lhs, isStatic, methodExpected, constantExpected);
                call.setLHSConstant(isLHSConstant);
                return call;
            }
            RubyType typeS = RubyPredefinedVariable.getType(lhs);
            RubyType type = typeS == null ? RubyType.unknown() : typeS;
            return new Call(type, lhs, false, methodExpected, constantExpected);
        }
        catch (BadLocationException ble) {
            return LOCAL;
        }
    }

    private static int isCallToNew(String lhs) {
        Matcher matcher = CALL_TO_NEW.matcher(lhs);
        if (!matcher.matches()) {
            return -1;
        }
        return matcher.group(1).length();
    }

    private static boolean containsCallToNew(String lhs) {
        return CALL_TO_NEW_IN_CHAIN.matcher(lhs).matches();
    }

    private static boolean isChainedCall(String lhs) {
        return lhs.indexOf(46) > 0;
    }

    private static Call tryLiteral(TokenId id, boolean methodExpected, String tokenText) {
        if (id == RubyTokenId.RBRACKET) {
            return new Call(RubyType.ARRAY, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.RBRACE) {
            return new Call(RubyType.HASH, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.STRING_END || id == RubyTokenId.QUOTED_STRING_END) {
            return new Call(RubyType.STRING, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.REGEXP_END) {
            return new Call(RubyType.REGEXP, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.INT_LITERAL) {
            return new Call(RubyType.FIXNUM, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.FLOAT_LITERAL) {
            return new Call(RubyType.FLOAT, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.TYPE_SYMBOL) {
            return new Call(RubyType.SYMBOL, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.RANGE) {
            return new Call(RubyType.RANGE, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.ANY_KEYWORD && "nil".equals(tokenText)) {
            return new Call(RubyType.NIL_CLASS, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.ANY_KEYWORD && "true".equals(tokenText)) {
            return new Call(RubyType.TRUE_CLASS, EMPTY_LHS, false, methodExpected);
        }
        if (id == RubyTokenId.ANY_KEYWORD && "false".equals(tokenText)) {
            return new Call(RubyType.FALSE_CLASS, EMPTY_LHS, false, methodExpected);
        }
        return null;
    }

    private static boolean isLiteral(TokenId id) {
        return id == RubyTokenId.RBRACKET || id == RubyTokenId.RBRACE || id == RubyTokenId.STRING_END || id == RubyTokenId.REGEXP_END || id == RubyTokenId.INT_LITERAL || id == RubyTokenId.FLOAT_LITERAL || id == RubyTokenId.TYPE_SYMBOL || id == RubyTokenId.RANGE || id == RubyTokenId.ANY_KEYWORD || id == RubyTokenId.ANY_KEYWORD || id == RubyTokenId.ANY_KEYWORD;
    }
}

