/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.validation;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;

public class DefaultModelValidator
implements ModelValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    public ModelValidationResult validate(Model model) {
        Reporting reporting;
        Build build;
        Parent parent;
        ModelValidationResult result = new ModelValidationResult();
        this.validateStringNotEmpty("modelVersion", result, model.getModelVersion());
        this.validateId("groupId", result, model.getGroupId());
        this.validateId("artifactId", result, model.getArtifactId());
        this.validateStringNotEmpty("packaging", result, model.getPackaging());
        if (!model.getModules().isEmpty() && !"pom".equals(model.getPackaging())) {
            result.addMessage("Packaging '" + model.getPackaging() + "' is invalid. Aggregator projects " + "require 'pom' as packaging.");
        }
        if ((parent = model.getParent()) != null && parent.getGroupId().equals(model.getGroupId()) && parent.getArtifactId().equals(model.getArtifactId())) {
            result.addMessage("The parent element cannot have the same ID as the project.");
        }
        this.validateStringNotEmpty("version", result, model.getVersion());
        for (Dependency d : model.getDependencies()) {
            this.validateId("dependencies.dependency.artifactId", result, d.getArtifactId());
            this.validateId("dependencies.dependency.groupId", result, d.getGroupId());
            this.validateStringNotEmpty("dependencies.dependency.type", result, d.getType(), this.dependencySourceHint(d));
            this.validateStringNotEmpty("dependencies.dependency.version", result, d.getVersion(), this.dependencySourceHint(d));
            if (Artifact.SCOPE_SYSTEM.equals(d.getScope())) {
                String systemPath = d.getSystemPath();
                if (StringUtils.isEmpty(systemPath)) {
                    result.addMessage("For dependency " + d + ": system-scoped dependency must specify systemPath.");
                    continue;
                }
                if (new File(systemPath).isAbsolute()) continue;
                result.addMessage("For dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                continue;
            }
            if (!StringUtils.isNotEmpty(d.getSystemPath())) continue;
            result.addMessage("For dependency " + d + ": only dependency with system scope can specify systemPath.");
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for (Dependency d : mgmt.getDependencies()) {
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.artifactId", result, d.getArtifactId());
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.groupId", result, d.getGroupId());
                if (Artifact.SCOPE_SYSTEM.equals(d.getScope())) {
                    String systemPath = d.getSystemPath();
                    if (StringUtils.isEmpty(systemPath)) {
                        result.addMessage("For managed dependency " + d + ": system-scoped dependency must specify systemPath.");
                        continue;
                    }
                    if (new File(systemPath).isAbsolute()) continue;
                    result.addMessage("For managed dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                    continue;
                }
                if (!StringUtils.isNotEmpty(d.getSystemPath())) continue;
                result.addMessage("For managed dependency " + d + ": only dependency with system scope can specify systemPath.");
            }
        }
        if ((build = model.getBuild()) != null) {
            for (Plugin p : build.getPlugins()) {
                this.validateStringNotEmpty("build.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("build.plugins.plugin.groupId", result, p.getGroupId());
            }
            for (Resource r : build.getResources()) {
                this.validateStringNotEmpty("build.resources.resource.directory", result, r.getDirectory());
            }
            for (Resource r : build.getTestResources()) {
                this.validateStringNotEmpty("build.testResources.testResource.directory", result, r.getDirectory());
            }
        }
        if ((reporting = model.getReporting()) != null) {
            for (ReportPlugin p : reporting.getPlugins()) {
                this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("reporting.plugins.plugin.groupId", result, p.getGroupId());
            }
        }
        this.validateRepositories(result, model.getRepositories(), "repositories.repository");
        this.forcePluginExecutionIdCollision(model, result);
        return result;
    }

    private boolean validateId(String fieldName, ModelValidationResult result, String id) {
        if (!this.validateStringNotEmpty(fieldName, result, id)) {
            return false;
        }
        boolean match = id.matches(ID_REGEX);
        if (!match) {
            result.addMessage("'" + fieldName + "' with value '" + id + "' does not match a valid id pattern.");
        }
        return match;
    }

    private void validateRepositories(ModelValidationResult result, List repositories, String prefix) {
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(String.valueOf(prefix) + ".id", result, repository.getId());
            this.validateStringNotEmpty(String.valueOf(prefix) + ".url", result, repository.getUrl());
        }
    }

    private void forcePluginExecutionIdCollision(Model model, ModelValidationResult result) {
        List plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            for (Plugin plugin : plugins) {
                try {
                    plugin.getExecutionsAsMap();
                }
                catch (IllegalStateException collisionException) {
                    result.addMessage(collisionException.getMessage());
                }
            }
        }
    }

    private String dependencySourceHint(Dependency d) {
        return String.valueOf(d.getGroupId()) + ":" + d.getArtifactId();
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, String string) {
        return this.validateStringNotEmpty(fieldName, result, string, null);
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, String string, String sourceHint) {
        if (!this.validateNotNull(fieldName, result, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        if (sourceHint != null) {
            result.addMessage("'" + fieldName + "' is missing for " + sourceHint);
        } else {
            result.addMessage("'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementStringNotEmpty(Object subElementInstance, String fieldName, ModelValidationResult result, String string) {
        if (!this.validateSubElementNotNull(subElementInstance, fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelValidationResult result, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        if (sourceHint != null) {
            result.addMessage("'" + fieldName + "' is missing for " + sourceHint);
        } else {
            result.addMessage("'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementNotNull(Object subElementInstance, String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }
}

