/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;

public abstract class ImageWatched {
    public static Link endlink = new Link();
    public Link watcherList = endlink;

    public synchronized void addWatcher(ImageObserver imageObserver) {
        if (imageObserver != null && !this.isWatcher(imageObserver)) {
            this.watcherList = new WeakLink(imageObserver, this.watcherList);
        }
    }

    public synchronized boolean isWatcher(ImageObserver imageObserver) {
        return this.watcherList.isWatcher(imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatcher(ImageObserver imageObserver) {
        ImageWatched imageWatched = this;
        synchronized (imageWatched) {
            this.watcherList = this.watcherList.removeWatcher(imageObserver);
        }
        if (this.watcherList == endlink) {
            this.notifyWatcherListEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWatcherListEmpty() {
        ImageWatched imageWatched = this;
        synchronized (imageWatched) {
            this.watcherList = this.watcherList.removeWatcher(null);
        }
        return this.watcherList == endlink;
    }

    public void newInfo(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.watcherList.newInfo(image, n, n2, n3, n4, n5)) {
            this.removeWatcher(null);
        }
    }

    protected abstract void notifyWatcherListEmpty();

    public static class WeakLink
    extends Link {
        private WeakReference<ImageObserver> myref;
        private Link next;

        public WeakLink(ImageObserver imageObserver, Link link) {
            this.myref = new WeakReference<ImageObserver>(imageObserver);
            this.next = link;
        }

        @Override
        public boolean isWatcher(ImageObserver imageObserver) {
            return this.myref.get() == imageObserver || this.next.isWatcher(imageObserver);
        }

        @Override
        public Link removeWatcher(ImageObserver imageObserver) {
            ImageObserver imageObserver2 = (ImageObserver)this.myref.get();
            if (imageObserver2 == null) {
                return this.next.removeWatcher(imageObserver);
            }
            if (imageObserver2 == imageObserver) {
                return this.next;
            }
            this.next = this.next.removeWatcher(imageObserver);
            return this;
        }

        @Override
        public boolean newInfo(Image image, int n, int n2, int n3, int n4, int n5) {
            boolean bl = this.next.newInfo(image, n, n2, n3, n4, n5);
            ImageObserver imageObserver = (ImageObserver)this.myref.get();
            if (imageObserver == null) {
                bl = true;
            } else if (!imageObserver.imageUpdate(image, n, n2, n3, n4, n5)) {
                this.myref.clear();
                bl = true;
            }
            return bl;
        }
    }

    public static class Link {
        public boolean isWatcher(ImageObserver imageObserver) {
            return false;
        }

        public Link removeWatcher(ImageObserver imageObserver) {
            return this;
        }

        public boolean newInfo(Image image, int n, int n2, int n3, int n4, int n5) {
            return false;
        }
    }
}

