/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import org.openstreetmap.josm.tools.DateParser;

public class ExifReader {
    public static Date readTime(File filename) throws ParseException {
        Date date = null;
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            Iterator dirIt = metadata.getDirectoryIterator();
            while (dirIt.hasNext()) {
                Iterator tagIt = ((Directory)dirIt.next()).getTagIterator();
                while (tagIt.hasNext()) {
                    Tag tag = (Tag)tagIt.next();
                    if (tag.getTagType() == 36867) {
                        return DateParser.parse(tag.getDescription());
                    }
                    if (tag.getTagType() != 306 && tag.getTagType() != 36868) continue;
                    date = DateParser.parse(tag.getDescription());
                }
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }
}

