/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadLocalPluginInformationTask
extends PleaseWaitRunnable {
    private Map<String, PluginInformation> availablePlugins = new HashMap<String, PluginInformation>();
    private boolean canceled;

    public ReadLocalPluginInformationTask() {
        super(I18n.tr("Reading local plugin information.."), false);
    }

    public ReadLocalPluginInformationTask(ProgressMonitor monitor) {
        super(I18n.tr("Reading local plugin information.."), monitor, false);
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }

    @Override
    protected void finish() {
    }

    protected void processJarFile(File f, String pluginName) throws PluginException {
        PluginInformation info = new PluginInformation(f, pluginName);
        if (!this.availablePlugins.containsKey(info.getName())) {
            info.localversion = info.version;
            this.availablePlugins.put(info.getName(), info);
        } else {
            this.availablePlugins.get((Object)info.getName()).localversion = info.version;
            if (info.icon != null) {
                this.availablePlugins.get((Object)info.getName()).icon = info.icon;
            }
        }
    }

    protected void scanSiteCacheFiles(ProgressMonitor monitor, File pluginsDirectory) {
        File[] siteCacheFiles = pluginsDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("^([0-9]+-)?site.*\\.txt$");
            }
        });
        if (siteCacheFiles == null || siteCacheFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr("Processing plugin site cache files..."));
        monitor.setTicksCount(siteCacheFiles.length);
        for (File f : siteCacheFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr("Processing file ''{0}''", fname));
            try {
                this.processLocalPluginInformationFile(f);
            }
            catch (PluginListParseException e) {
                System.err.println(I18n.tr("Warning: Failed to scan file ''{0}'' for plugin information. Skipping.", fname));
                e.printStackTrace();
            }
            monitor.worked(1);
        }
    }

    protected void scanIconCacheFiles(ProgressMonitor monitor, File pluginsDirectory) {
        File[] siteCacheFiles = pluginsDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("^([0-9]+-)?site.*plugin-icons\\.zip$");
            }
        });
        if (siteCacheFiles == null || siteCacheFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr("Processing plugin site cache icon files..."));
        monitor.setTicksCount(siteCacheFiles.length);
        for (File f : siteCacheFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr("Processing file ''{0}''", fname));
            for (PluginInformation pi : this.availablePlugins.values()) {
                if (pi.icon != null || pi.iconPath == null) continue;
                pi.icon = ImageProvider.getIfAvailable(null, null, null, pi.name + ".jar/" + pi.iconPath, f);
            }
            monitor.worked(1);
        }
    }

    protected void scanPluginFiles(ProgressMonitor monitor, File pluginsDirectory) {
        File[] pluginFiles = pluginsDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".jar.new");
            }
        });
        if (pluginFiles == null || pluginFiles.length == 0) {
            return;
        }
        monitor.subTask(I18n.tr("Processing plugin files..."));
        monitor.setTicksCount(pluginFiles.length);
        for (File f : pluginFiles) {
            String fname = f.getName();
            monitor.setCustomText(I18n.tr("Processing file ''{0}''", fname));
            try {
                String pluginName;
                if (fname.endsWith(".jar")) {
                    pluginName = fname.substring(0, fname.length() - 4);
                    this.processJarFile(f, pluginName);
                } else if (fname.endsWith(".jar.new")) {
                    pluginName = fname.substring(0, fname.length() - 8);
                    this.processJarFile(f, pluginName);
                }
            }
            catch (PluginException e) {
                System.err.println(I18n.tr("Warning: Failed to scan file ''{0}'' for plugin information. Skipping.", fname));
                e.printStackTrace();
            }
            monitor.worked(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanLocalPluginRepository(ProgressMonitor monitor, File pluginsDirectory) {
        if (pluginsDirectory == null) {
            return;
        }
        try {
            monitor.beginTask("");
            this.scanSiteCacheFiles(monitor, pluginsDirectory);
            this.scanIconCacheFiles(monitor, pluginsDirectory);
            this.scanPluginFiles(monitor, pluginsDirectory);
        }
        finally {
            monitor.setCustomText("");
            monitor.finishTask();
        }
    }

    protected void processLocalPluginInformationFile(File file) throws PluginListParseException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            List<PluginInformation> pis = new PluginListParser().parse(fin);
            for (PluginInformation pi : pis) {
                this.availablePlugins.put(pi.name, pi);
            }
        }
        catch (IOException e) {
            throw new PluginListParseException(e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void analyseInProcessPlugins() {
        for (PluginProxy proxy : PluginHandler.pluginList) {
            PluginInformation info = proxy.getPluginInformation();
            if (this.canceled) {
                return;
            }
            if (!this.availablePlugins.containsKey(info.name)) {
                this.availablePlugins.put(info.name, info);
                continue;
            }
            this.availablePlugins.get((Object)info.name).localversion = info.localversion;
        }
    }

    protected void filterOldPlugins() {
        for (String p : PluginHandler.DEPRECATED_PLUGINS) {
            if (this.canceled) {
                return;
            }
            if (!this.availablePlugins.containsKey(p)) continue;
            this.availablePlugins.remove(p);
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Collection<String> pluginLocations = PluginInformation.getPluginLocations();
        this.getProgressMonitor().setTicksCount(pluginLocations.size() + 2);
        if (this.canceled) {
            return;
        }
        for (String location : pluginLocations) {
            this.scanLocalPluginRepository(this.getProgressMonitor().createSubTaskMonitor(1, false), new File(location));
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        this.analyseInProcessPlugins();
        this.getProgressMonitor().worked(1);
        if (this.canceled) {
            return;
        }
        this.filterOldPlugins();
        this.getProgressMonitor().worked(1);
    }

    public List<PluginInformation> getAvailablePlugins() {
        return new ArrayList<PluginInformation>(this.availablePlugins.values());
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

