/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmReader {
    private static final Logger logger = Logger.getLogger(OsmReader.class.getName());
    private DataSet ds = new DataSet();
    private Map<PrimitiveId, OsmPrimitive> externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    private Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    private Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();

    public DataSet getDataSet() {
        return this.ds;
    }

    private OsmReader() {
        this.externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Long externalWayId : this.ways.keySet()) {
            Way w = (Way)this.externalIdMap.get(new SimplePrimitiveId(externalWayId, OsmPrimitiveType.WAY));
            ArrayList<Node> wayNodes = new ArrayList<Node>();
            for (long id : this.ways.get(externalWayId)) {
                Node n = (Node)this.externalIdMap.get(new SimplePrimitiveId(id, OsmPrimitiveType.NODE));
                if (n == null) {
                    if (id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", externalWayId, id));
                    }
                    n = (Node)this.ds.getPrimitiveById(id, OsmPrimitiveType.NODE);
                    if (n == null) {
                        n = new Node(id);
                        this.ds.addPrimitive(n);
                    }
                }
                if (n.isDeleted()) {
                    logger.warning(I18n.tr("Deleted node {0} is part of way {1}", id, w.getId()));
                    continue;
                }
                wayNodes.add(n);
            }
            w.setNodes(wayNodes);
            if (w.hasIncompleteNodes() && logger.isLoggable(Level.FINE)) {
                logger.fine(I18n.tr("Way {0} with {1} nodes has incomplete nodes because at least one node was missing in the loaded data.", externalWayId, w.getNodesCount()));
            }
            this.ds.addPrimitive(w);
        }
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive primitive : this.externalIdMap.values()) {
            if (!(primitive instanceof Node)) continue;
            this.ds.addPrimitive(primitive);
        }
    }

    private void processRelationsAfterParsing() throws IllegalDataException {
        Relation relation;
        for (Long externalRelationId : this.relations.keySet()) {
            relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(externalRelationId, OsmPrimitiveType.RELATION));
            this.ds.addPrimitive(relation);
        }
        for (Long externalRelationId : this.relations.keySet()) {
            relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(externalRelationId, OsmPrimitiveType.RELATION));
            ArrayList<RelationMember> relationMembers = new ArrayList<RelationMember>();
            for (RelationMemberData rm : this.relations.get(externalRelationId)) {
                OsmPrimitive primitive = null;
                primitive = this.externalIdMap.get(new SimplePrimitiveId(rm.id, rm.type));
                if (primitive == null) {
                    if (rm.id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", externalRelationId, rm.id));
                    }
                    primitive = this.ds.getPrimitiveById(rm.id, rm.type);
                    if (primitive == null) {
                        switch (rm.type) {
                            case NODE: {
                                primitive = new Node(rm.id);
                                break;
                            }
                            case WAY: {
                                primitive = new Way(rm.id);
                                break;
                            }
                            case RELATION: {
                                primitive = new Relation(rm.id);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        this.ds.addPrimitive(primitive);
                        this.externalIdMap.put(new SimplePrimitiveId(rm.id, rm.type), primitive);
                    }
                }
                if (primitive.isDeleted()) {
                    logger.warning(I18n.tr("Deleted member {0} is used by relation {1}", primitive.getId(), relation.getId()));
                    continue;
                }
                relationMembers.add(new RelationMember(rm.role, primitive));
            }
            relation.setMembers(relationMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull(source, "source");
        OsmReader reader = new OsmReader();
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", 2));
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing OSM data..."));
            InputSource inputSource = new InputSource(UTFInputStreamReader.create(source, "UTF-8"));
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmReader osmReader = reader;
            osmReader.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmReader.new Parser());
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Preparing data set..."));
            reader.ds.beginUpdate();
            try {
                reader.processNodesAfterParsing();
                reader.processWaysAfterParsing();
                reader.processRelationsAfterParsing();
            }
            finally {
                reader.ds.endUpdate();
            }
            progressMonitor.worked(1);
            DataSet dataSet = reader.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (SAXParseException e) {
            throw new IllegalDataException(I18n.tr("Line {0} column {1}: ", e.getLineNumber(), e.getColumnNumber()) + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalDataException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private OsmPrimitive currentPrimitive;
        private long currentExternalId;
        private String generator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String msg) throws OsmDataParsingException {
            throw new OsmDataParsingException(msg).rememberLocation(this.locator);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            block33: {
                try {
                    if (qName.equals("osm")) {
                        String v;
                        if (atts == null) {
                            this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                        }
                        if ((v = atts.getValue("version")) == null) {
                            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                        }
                        if (!v.equals("0.5") && !v.equals("0.6")) {
                            this.throwException(I18n.tr("Unsupported version: {0}", v));
                        }
                        this.generator = atts.getValue("generator");
                        OsmReader.this.ds.setVersion(v);
                        break block33;
                    }
                    if (qName.equals("bounds")) {
                        String minlon = atts.getValue("minlon");
                        String minlat = atts.getValue("minlat");
                        String maxlon = atts.getValue("maxlon");
                        String maxlat = atts.getValue("maxlat");
                        String origin = atts.getValue("origin");
                        if (minlon != null && maxlon != null && minlat != null && maxlat != null) {
                            if (origin == null) {
                                origin = this.generator;
                            }
                            Bounds bounds = new Bounds(new LatLon(Double.parseDouble(minlat), Double.parseDouble(minlon)), new LatLon(Double.parseDouble(maxlat), Double.parseDouble(maxlon)));
                            DataSource src = new DataSource(bounds, origin);
                            ((OsmReader)OsmReader.this).ds.dataSources.add(src);
                        } else {
                            this.throwException(I18n.tr("Missing manadatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{3}'',maxlat=''{4}'', origin=''{5}''.", minlon, minlat, maxlon, maxlat, origin));
                        }
                        break block33;
                    }
                    if (qName.equals("node")) {
                        NodeData nd = new NodeData();
                        nd.setCoor(new LatLon(this.getDouble(atts, "lat"), this.getDouble(atts, "lon")));
                        this.readCommon(atts, nd);
                        Node n = new Node(nd.getId(), nd.getVersion());
                        n.load(nd);
                        OsmReader.this.externalIdMap.put(nd.getPrimitiveId(), n);
                        this.currentPrimitive = n;
                        this.currentExternalId = nd.getUniqueId();
                        break block33;
                    }
                    if (qName.equals("way")) {
                        WayData wd = new WayData();
                        this.readCommon(atts, wd);
                        Way w = new Way(wd.getId(), wd.getVersion());
                        w.load(wd);
                        OsmReader.this.externalIdMap.put(wd.getPrimitiveId(), w);
                        OsmReader.this.ways.put(wd.getUniqueId(), new ArrayList());
                        this.currentPrimitive = w;
                        this.currentExternalId = wd.getUniqueId();
                        break block33;
                    }
                    if (qName.equals("nd")) {
                        long id;
                        Collection list = (Collection)OsmReader.this.ways.get(this.currentExternalId);
                        if (list == null) {
                            this.throwException(I18n.tr("Found XML element <nd> not as direct child of element <way>."));
                        }
                        if (atts.getValue("ref") == null) {
                            this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", this.currentPrimitive.getUniqueId()));
                        }
                        if ((id = this.getLong(atts, "ref")) == 0L) {
                            this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", id));
                        }
                        if (this.currentPrimitive.isDeleted()) {
                            logger.info(I18n.tr("Deleted way {0} contains nodes", this.currentPrimitive.getUniqueId()));
                        } else {
                            list.add(id);
                        }
                        break block33;
                    }
                    if (qName.equals("relation")) {
                        RelationData rd = new RelationData();
                        this.readCommon(atts, rd);
                        Relation r = new Relation(rd.getId(), rd.getVersion());
                        r.load(rd);
                        OsmReader.this.externalIdMap.put(rd.getPrimitiveId(), r);
                        OsmReader.this.relations.put(rd.getUniqueId(), new LinkedList());
                        this.currentPrimitive = r;
                        this.currentExternalId = rd.getUniqueId();
                        break block33;
                    }
                    if (qName.equals("member")) {
                        Collection list = (Collection)OsmReader.this.relations.get(this.currentExternalId);
                        if (list == null) {
                            this.throwException(I18n.tr("Found XML element <member> not as direct child of element <relation>."));
                        }
                        RelationMemberData emd = new RelationMemberData();
                        String value = atts.getValue("ref");
                        if (value == null) {
                            this.throwException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", this.currentPrimitive.getUniqueId()));
                        }
                        try {
                            emd.id = Long.parseLong(value);
                        }
                        catch (NumberFormatException e) {
                            this.throwException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(this.currentPrimitive.getUniqueId()), value));
                        }
                        value = atts.getValue("type");
                        if (value == null) {
                            this.throwException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(emd.id), Long.toString(this.currentPrimitive.getUniqueId())));
                        }
                        try {
                            emd.type = OsmPrimitiveType.fromApiTypeName(value);
                        }
                        catch (IllegalArgumentException e) {
                            this.throwException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(emd.id), Long.toString(this.currentPrimitive.getUniqueId()), value));
                        }
                        emd.role = value = atts.getValue("role");
                        if (emd.id == 0L) {
                            this.throwException(I18n.tr("Incomplete <member> specification with ref=0"));
                        }
                        if (this.currentPrimitive.isDeleted()) {
                            logger.info(I18n.tr("Deleted relation {0} contains members", this.currentPrimitive.getUniqueId()));
                        } else {
                            list.add(emd);
                        }
                        break block33;
                    }
                    if (qName.equals("tag")) {
                        String key = atts.getValue("k");
                        String value = atts.getValue("v");
                        if (key == null || value == null) {
                            this.throwException(I18n.tr("Missing key or value attribute in tag."));
                        }
                        this.currentPrimitive.put(key.intern(), value.intern());
                    } else {
                        System.out.println(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", qName));
                    }
                }
                catch (Exception e) {
                    throw new SAXParseException(e.getMessage(), this.locator, e);
                }
            }
        }

        private double getDouble(Attributes atts, String value) {
            return Double.parseDouble(atts.getValue(value));
        }

        private User createUser(String uid, String name) throws SAXException {
            if (uid == null) {
                if (name == null) {
                    return null;
                }
                return User.createLocalUser(name);
            }
            try {
                long id = Long.parseLong(uid);
                return User.createOsmUser(id, name);
            }
            catch (NumberFormatException e) {
                this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", uid));
                return null;
            }
        }

        void readCommon(Attributes atts, PrimitiveData current) throws SAXException {
            String v;
            String time;
            current.setId(this.getLong(atts, "id"));
            if (current.getUniqueId() == 0L) {
                this.throwException(I18n.tr("Illegal object with ID=0."));
            }
            if ((time = atts.getValue("timestamp")) != null && time.length() != 0) {
                current.setTimestamp(DateUtils.fromString(time));
            }
            String user = atts.getValue("user");
            String uid = atts.getValue("uid");
            current.setUser(this.createUser(uid, user));
            String visible = atts.getValue("visible");
            if (visible != null) {
                current.setVisible(Boolean.parseBoolean(visible));
            }
            String versionString = atts.getValue("version");
            int version = 0;
            if (versionString != null) {
                try {
                    version = Integer.parseInt(versionString);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.getUniqueId()), versionString));
                }
                if (OsmReader.this.ds.getVersion().equals("0.6")) {
                    if (version <= 0 && current.getUniqueId() > 0L) {
                        this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.getUniqueId()), versionString));
                    } else if (version < 0 && current.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.getUniqueId(), version, 0, "0.6"));
                        version = 0;
                    }
                } else if (OsmReader.this.ds.getVersion().equals("0.5")) {
                    if (version <= 0 && current.getUniqueId() > 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.getUniqueId(), version, 1, "0.5"));
                        version = 1;
                    } else if (version < 0 && current.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.getUniqueId(), version, 0, "0.5"));
                        version = 0;
                    }
                } else {
                    this.throwException(I18n.tr("Unknown or unsupported API version. Got {0}.", OsmReader.this.ds.getVersion()));
                }
            } else if (current.getUniqueId() > 0L && OsmReader.this.ds.getVersion() != null && OsmReader.this.ds.getVersion().equals("0.6")) {
                this.throwException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(current.getUniqueId())));
            } else if (current.getUniqueId() > 0L && OsmReader.this.ds.getVersion() != null && OsmReader.this.ds.getVersion().equals("0.5")) {
                System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.getUniqueId(), version, 1, "0.5"));
                version = 1;
            } else if (current.getUniqueId() <= 0L && OsmReader.this.ds.getVersion() != null && OsmReader.this.ds.getVersion().equals("0.5")) {
                version = 0;
            }
            current.setVersion(version);
            String action = atts.getValue("action");
            if (action != null) {
                if (action.equals("delete")) {
                    current.setDeleted(true);
                    current.setModified(current.isVisible());
                } else if (action.equals("modify")) {
                    current.setModified(true);
                }
            }
            if ((v = atts.getValue("changeset")) == null) {
                current.setChangesetId(0);
            } else {
                try {
                    current.setChangesetId(Integer.parseInt(v));
                }
                catch (NumberFormatException e) {
                    if (current.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", v, current.getUniqueId()));
                        current.setChangesetId(0);
                    }
                    this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", v));
                }
                if (current.getChangesetId() <= 0) {
                    if (current.getUniqueId() <= 0L) {
                        System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", v, current.getUniqueId()));
                        current.setChangesetId(0);
                    } else {
                        this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", v));
                    }
                }
            }
        }

        private long getLong(Attributes atts, String name) throws SAXException {
            String value = atts.getValue(name);
            if (value == null) {
                this.throwException(I18n.tr("Missing required attribute ''{0}''.", name));
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", name, value));
                return 0L;
            }
        }
    }

    private static class RelationMemberData {
        public OsmPrimitiveType type;
        public long id;
        public String role;

        private RelationMemberData() {
        }
    }
}

