/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class GpxExporter
extends FileExporter {
    private static final String warningGpl = "<html><font color='red' size='-2'>" + I18n.tr("Note: GPL is not compatible with the OSM license. Do not upload GPL licensed tracks.") + "</html>";

    public GpxExporter() {
        super(new ExtensionFileFilter("gpx,gpx.gz", "gpx", I18n.tr("GPX Files") + " (*.gpx *.gpx.gz)"));
    }

    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer or GpxLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        String fn = file.getPath();
        if (fn.indexOf(46) == -1) {
            fn = fn + ".gpx";
            file = new File(fn);
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("GPS track description")), GBC.eol());
        JTextArea desc = new JTextArea(3, 40);
        desc.setWrapStyleWord(true);
        desc.setLineWrap(true);
        p.add((Component)new JScrollPane(desc), GBC.eop().fill(1));
        JCheckBox author = new JCheckBox(I18n.tr("Add author information"), Main.pref.getBoolean("lastAddAuthor", true));
        author.setSelected(true);
        p.add((Component)author, GBC.eol());
        JLabel nameLabel = new JLabel(I18n.tr("Real name"));
        p.add((Component)nameLabel, GBC.std().insets(10, 0, 5, 0));
        JTextField authorName = new JTextField(Main.pref.get("lastAuthorName"));
        p.add((Component)authorName, GBC.eol().fill(2));
        JLabel emailLabel = new JLabel(I18n.tr("E-Mail"));
        p.add((Component)emailLabel, GBC.std().insets(10, 0, 5, 0));
        JTextField email = new JTextField(Main.pref.get("osm-server.username"));
        p.add((Component)email, GBC.eol().fill(2));
        JLabel copyrightLabel = new JLabel(I18n.tr("Copyright (URL)"));
        p.add((Component)copyrightLabel, GBC.std().insets(10, 0, 5, 0));
        JTextField copyright = new JTextField();
        p.add((Component)copyright, GBC.std().fill(2));
        JButton predefined = new JButton(I18n.tr("Predefined"));
        p.add((Component)predefined, GBC.eol().insets(5, 0, 0, 0));
        JLabel copyrightYearLabel = new JLabel(I18n.tr("Copyright year"));
        p.add((Component)copyrightYearLabel, GBC.std().insets(10, 0, 5, 5));
        JTextField copyrightYear = new JTextField("");
        p.add((Component)copyrightYear, GBC.eol().fill(2));
        JLabel warning = new JLabel("<html><font size='-2'>&nbsp;</html");
        p.add((Component)warning, GBC.eol().fill(2).insets(15, 0, 0, 0));
        GpxExporter.addDependencies(author, authorName, email, copyright, predefined, copyrightYear, nameLabel, emailLabel, copyrightLabel, copyrightYearLabel, warning);
        if (!email.getText().contains("@")) {
            authorName.setText(email.getText());
            email.setText("");
        }
        p.add((Component)new JLabel(I18n.tr("Keywords")), GBC.eol());
        JTextField keywords = new JTextField();
        p.add((Component)keywords, GBC.eop().fill(2));
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Export options"), new String[]{I18n.tr("Export and Save"), I18n.tr("Cancel")});
        ed.setButtonIcons(new String[]{"exportgpx.png", "cancel.png"});
        ed.setContent(p);
        ed.showDialog();
        if (ed.getValue() != 1) {
            return;
        }
        Main.pref.put("lastAddAuthor", author.isSelected());
        if (authorName.getText().length() != 0) {
            Main.pref.put("lastAuthorName", authorName.getText());
        }
        if (copyright.getText().length() != 0) {
            Main.pref.put("lastCopyright", copyright.getText());
        }
        GpxData gpxData = layer instanceof OsmDataLayer ? ((OsmDataLayer)layer).toGpxData() : (layer instanceof GpxLayer ? ((GpxLayer)layer).data : OsmDataLayer.toGpxData(this.getCurrentDataSet(), file));
        if (author.isSelected()) {
            if (authorName.getText().length() > 0) {
                gpxData.attr.put("meta.author.name", authorName.getText());
                gpxData.attr.put("meta.copyright.author", authorName.getText());
            }
            if (email.getText().length() > 0) {
                gpxData.attr.put("meta.author.email", email.getText());
            }
            if (copyright.getText().length() > 0) {
                gpxData.attr.put("meta.copyright.license", copyright.getText());
            }
            if (copyrightYear.getText().length() > 0) {
                gpxData.attr.put("meta.copyright.year", copyrightYear.getText());
            }
        }
        if (desc.getText().length() > 0) {
            gpxData.attr.put("meta.desc", desc.getText());
        }
        if (keywords.getText().length() > 0) {
            gpxData.attr.put("meta.keywords", keywords.getText());
        }
        try {
            FileOutputStream fo = new FileOutputStream(file);
            new GpxWriter(fo).write(gpxData);
            fo.flush();
            fo.close();
        }
        catch (IOException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while exporting {0}:\n{1}", fn, x.getMessage()), I18n.tr("Error"), 0);
        }
    }

    private static void enableCopyright(JTextField copyright, JButton predefined, JTextField copyrightYear, JLabel copyrightLabel, JLabel copyrightYearLabel, JLabel warning, boolean enable) {
        copyright.setEnabled(enable);
        predefined.setEnabled(enable);
        copyrightYear.setEnabled(enable);
        copyrightLabel.setEnabled(enable);
        copyrightYearLabel.setEnabled(enable);
        warning.setText(enable ? warningGpl : "<html><font size='-2'>&nbsp;</html");
        if (enable && copyrightYear.getText().length() == 0) {
            copyrightYear.setText(enable ? Integer.toString(Calendar.getInstance().get(1)) : "");
        } else if (!enable) {
            copyrightYear.setText("");
        }
        if (enable && copyright.getText().length() == 0) {
            copyright.setText(enable ? Main.pref.get("lastCopyright", "http://creativecommons.org/licenses/by-sa/2.5") : "");
            copyright.setCaretPosition(0);
        } else if (!enable) {
            copyright.setText("");
        }
    }

    private static void addDependencies(final JCheckBox author, final JTextField authorName, final JTextField email, final JTextField copyright, final JButton predefined, final JTextField copyrightYear, final JLabel nameLabel, final JLabel emailLabel, final JLabel copyrightLabel, final JLabel copyrightYearLabel, final JLabel warning) {
        ActionListener authorActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean b = author.isSelected();
                authorName.setEnabled(b);
                email.setEnabled(b);
                nameLabel.setEnabled(b);
                emailLabel.setEnabled(b);
                authorName.setText(b ? Main.pref.get("lastAuthorName") : "");
                email.setText(b ? Main.pref.get("osm-server.username") : "");
                boolean authorSet = authorName.getText().length() != 0;
                GpxExporter.enableCopyright(copyright, predefined, copyrightYear, copyrightLabel, copyrightYearLabel, warning, b && authorSet);
            }
        };
        author.addActionListener(authorActionListener);
        KeyAdapter authorNameListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                boolean b = authorName.getText().length() != 0 && author.isSelected();
                GpxExporter.enableCopyright(copyright, predefined, copyrightYear, copyrightLabel, copyrightYearLabel, warning, b);
            }
        };
        authorName.addKeyListener(authorNameListener);
        predefined.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JList<String> l = new JList<String>(new String[]{"Creative Commons By-SA", "public domain", "GNU Lesser Public License (LGPL)", "BSD License (MIT/X11)"});
                l.setVisibleRowCount(4);
                l.setSelectionMode(2);
                int answer = JOptionPane.showConfirmDialog(Main.parent, new JScrollPane(l), I18n.tr("Choose a predefined license"), 2, 3);
                if (answer != 0 || l.getSelectedIndex() == -1) {
                    return;
                }
                String[] urls = new String[]{"http://creativecommons.org/licenses/by-sa/2.5", "public domain", "http://www.gnu.org/copyleft/lesser.html", "http://www.opensource.org/licenses/bsd-license.php"};
                String license = "";
                for (int i : l.getSelectedIndices()) {
                    if (i == 1) {
                        license = "public domain";
                        break;
                    }
                    license = license + (license.length() == 0 ? urls[i] : ", " + urls[i]);
                }
                copyright.setText(license);
                copyright.setCaretPosition(0);
            }
        });
        authorActionListener.actionPerformed(null);
        authorNameListener.keyReleased(null);
    }

    private DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }
}

