/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.openstreetmap.josm.Main;

public abstract class CacheCustomContent {
    public static final int INTERVAL_ALWAYS = -1;
    public static final int INTERVAL_HOURLY = 3600;
    public static final int INTERVAL_DAILY = 86400;
    public static final int INTERVAL_WEEKLY = 604800;
    public static final int INTERVAL_MONTHLY = 2419200;
    public static final int INTERVAL_NEVER = Integer.MAX_VALUE;
    private byte[] data = null;
    private final String ident;
    private final File path;
    private final int updateInterval;

    protected abstract byte[] updateData();

    protected boolean isCacheValid() {
        return true;
    }

    public CacheCustomContent(String ident, int updateInterval) {
        this.ident = ident;
        this.updateInterval = updateInterval;
        this.path = new File(Main.pref.getPreferencesDir(), ident);
    }

    public byte[] updateIfRequired() {
        if ((long)(Main.pref.getInteger("cache." + this.ident, 0) + this.updateInterval) < new Date().getTime() / 1000L || !this.isCacheValid()) {
            return this.updateForce();
        }
        return this.getData();
    }

    public String updateIfRequiredString() {
        if ((long)(Main.pref.getInteger("cache." + this.ident, 0) + this.updateInterval) < new Date().getTime() / 1000L || !this.isCacheValid()) {
            return this.updateForceString();
        }
        return this.getDataString();
    }

    public byte[] updateForce() {
        this.data = this.updateData();
        this.saveToDisk();
        Main.pref.putInteger("cache." + this.ident, (int)(new Date().getTime() / 1000L));
        return this.data;
    }

    public String updateForceString() {
        this.updateForce();
        try {
            return new String(this.data, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public byte[] getData() {
        if (this.data == null) {
            this.loadFromDisk();
        }
        return this.data;
    }

    public String getDataString() {
        try {
            return new String(this.getData(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void loadFromDisk() {
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.path));
            this.data = new byte[input.available()];
            input.read(this.data);
            input.close();
        }
        catch (IOException e) {
            this.data = this.updateForce();
        }
    }

    private void saveToDisk() {
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.path));
            output.write(this.data);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flushData() {
        this.data = null;
    }
}

