/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.transform.stream.StreamSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.QuadStateCheckBox;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPreset
extends AbstractAction
implements MapView.LayerChangeListener {
    public static final int DIALOG_ANSWER_APPLY = 1;
    public static final int DIALOG_ANSWER_NEW_RELATION = 2;
    public static final int DIALOG_ANSWER_CANCEL = 3;
    public TaggingPresetMenu group = null;
    public String name;
    public String name_context;
    public String locale_name;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    private static File zipIcons = null;
    public static final String DIFFERENT = I18n.tr("<different>");
    public EnumSet<PresetType> types;
    public List<Item> data = new LinkedList<Item>();
    private static HashMap<String, String> lastValue = new HashMap();
    private boolean originalSelectionEmpty = false;

    static Usage determineTextUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.values = new TreeSet();
        for (OsmPrimitive s : sel) {
            String v = s.get(key);
            if (v != null) {
                returnValue.values.add(v);
            } else {
                returnValue.hadEmpty = true;
            }
            if (!s.hasKeys()) continue;
            returnValue.hadKeys = true;
        }
        return returnValue;
    }

    static Usage determineBooleanUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.values = new TreeSet();
        for (OsmPrimitive s : sel) {
            String booleanValue = OsmUtils.getNamedOsmBoolean(s.get(key));
            if (booleanValue == null) continue;
            returnValue.values.add(booleanValue);
        }
        return returnValue;
    }

    public TaggingPreset() {
        MapView.addLayerChangeListener(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, this.name) : I18n.tr(this.name);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + "/" + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + "/" + this.name : this.name;
    }

    public void setIcon(String iconName) {
        Collection<String> s = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageIcon icon = ImageProvider.getIfAvailable(s, "presets", null, iconName, zipIcons);
        if (icon == null) {
            System.out.println("Could not get presets icon " + iconName);
            icon = new ImageIcon(iconName);
        }
        if (Math.max(icon.getIconHeight(), icon.getIconWidth()) != 16) {
            icon = new ImageIcon(icon.getImage().getScaledInstance(16, 16, 4));
        }
        this.putValue("SmallIcon", icon);
    }

    public static EnumSet<PresetType> getType(String types) throws SAXException {
        EnumSet<PresetType> result = EnumSet.noneOf(PresetType.class);
        for (String type : Arrays.asList(types.split(","))) {
            try {
                PresetType presetType = PresetType.valueOf(type.toUpperCase());
                result.add(presetType);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(I18n.tr("Unknown type: {0}", type));
            }
        }
        return result;
    }

    public void setType(String types) throws SAXException {
        this.types = TaggingPreset.getType(types);
    }

    public static List<TaggingPreset> readAll(Reader in, boolean validate) throws SAXException {
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("item", TaggingPreset.class);
        parser.mapOnStart("separator", TaggingPresetSeparator.class);
        parser.mapBoth("group", TaggingPresetMenu.class);
        parser.map("text", Text.class);
        parser.map("link", Link.class);
        parser.mapOnStart("optional", Optional.class);
        parser.mapOnStart("roles", Roles.class);
        parser.map("role", Role.class);
        parser.map("check", Check.class);
        parser.map("combo", Combo.class);
        parser.map("label", Label.class);
        parser.map("space", Space.class);
        parser.map("key", Key.class);
        LinkedList<TaggingPreset> all = new LinkedList<TaggingPreset>();
        TaggingPreset lastmenu = null;
        Roles lastrole = null;
        if (validate) {
            parser.startWithValidation(in, "http://josm.openstreetmap.de/tagging-preset-1.0", new StreamSource(TaggingPreset.class.getResourceAsStream("/data/tagging-preset.xsd")));
        } else {
            parser.start(in);
        }
        while (parser.hasNext()) {
            TaggingPreset tp;
            Object o = parser.next();
            if (o instanceof TaggingPresetMenu) {
                tp = (TaggingPresetMenu)o;
                if (tp == lastmenu) {
                    lastmenu = ((TaggingPresetMenu)tp).group;
                } else {
                    ((TaggingPresetMenu)tp).group = lastmenu;
                    ((TaggingPresetMenu)tp).setDisplayName();
                    lastmenu = tp;
                    all.add(tp);
                }
                lastrole = null;
                continue;
            }
            if (o instanceof TaggingPresetSeparator) {
                tp = (TaggingPresetSeparator)o;
                ((TaggingPresetSeparator)tp).group = lastmenu;
                all.add(tp);
                lastrole = null;
                continue;
            }
            if (o instanceof TaggingPreset) {
                tp = (TaggingPreset)o;
                tp.group = lastmenu;
                tp.setDisplayName();
                all.add(tp);
                lastrole = null;
                continue;
            }
            if (all.size() != 0) {
                if (o instanceof Roles) {
                    all.getLast().data.add((Item)o);
                    lastrole = (Roles)o;
                    continue;
                }
                if (o instanceof Role) {
                    if (lastrole == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent"));
                    }
                    lastrole.roles.add((Role)o);
                    continue;
                }
                all.getLast().data.add((Item)o);
                lastrole = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent"));
        }
        return all;
    }

    public static Collection<TaggingPreset> readAll(String source, boolean validate) throws SAXException, IOException {
        InputStreamReader r;
        MirroredInputStream s = new MirroredInputStream(source);
        InputStream zip = s.getZipEntry("xml", "preset");
        if (zip != null) {
            zipIcons = s.getFile();
        }
        try {
            r = new InputStreamReader(zip == null ? s : zip, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            r = new InputStreamReader(zip == null ? s : zip);
        }
        return TaggingPreset.readAll(new BufferedReader(r), validate);
    }

    public static Collection<TaggingPreset> readAll(Collection<String> sources, boolean validate) {
        LinkedList<TaggingPreset> allPresets = new LinkedList<TaggingPreset>();
        for (String source : sources) {
            try {
                allPresets.addAll(TaggingPreset.readAll(source, validate));
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", source), I18n.tr("Error"), 0);
            }
            catch (SAXException e) {
                System.err.println(e.getMessage());
                System.err.println(source);
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error parsing {0}: ", source) + e.getMessage(), I18n.tr("Error"), 0);
            }
            zipIcons = null;
        }
        return allPresets;
    }

    public static LinkedList<String> getPresetSources() {
        LinkedList<String> sources = new LinkedList<String>();
        if (Main.pref.getBoolean("taggingpreset.enable-defaults", true)) {
            sources.add("resource://data/defaultpresets.xml");
        }
        sources.addAll(Main.pref.getCollection("taggingpreset.sources", new LinkedList<String>()));
        return sources;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean validate) {
        return TaggingPreset.readAll(TaggingPreset.getPresetSources(), validate);
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> selected) {
        if (this.data == null) {
            return null;
        }
        PresetPanel p = new PresetPanel();
        LinkedList<Item> l = new LinkedList<Item>();
        if (this.types != null) {
            JPanel pp = new JPanel();
            for (PresetType t : this.types) {
                JLabel la = new JLabel(ImageProvider.get(t.getIconName()));
                la.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(t.getName())));
                pp.add(la);
            }
            p.add((Component)pp, GBC.eol());
        }
        JPanel items = new JPanel(new GridBagLayout());
        for (Item i : this.data) {
            if (i instanceof Link) {
                l.add(i);
                continue;
            }
            if (!i.addToPanel(items, selected)) continue;
            p.hasElements = true;
        }
        p.add((Component)items, GBC.eol().fill());
        if (selected.size() == 0 && !this.supportsRelation()) {
            TaggingPreset.setEnabledRec(items, false);
        }
        for (Item link : l) {
            link.addToPanel(p, selected);
        }
        return p;
    }

    static void setEnabledRec(Container root, boolean enabled) {
        root.setEnabled(enabled);
        Component[] children = root.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof Container) {
                TaggingPreset.setEnabledRec((Container)children[i], enabled);
                continue;
            }
            children[i].setEnabled(enabled);
        }
    }

    public boolean isShowable() {
        for (Item i : this.data) {
            if (i instanceof Optional || i instanceof Space || i instanceof Key) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (Main.main == null) {
            return;
        }
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
        int answer = this.showDialog(sel, this.supportsRelation());
        if (sel.size() != 0 && answer == 1) {
            Command cmd = TaggingPreset.createCommand(sel, this.getChangedTags());
            if (cmd != null) {
                Main.main.undoRedo.add(cmd);
            }
        } else if (answer == 2) {
            ArrayList cmds = new ArrayList(2);
            final Relation r = new Relation();
            final HashSet<RelationMember> members = new HashSet<RelationMember>();
            for (Tag t : this.getChangedTags()) {
                r.put(t.getKey(), t.getValue());
            }
            for (OsmPrimitive osm : sel) {
                RelationMember rm = new RelationMember("", osm);
                r.addMember(rm);
                members.add(rm);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RelationEditor.getEditor(Main.main.getEditLayer(), r, members).setVisible(true);
                }
            });
        }
        Main.main.getCurrentDataSet().setSelected(Main.main.getCurrentDataSet().getSelected());
    }

    public int showDialog(Collection<OsmPrimitive> selection, final boolean showNewRelation) {
        Collection<OsmPrimitive> sel = this.createSelection(selection);
        PresetPanel p = this.createPanel(sel);
        if (p == null) {
            return 3;
        }
        int answer = 1;
        if (p.getComponentCount() != 0 && (sel.size() == 0 || p.hasElements)) {
            String title = I18n.trn("Change {0} object", "Change {0} objects", sel.size(), sel.size());
            if (sel.size() == 0) {
                title = this.originalSelectionEmpty ? I18n.tr("Nothing selected!") : I18n.tr("Selection unsuitable!");
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PresetDialog
            extends ExtendedDialog {
                public PresetDialog(Component content, String title, boolean disableApply) {
                    String[] stringArray;
                    if (bl) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = I18n.tr("Apply Preset");
                        stringArray2[1] = I18n.tr("New relation");
                        stringArray = stringArray2;
                        stringArray2[2] = I18n.tr("Cancel");
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = I18n.tr("Apply Preset");
                        stringArray = stringArray3;
                        stringArray3[1] = I18n.tr("Cancel");
                    }
                    super(Main.parent, title, stringArray, true);
                    this.contentInsets = new Insets(10, 5, 0, 5);
                    if (showNewRelation) {
                        this.setButtonIcons(new String[]{"ok.png", "dialogs/addrelation.png", "cancel.png"});
                    } else {
                        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
                    }
                    this.setContent(content);
                    this.setDefaultButton(1);
                    this.setupDialog();
                    ((JButton)this.buttons.get(0)).setEnabled(!disableApply);
                    ((JButton)this.buttons.get(0)).setToolTipText(title);
                    this.showDialog();
                }
            }
            answer = new PresetDialog(p, title, sel.size() == 0).getValue();
        }
        if (!showNewRelation && answer == 2) {
            return 3;
        }
        return answer;
    }

    private Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> participants) {
        this.originalSelectionEmpty = participants.size() == 0;
        LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : participants) {
            if (this.types != null && (osm instanceof Relation ? !this.types.contains((Object)PresetType.RELATION) : (osm instanceof Node ? !this.types.contains((Object)PresetType.NODE) : osm instanceof Way && !this.types.contains((Object)PresetType.WAY) && (!this.types.contains((Object)PresetType.CLOSEDWAY) || !((Way)osm).isClosed())))) continue;
            sel.add(osm);
        }
        return sel;
    }

    public List<Tag> getChangedTags() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Item i : this.data) {
            i.addCommands(result);
        }
        return result;
    }

    public static Command createCommand(Collection<OsmPrimitive> sel, List<Tag> changedTags) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        for (Tag tag : changedTags) {
            if (tag.getValue().isEmpty()) continue;
            cmds.add(new ChangePropertyCommand(sel, tag.getKey(), tag.getValue()));
        }
        if (cmds.size() == 0) {
            return null;
        }
        if (cmds.size() == 1) {
            return (Command)cmds.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Properties"), cmds);
    }

    private boolean supportsRelation() {
        return this.types == null || this.types.contains((Object)PresetType.RELATION);
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.main != null && Main.main.getCurrentDataSet() != null);
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer newLayer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        this.updateEnabledState();
    }

    public String toString() {
        return (this.types == null ? "" : this.types) + " " + this.name;
    }

    private static class PresetPanel
    extends JPanel {
        boolean hasElements = false;

        PresetPanel() {
            super(new GridBagLayout());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key
    extends Item {
        public String key;
        public String value;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            changedTags.add(new Tag(this.key, this.value != null && !this.value.equals("") ? this.value : null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Space
    extends Item {
        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            p.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Optional
    extends Item {
        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            p.add((Component)new JLabel(" "), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Optional Attributes:")), GBC.eol());
            p.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Roles
    extends Item {
        public List<Role> roles = new LinkedList<Role>();

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            p.add((Component)new JLabel(" "), GBC.eol());
            if (this.roles.size() > 0) {
                JPanel proles = new JPanel(new GridBagLayout());
                proles.add((Component)new JLabel(I18n.tr("Available roles")), GBC.std().insets(0, 0, 10, 0));
                proles.add((Component)new JLabel(I18n.tr("role")), GBC.std().insets(0, 0, 10, 0));
                proles.add((Component)new JLabel(I18n.tr("count")), GBC.std().insets(0, 0, 10, 0));
                proles.add((Component)new JLabel(I18n.tr("elements")), GBC.eol());
                for (Role i : this.roles) {
                    i.addToPanel(proles, sel);
                }
                p.add((Component)proles, GBC.eol());
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Role {
        public EnumSet<PresetType> types;
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public boolean required = false;
        public long count = 0L;

        public void setType(String types) throws SAXException {
            this.types = TaggingPreset.getType(types);
        }

        public void setRequisite(String str) throws SAXException {
            if ("required".equals(str)) {
                this.required = true;
            } else if (!"optional".equals(str)) {
                throw new SAXException(I18n.tr("Unknown requisite: {0}", str));
            }
        }

        public long getValidCount(long c) {
            if (this.count > 0L && !this.required) {
                return c != 0L ? this.count : 0L;
            }
            if (this.count > 0L) {
                return this.count;
            }
            if (!this.required) {
                return c != 0L ? c : 0L;
            }
            return c != 0L ? c : 1L;
        }

        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            String cstring = this.count > 0L && !this.required ? "0," + String.valueOf(this.count) : (this.count > 0L ? String.valueOf(this.count) : (!this.required ? "0-..." : "1-..."));
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)new JLabel(this.key), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)new JLabel(cstring), this.types == null ? GBC.eol() : GBC.std().insets(0, 0, 10, 0));
            if (this.types != null) {
                JPanel pp = new JPanel();
                for (PresetType t : this.types) {
                    pp.add(new JLabel(ImageProvider.get(t.getIconName())));
                }
                p.add((Component)pp, GBC.eol());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link
    extends Item {
        public String href;
        public String text;
        public String text_context;
        public String locale_text;
        public String locale_href;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            String url;
            if (this.locale_text == null) {
                this.locale_text = this.text == null ? I18n.tr("More information about this feature") : (this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text));
            }
            if ((url = this.locale_href) == null) {
                url = this.href;
            }
            if (url != null) {
                p.add((Component)new UrlLabel(url, this.locale_text), GBC.eol().anchor(17));
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Label
    extends Item {
        public String text;
        public String text_context;
        public String locale_text;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            p.add((Component)new JLabel(this.locale_text), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Combo
    extends Item {
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public String values;
        public String values_context;
        public String display_values;
        public String locale_display_values;
        public String default_;
        public boolean delete_if_empty = false;
        public boolean editable = true;
        public boolean use_last_as_default = false;
        public boolean required = false;
        private JComboBox combo;
        private LinkedHashMap<String, String> lhm;
        private Usage usage;
        private String originalValue;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            this.usage = TaggingPreset.determineTextUsage(sel, this.key);
            String def = this.default_;
            String[] value_array = this.values.split(",");
            String[] display_array = this.locale_display_values != null ? this.locale_display_values.split(",") : (this.display_values != null ? this.display_values.split(",") : value_array);
            if (this.use_last_as_default && def == null && lastValue.containsKey(this.key)) {
                def = (String)lastValue.get(this.key);
            }
            if (display_array.length != value_array.length) {
                System.err.println(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in display_values must be the same as in values", this.key, this.text));
                display_array = value_array;
            }
            this.lhm = new LinkedHashMap();
            if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.lhm.put(DIFFERENT, DIFFERENT);
            }
            for (int i = 0; i < value_array.length; ++i) {
                this.lhm.put(value_array[i], this.locale_display_values == null ? (this.values_context == null ? I18n.tr(display_array[i]) : I18n.trc(this.values_context, display_array[i])) : display_array[i]);
            }
            if (!this.usage.unused()) {
                for (String s : this.usage.values) {
                    if (this.lhm.containsKey(s)) continue;
                    this.lhm.put(s, s);
                }
            }
            if (def != null && !this.lhm.containsKey(def)) {
                this.lhm.put(def, def);
            }
            if (!this.lhm.containsKey("")) {
                this.lhm.put("", "");
            }
            this.combo = new JComboBox<Object>(this.lhm.values().toArray());
            this.combo.setEditable(this.editable);
            this.combo.setMaximumRowCount(13);
            AutoCompletingTextField tf = new AutoCompletingTextField();
            this.initAutoCompletionField(tf, this.key);
            tf.getAutoCompletionList().add(Arrays.asList(display_array), AutoCompletionItemPritority.IS_IN_STANDARD);
            this.combo.setEditor(tf);
            if (this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.originalValue = this.usage.getFirst();
                this.combo.setSelectedItem(this.lhm.get(this.originalValue));
            } else if (def != null && !this.usage.hadKeys()) {
                this.combo.setSelectedItem(def);
                this.originalValue = DIFFERENT;
            } else if (this.usage.unused()) {
                this.combo.setSelectedItem("");
                this.originalValue = "";
            } else {
                this.combo.setSelectedItem(DIFFERENT);
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)this.combo, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            Object obj = this.combo.getSelectedItem();
            String display = obj == null ? null : obj.toString();
            String value = null;
            if (display == null && this.combo.isEditable()) {
                display = this.combo.getEditor().getItem().toString();
            }
            if (display != null) {
                for (String key : this.lhm.keySet()) {
                    String k = this.lhm.get(key);
                    if (k == null || !k.equals(display)) continue;
                    value = key;
                }
                if (value == null) {
                    value = display;
                }
            } else {
                value = "";
            }
            if (value.equals(this.originalValue) || this.originalValue == null && value.length() == 0) {
                return;
            }
            if (this.delete_if_empty && value.length() == 0) {
                value = null;
            }
            if (this.use_last_as_default) {
                lastValue.put(this.key, value);
            }
            changedTags.add(new Tag(this.key, value));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.combo.requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Check
    extends Item {
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public String value_on = "yes";
        public String value_off = "no";
        public boolean default_ = false;
        public boolean use_last_as_default = false;
        public boolean required = false;
        private QuadStateCheckBox check;
        private QuadStateCheckBox.State initialState;
        private boolean def;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            Usage usage = TaggingPreset.determineBooleanUsage(sel, this.key);
            this.def = this.default_;
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            String oneValue = null;
            Iterator<Object> i$ = usage.values.iterator();
            while (i$.hasNext()) {
                String string;
                oneValue = string = i$.next();
            }
            if (usage.values.size() < 2 && (oneValue == null || this.value_on.equals(oneValue) || this.value_off.equals(oneValue))) {
                if (this.def) {
                    for (OsmPrimitive osmPrimitive : sel) {
                        if (!osmPrimitive.hasKeys()) continue;
                        this.def = false;
                    }
                }
                this.initialState = this.value_on.equals(oneValue) ? QuadStateCheckBox.State.SELECTED : (this.value_off.equals(oneValue) ? QuadStateCheckBox.State.NOT_SELECTED : (this.def ? QuadStateCheckBox.State.SELECTED : QuadStateCheckBox.State.UNSET));
                this.check = new QuadStateCheckBox(this.locale_text, this.initialState, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            } else {
                this.def = false;
                this.initialState = QuadStateCheckBox.State.PARTIAL;
                this.check = new QuadStateCheckBox(this.locale_text, QuadStateCheckBox.State.PARTIAL, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.PARTIAL, QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            }
            p.add((Component)this.check, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            if (this.check.getState() == this.initialState && !this.def) {
                return;
            }
            changedTags.add(new Tag(this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? this.value_on : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? this.value_off : null)));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.check.requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Text
    extends Item {
        public String key;
        public String text;
        public String locale_text;
        public String text_context;
        public String default_;
        public String originalValue;
        public boolean use_last_as_default = false;
        public boolean delete_if_empty = false;
        public boolean required = false;
        private JComponent value;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            Usage usage = TaggingPreset.determineTextUsage(sel, this.key);
            AutoCompletingTextField textField = new AutoCompletingTextField();
            this.initAutoCompletionField(textField, this.key);
            if (usage.unused()) {
                if (this.use_last_as_default && lastValue.containsKey(this.key)) {
                    textField.setText((String)lastValue.get(this.key));
                } else {
                    textField.setText(this.default_);
                }
                this.value = textField;
                this.originalValue = null;
            } else if (usage.hasUniqueValue()) {
                textField.setText(usage.getFirst());
                this.value = textField;
                this.originalValue = usage.getFirst();
            } else {
                JComboBox<Object> comboBox = new JComboBox<Object>(usage.values.toArray());
                comboBox.setEditable(true);
                comboBox.setEditor(textField);
                comboBox.getEditor().setItem(DIFFERENT);
                this.value = comboBox;
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)this.value, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> changedTags) {
            String v;
            String string = v = this.value instanceof JComboBox ? ((JComboBox)this.value).getEditor().getItem().toString() : ((JTextField)this.value).getText();
            if (this.use_last_as_default) {
                lastValue.put(this.key, v);
            }
            if (v.equals(this.originalValue) || this.originalValue == null && v.length() == 0) {
                return;
            }
            if (this.delete_if_empty && v.length() == 0) {
                v = null;
            }
            changedTags.add(new Tag(this.key, v));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.value.requestFocusInWindow();
        }
    }

    public static class Usage {
        TreeSet<String> values;
        boolean hadKeys = false;
        boolean hadEmpty = false;

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.size() == 0;
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Item {
        protected void initAutoCompletionField(AutoCompletingTextField field, String key) {
            OsmDataLayer layer = Main.main.getEditLayer();
            if (layer == null) {
                return;
            }
            AutoCompletionList list = new AutoCompletionList();
            Main.main.getEditLayer().data.getAutoCompletionManager().populateWithTagValues(list, key);
            field.setAutoCompletionList(list);
        }

        abstract boolean addToPanel(JPanel var1, Collection<OsmPrimitive> var2);

        abstract void addCommands(List<Tag> var1);

        boolean requestFocusInWindow() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PresetType {
        NODE("Mf_node"),
        WAY("Mf_way"),
        RELATION("Mf_relation"),
        CLOSEDWAY("Mf_closedway");

        private final String iconName;

        private PresetType(String iconName) {
            this.iconName = iconName;
        }

        public String getIconName() {
            return this.iconName;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

