/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ProxyPreferencesPanel
extends VerticallyScrollablePanel {
    public static final String PROXY_POLICY = "proxy.policy";
    public static final String PROXY_HTTP_HOST = "proxy.http.host";
    public static final String PROXY_HTTP_PORT = "proxy.http.port";
    public static final String PROXY_SOCKS_HOST = "proxy.socks.host";
    public static final String PROXY_SOCKS_PORT = "proxy.socks.port";
    public static final String PROXY_USER = "proxy.user";
    public static final String PROXY_PASS = "proxy.pass";
    private ButtonGroup bgProxyPolicy;
    private Map<ProxyPolicy, JRadioButton> rbProxyPolicy;
    private JTextField tfProxyHttpHost;
    private JTextField tfProxyHttpPort;
    private JTextField tfProxySocksHost;
    private JTextField tfProxySocksPort;
    private JTextField tfProxyHttpUser;
    private JPasswordField tfProxyHttpPassword;
    private JPanel pnlHttpProxyConfigurationPanel;
    private JPanel pnlSocksProxyConfigurationPanel;

    protected JPanel buildHttpProxyConfigurationPanel() {
        JPanel pnl = new JPanel(new GridBagLayout()){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.insets = new Insets(5, 5, 0, 0);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Host:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpHost = new JTextField();
        pnl.add((Component)this.tfProxyHttpHost, gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.fill = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.trc("server", "Port:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpPort = new JTextField(5);
        pnl.add((Component)this.tfProxyHttpPort, gc);
        this.tfProxyHttpPort.setMinimumSize(this.tfProxyHttpPort.getPreferredSize());
        gc.gridy = 2;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Please enter a username and a password if your proxy requires authentication.")), gc);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("User:")), gc);
        gc.gridy = 3;
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpUser = new JTextField(20);
        pnl.add((Component)this.tfProxyHttpUser, gc);
        this.tfProxyHttpUser.setMinimumSize(this.tfProxyHttpUser.getPreferredSize());
        gc.gridy = 4;
        gc.gridx = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Password:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxyHttpPassword = new JPasswordField(20);
        pnl.add((Component)this.tfProxyHttpPassword, gc);
        this.tfProxyHttpPassword.setMinimumSize(this.tfProxyHttpPassword.getPreferredSize());
        gc.gridy = 5;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildSocksProxyConfigurationPanel() {
        JPanel pnl = new JPanel(new GridBagLayout()){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.insets = new Insets(5, 5, 0, 0);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Host:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxySocksHost = new JTextField(20);
        pnl.add((Component)this.tfProxySocksHost, gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        pnl.add((Component)new JLabel(I18n.trc("server", "Port:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfProxySocksPort = new JTextField(5);
        pnl.add((Component)this.tfProxySocksPort, gc);
        this.tfProxySocksPort.setMinimumSize(this.tfProxySocksPort.getPreferredSize());
        gc.gridy = 2;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildProxySettingsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.bgProxyPolicy = new ButtonGroup();
        this.rbProxyPolicy = new HashMap<ProxyPolicy, JRadioButton>();
        ProxyPolicyChangeListener policyChangeListener = new ProxyPolicyChangeListener();
        for (ProxyPolicy pp : ProxyPolicy.values()) {
            this.rbProxyPolicy.put(pp, new JRadioButton());
            this.bgProxyPolicy.add(this.rbProxyPolicy.get((Object)pp));
            this.rbProxyPolicy.get((Object)pp).addItemListener(policyChangeListener);
        }
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.NO_PROXY), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JLabel(I18n.tr("No proxy")), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SYSTEM_SETTINGS), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        String msg = DefaultProxySelector.willJvmRetrieveSystemProxies() ? I18n.tr("Use standard system settings") : I18n.tr("Use standard system settings (disabled. Start JOSM with <tt>-Djava.net.useSystemProxies=true</tt> to enable)");
        pnl.add((Component)new JMultilineLabel("<html>" + msg + "</html>"), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_HTTP_PROXY), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JLabel(I18n.tr("Manually configure a HTTP proxy")), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.pnlHttpProxyConfigurationPanel = this.buildHttpProxyConfigurationPanel();
        pnl.add((Component)this.pnlHttpProxyConfigurationPanel, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.weightx = 0.0;
        pnl.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SOCKS_PROXY), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JLabel(I18n.tr("Use a SOCKS proxy")), gc);
        gc.gridx = 1;
        gc.gridy = 5;
        gc.fill = 1;
        gc.anchor = 17;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.pnlSocksProxyConfigurationPanel = this.buildSocksProxyConfigurationPanel();
        pnl.add((Component)this.pnlSocksProxyConfigurationPanel, gc);
        return pnl;
    }

    public void initFromPreferences() {
        String policy = Main.pref.get(PROXY_POLICY, null);
        ProxyPolicy pp = ProxyPolicy.fromName(policy);
        pp = pp == null ? ProxyPolicy.NO_PROXY : pp;
        this.rbProxyPolicy.get((Object)pp).setSelected(true);
        String value = Main.pref.get("proxy.host", null);
        if (value != null) {
            this.tfProxyHttpHost.setText(value);
            Main.pref.put("proxy.host", null);
        } else {
            this.tfProxyHttpHost.setText(Main.pref.get(PROXY_HTTP_HOST, ""));
        }
        value = Main.pref.get("proxy.port", null);
        if (value != null) {
            this.tfProxyHttpPort.setText(value);
            Main.pref.put("proxy.port", null);
        } else {
            this.tfProxyHttpPort.setText(Main.pref.get(PROXY_HTTP_PORT, ""));
        }
        this.tfProxySocksHost.setText(Main.pref.get(PROXY_SOCKS_HOST, ""));
        this.tfProxySocksPort.setText(Main.pref.get(PROXY_SOCKS_PORT, ""));
        if (pp.equals((Object)ProxyPolicy.USE_SYSTEM_SETTINGS) && !DefaultProxySelector.willJvmRetrieveSystemProxies()) {
            System.err.println(I18n.tr("Warning: JOSM is configured to use proxies from the system setting, but the JVM is not configured to retrieve them. Resetting preferences to ''No proxy''"));
            pp = ProxyPolicy.NO_PROXY;
            this.rbProxyPolicy.get((Object)pp).setSelected(true);
        }
        CredentialsManager cm = CredentialsManagerFactory.getCredentialManager();
        try {
            PasswordAuthentication pa = cm.lookup(Authenticator.RequestorType.PROXY);
            if (pa == null) {
                this.tfProxyHttpUser.setText("");
                this.tfProxyHttpPassword.setText("");
            } else {
                this.tfProxyHttpUser.setText(pa.getUserName() == null ? "" : pa.getUserName());
                this.tfProxyHttpPassword.setText(pa.getPassword() == null ? "" : String.valueOf(pa.getPassword()));
            }
        }
        catch (CredentialsManagerException e) {
            e.printStackTrace();
            this.tfProxyHttpUser.setText("");
            this.tfProxyHttpPassword.setText("");
        }
    }

    protected void updateEnabledState() {
        boolean isHttpProxy = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_HTTP_PROXY).isSelected();
        for (Component c : this.pnlHttpProxyConfigurationPanel.getComponents()) {
            c.setEnabled(isHttpProxy);
        }
        boolean isSocksProxy = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SOCKS_PROXY).isSelected();
        for (Component c : this.pnlSocksProxyConfigurationPanel.getComponents()) {
            c.setEnabled(isSocksProxy);
        }
        this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SYSTEM_SETTINGS).setEnabled(DefaultProxySelector.willJvmRetrieveSystemProxies());
    }

    public ProxyPreferencesPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildProxySettingsPanel(), GBC.eop().anchor(18).fill(1));
        this.initFromPreferences();
        this.updateEnabledState();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ProxySettings"));
    }

    public void saveToPreferences() {
        ProxyPolicy policy = null;
        for (ProxyPolicy pp : ProxyPolicy.values()) {
            if (!this.rbProxyPolicy.get((Object)pp).isSelected()) continue;
            policy = pp;
            break;
        }
        if (policy == null) {
            policy = ProxyPolicy.NO_PROXY;
        }
        Main.pref.put(PROXY_POLICY, policy.getName());
        Main.pref.put(PROXY_HTTP_HOST, this.tfProxyHttpHost.getText());
        Main.pref.put(PROXY_HTTP_PORT, this.tfProxyHttpPort.getText());
        Main.pref.put(PROXY_SOCKS_HOST, this.tfProxySocksHost.getText());
        Main.pref.put(PROXY_SOCKS_PORT, this.tfProxySocksPort.getText());
        ProxySelector selector = ProxySelector.getDefault();
        if (selector instanceof DefaultProxySelector) {
            ((DefaultProxySelector)selector).initFromPreferences();
        }
        CredentialsManager cm = CredentialsManagerFactory.getCredentialManager();
        try {
            PasswordAuthentication pa = new PasswordAuthentication(this.tfProxyHttpUser.getText().trim(), this.tfProxyHttpPassword.getPassword());
            cm.store(Authenticator.RequestorType.PROXY, pa);
        }
        catch (CredentialsManagerException e) {
            e.printStackTrace();
        }
    }

    class ProxyPolicyChangeListener
    implements ItemListener {
        ProxyPolicyChangeListener() {
        }

        public void itemStateChanged(ItemEvent arg0) {
            ProxyPreferencesPanel.this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProxyPolicy {
        NO_PROXY("no-proxy"),
        USE_SYSTEM_SETTINGS("use-system-settings"),
        USE_HTTP_PROXY("use-http-proxy"),
        USE_SOCKS_PROXY("use-socks-proxy");

        private String policyName;

        private ProxyPolicy(String policyName) {
            this.policyName = policyName;
        }

        public String getName() {
            return this.policyName;
        }

        public static ProxyPolicy fromName(String policyName) {
            if (policyName == null) {
                return null;
            }
            policyName = policyName.trim().toLowerCase();
            for (ProxyPolicy pp : ProxyPolicy.values()) {
                if (!pp.getName().equals(policyName)) continue;
                return pp;
            }
            return null;
        }
    }
}

