/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.ParameterizedActionDecorator;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarPreferences
implements PreferenceSettingFactory {
    private static final String EMPTY_TOOLBAR_MARKER = "<!-empty-!>";
    private Map<String, Action> actions = new HashMap<String, Action>();
    private Map<String, Action> regactions = new HashMap<String, Action>();
    private DefaultMutableTreeNode rootActionsNode = new DefaultMutableTreeNode(I18n.tr("Actions"));
    public JToolBar control = new JToolBar();
    private static final String[] deftoolbar = new String[]{"open", "save", "download", "upload", "|", "undo", "redo", "|", "dialogs/search", "preference", "|", "splitway", "combineway", "wayflip", "|", "tagginggroup_Highways/Streets", "tagginggroup_Highways/Ways", "tagginggroup_Highways/Waypoints", "tagginggroup_Highways/Barriers", "|", "tagginggroup_Transport/Car", "tagginggroup_Transport/Public Transport", "|", "tagginggroup_Travel/Tourism", "tagginggroup_Travel/Food+Drinks", "|", "tagginggroup_Travel/Historic Places", "|", "tagginggroup_Man-Made/Man Made"};
    private static DataFlavor ACTION_FLAVOR = new DataFlavor(ActionDefinition.class, "ActionItem");

    @Override
    public PreferenceSetting createPreferenceSetting() {
        return new Settings(this.rootActionsNode);
    }

    public ToolbarPreferences() {
        this.control.setFloatable(false);
    }

    private void loadAction(DefaultMutableTreeNode node, MenuElement menu) {
        Object userObject = null;
        MenuElement menuElement = menu;
        if (menu.getSubElements().length > 0 && menu.getSubElements()[0] instanceof JPopupMenu) {
            menuElement = menu.getSubElements()[0];
        }
        for (MenuElement item : menuElement.getSubElements()) {
            if (item instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)item;
                if (menuItem.getAction() != null) {
                    Action action = menuItem.getAction();
                    userObject = action;
                    this.actions.put((String)action.getValue("toolbar"), action);
                } else {
                    userObject = menuItem.getText();
                }
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(userObject);
            node.add(newNode);
            this.loadAction(newNode, item);
        }
    }

    public Action getAction(String s) {
        Action e = this.actions.get(s);
        if (e == null) {
            e = this.regactions.get(s);
        }
        return e;
    }

    private void loadActions() {
        this.rootActionsNode.removeAllChildren();
        this.loadAction(this.rootActionsNode, Main.main.menu);
        for (Map.Entry<String, Action> a : this.regactions.entrySet()) {
            if (this.actions.get(a.getKey()) != null) continue;
            this.rootActionsNode.add(new DefaultMutableTreeNode(a.getValue()));
        }
        this.rootActionsNode.add(new DefaultMutableTreeNode(null));
    }

    private static Collection<String> getToolString() {
        Collection<String> toolStr = Main.pref.getCollection("toolbar", Arrays.asList(deftoolbar));
        if (toolStr == null || toolStr.size() == 0) {
            toolStr = Arrays.asList(deftoolbar);
        }
        return toolStr;
    }

    private Collection<ActionDefinition> getDefinedActions() {
        this.loadActions();
        HashMap<String, Action> allActions = new HashMap<String, Action>(this.regactions);
        allActions.putAll(this.actions);
        ActionParser actionParser = new ActionParser(allActions);
        ArrayList<ActionDefinition> result = new ArrayList<ActionDefinition>();
        for (String s : ToolbarPreferences.getToolString()) {
            if (s.equals("|")) {
                result.add(ActionDefinition.getSeparator());
                continue;
            }
            ActionDefinition a = actionParser.loadAction(s);
            if (a == null) continue;
            result.add(a);
        }
        return result;
    }

    public Action register(Action action) {
        this.regactions.put((String)action.getValue("toolbar"), action);
        return action;
    }

    public void refreshToolbarControl() {
        this.control.removeAll();
        for (ActionDefinition action : this.getDefinedActions()) {
            if (action.isSeparator()) {
                this.control.addSeparator();
                continue;
            }
            Action a = action.getParametrizedAction();
            JButton b = this.control.add(a);
            Object tt = a.getValue("Optional tooltip text");
            if (tt == null) continue;
            b.setToolTipText((String)tt);
        }
        this.control.setVisible(this.control.getComponentCount() != 0);
    }

    public class Settings
    implements PreferenceSetting {
        private final Move moveAction = new Move();
        private final DefaultListModel selected = new DefaultListModel();
        private final JList selectedList = new JList(this.selected);
        private final DefaultTreeModel actionsTreeModel;
        private final JTree actionsTree;
        private final ActionParametersTableModel actionParametersModel = new ActionParametersTableModel();
        private final JTable actionParametersTable = new JTable(this.actionParametersModel);
        private JPanel actionParametersPanel;
        private JButton upButton;
        private JButton downButton;
        private JButton removeButton;
        private JButton addButton;
        private String movingComponent;

        public Settings(DefaultMutableTreeNode rootActionsNode) {
            this.actionsTreeModel = new DefaultTreeModel(rootActionsNode);
            this.actionsTree = new JTree(this.actionsTreeModel);
        }

        private JButton createButton(String name) {
            JButton b = new JButton();
            if (name.equals("up")) {
                b.setIcon(ImageProvider.get("dialogs", "up"));
            } else if (name.equals("down")) {
                b.setIcon(ImageProvider.get("dialogs", "down"));
            } else {
                b.setText(name);
            }
            b.addActionListener(this.moveAction);
            b.setActionCommand(name);
            return b;
        }

        private void updateEnabledState() {
            int index = this.selectedList.getSelectedIndex();
            this.upButton.setEnabled(index > 0);
            this.downButton.setEnabled(index < this.selectedList.getModel().getSize() - 1);
            this.removeButton.setEnabled(index != -1);
            this.addButton.setEnabled(this.actionsTree.getSelectionCount() > 0);
        }

        public void addGui(PreferenceTabbedPane gui) {
            this.actionsTree.setCellRenderer(new DefaultTreeCellRenderer(){

                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    JLabel comp = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (node.getUserObject() == null) {
                        comp.setText(I18n.tr("Separator"));
                        comp.setIcon(ImageProvider.get("preferences/separator"));
                    } else if (node.getUserObject() instanceof Action) {
                        Action action = (Action)node.getUserObject();
                        comp.setText((String)action.getValue("Name"));
                        comp.setIcon((Icon)action.getValue("SmallIcon"));
                    }
                    return comp;
                }
            });
            DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Icon i;
                    String s;
                    ActionDefinition action = (ActionDefinition)value;
                    if (!action.isSeparator()) {
                        s = (String)action.getAction().getValue("Name");
                        i = (Icon)action.getAction().getValue("SmallIcon");
                    } else {
                        i = ImageProvider.get("preferences/separator");
                        s = I18n.tr("Separator");
                    }
                    JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, s, index, isSelected, cellHasFocus);
                    l.setIcon(i);
                    return l;
                }
            };
            this.selectedList.setCellRenderer(renderer);
            this.selectedList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    boolean sel;
                    boolean bl = sel = Settings.this.selectedList.getSelectedIndex() != -1;
                    if (sel) {
                        Settings.this.actionsTree.clearSelection();
                        ActionDefinition action = (ActionDefinition)Settings.this.selected.get(Settings.this.selectedList.getSelectedIndex());
                        Settings.this.actionParametersModel.setCurrentAction(action);
                        Settings.this.actionParametersPanel.setVisible(Settings.this.actionParametersModel.getRowCount() > 0);
                    }
                    Settings.this.updateEnabledState();
                }
            });
            this.selectedList.setDragEnabled(true);
            this.selectedList.setTransferHandler(new TransferHandler(){

                protected Transferable createTransferable(JComponent c) {
                    ArrayList<ActionDefinition> actions = new ArrayList<ActionDefinition>();
                    for (Object o : ((JList)c).getSelectedValues()) {
                        actions.add((ActionDefinition)o);
                    }
                    return new ActionTransferable(actions);
                }

                public int getSourceActions(JComponent c) {
                    return 2;
                }

                public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                    for (DataFlavor f : transferFlavors) {
                        if (!ACTION_FLAVOR.equals(f)) continue;
                        return true;
                    }
                    return false;
                }

                public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                    super.exportAsDrag(comp, e, action);
                    Settings.this.movingComponent = "list";
                }

                public boolean importData(JComponent comp, Transferable t) {
                    try {
                        int dropIndex = Settings.this.selectedList.locationToIndex(Settings.this.selectedList.getMousePosition(true));
                        List draggedData = (List)t.getTransferData(ACTION_FLAVOR);
                        Object leadItem = dropIndex >= 0 ? (Object)Settings.this.selected.elementAt(dropIndex) : null;
                        int dataLength = draggedData.size();
                        if (leadItem != null) {
                            for (Object o : draggedData) {
                                if (!leadItem.equals(o)) continue;
                                return false;
                            }
                        }
                        int dragLeadIndex = -1;
                        boolean localDrop = "list".equals(Settings.this.movingComponent);
                        if (localDrop) {
                            dragLeadIndex = Settings.this.selected.indexOf(draggedData.get(0));
                            for (Object o : draggedData) {
                                Settings.this.selected.removeElement(o);
                            }
                        }
                        int[] indices = new int[dataLength];
                        if (localDrop) {
                            int adjustedLeadIndex = Settings.this.selected.indexOf(leadItem);
                            int insertionAdjustment = dragLeadIndex <= adjustedLeadIndex ? 1 : 0;
                            for (int i = 0; i < dataLength; ++i) {
                                Settings.this.selected.insertElementAt(draggedData.get(i), adjustedLeadIndex + insertionAdjustment + i);
                                indices[i] = adjustedLeadIndex + insertionAdjustment + i;
                            }
                        } else {
                            for (int i = 0; i < dataLength; ++i) {
                                Settings.this.selected.add(dropIndex, draggedData.get(i));
                                indices[i] = dropIndex + i;
                            }
                        }
                        Settings.this.selectedList.clearSelection();
                        Settings.this.selectedList.setSelectedIndices(indices);
                        Settings.this.movingComponent = "";
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }

                protected void exportDone(JComponent source, Transferable data, int action) {
                    if (Settings.this.movingComponent.equals("list")) {
                        try {
                            List draggedData = (List)data.getTransferData(ACTION_FLAVOR);
                            boolean localDrop = Settings.this.selected.contains(draggedData.get(0));
                            if (localDrop) {
                                int[] indices = Settings.this.selectedList.getSelectedIndices();
                                Arrays.sort(indices);
                                for (int i = indices.length - 1; i >= 0; --i) {
                                    Settings.this.selected.remove(indices[i]);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Settings.this.movingComponent = "";
                    }
                }
            });
            this.actionsTree.setTransferHandler(new TransferHandler(){
                private static final long serialVersionUID = 1L;

                public int getSourceActions(JComponent c) {
                    return 2;
                }

                protected void exportDone(JComponent source, Transferable data, int action) {
                }

                protected Transferable createTransferable(JComponent c) {
                    TreePath[] paths = Settings.this.actionsTree.getSelectionPaths();
                    ArrayList<ActionDefinition> dragActions = new ArrayList<ActionDefinition>();
                    for (TreePath path : paths) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object obj = node.getUserObject();
                        if (obj == null) {
                            dragActions.add(ActionDefinition.getSeparator());
                            continue;
                        }
                        if (!(obj instanceof Action)) continue;
                        dragActions.add(new ActionDefinition((Action)obj));
                    }
                    return new ActionTransferable(dragActions);
                }
            });
            this.actionsTree.setDragEnabled(true);
            this.actionsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    Settings.this.updateEnabledState();
                }
            });
            final JPanel left = new JPanel(new GridBagLayout());
            left.add((Component)new JLabel(I18n.tr("Toolbar")), GBC.eol());
            left.add((Component)new JScrollPane(this.selectedList), GBC.std().fill(1));
            final JPanel right = new JPanel(new GridBagLayout());
            right.add((Component)new JLabel(I18n.tr("Available")), GBC.eol());
            right.add((Component)new JScrollPane(this.actionsTree), GBC.eol().fill(1));
            final JPanel buttons = new JPanel(new GridLayout(6, 1));
            this.upButton = this.createButton("up");
            buttons.add(this.upButton);
            this.addButton = this.createButton("<");
            buttons.add(this.addButton);
            this.removeButton = this.createButton(">");
            buttons.add(this.removeButton);
            this.downButton = this.createButton("down");
            buttons.add(this.downButton);
            this.updateEnabledState();
            final JPanel p = new JPanel();
            p.setLayout(new LayoutManager(){

                public void addLayoutComponent(String name, Component comp) {
                }

                public void removeLayoutComponent(Component comp) {
                }

                public Dimension minimumLayoutSize(Container parent) {
                    Dimension l = left.getMinimumSize();
                    Dimension r = right.getMinimumSize();
                    Dimension b = buttons.getMinimumSize();
                    return new Dimension(l.width + b.width + 10 + r.width, l.height + b.height + 10 + r.height);
                }

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension l = new Dimension(200, 200);
                    Dimension r = new Dimension(200, 200);
                    return new Dimension(l.width + r.width + 10 + buttons.getPreferredSize().width, Math.max(l.height, r.height));
                }

                public void layoutContainer(Container parent) {
                    Dimension d = p.getSize();
                    Dimension b = buttons.getPreferredSize();
                    int width = (d.width - 10 - b.width) / 2;
                    left.setBounds(new Rectangle(0, 0, width, d.height));
                    right.setBounds(new Rectangle(width + 10 + b.width, 0, width, d.height));
                    buttons.setBounds(new Rectangle(width + 5, d.height / 2 - b.height / 2, b.width, b.height));
                }
            });
            p.add(left);
            p.add(buttons);
            p.add(right);
            this.actionParametersPanel = new JPanel(new GridBagLayout());
            this.actionParametersPanel.add((Component)new JLabel(I18n.tr("Action parameters")), GBC.eol().insets(0, 10, 0, 20));
            this.actionParametersTable.getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Parameter name"));
            this.actionParametersTable.getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Parameter value"));
            this.actionParametersPanel.add((Component)this.actionParametersTable.getTableHeader(), GBC.eol().fill(2));
            this.actionParametersPanel.add((Component)this.actionParametersTable, GBC.eol().fill(1).insets(0, 0, 0, 10));
            this.actionParametersPanel.setVisible(false);
            JPanel panel = gui.createPreferenceTab("toolbar", I18n.tr("Toolbar customization"), I18n.tr("Customize the elements on the toolbar."), false);
            panel.add((Component)p, GBC.eol().fill(1));
            panel.add((Component)this.actionParametersPanel, GBC.eol().fill(2));
            this.selected.removeAllElements();
            for (ActionDefinition actionDefinition : ToolbarPreferences.this.getDefinedActions()) {
                this.selected.addElement(actionDefinition);
            }
        }

        public boolean ok() {
            LinkedList<String> t = new LinkedList();
            ActionParser parser = new ActionParser(null);
            for (int i = 0; i < this.selected.size(); ++i) {
                ActionDefinition action = (ActionDefinition)this.selected.get(i);
                if (action.isSeparator()) {
                    t.add("|");
                    continue;
                }
                t.add(parser.saveAction(action));
            }
            if (t.isEmpty()) {
                t = Collections.singletonList(ToolbarPreferences.EMPTY_TOOLBAR_MARKER);
            }
            Main.pref.putCollection("toolbar", t);
            Main.toolbar.refreshToolbarControl();
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ActionTransferable
        implements Transferable {
            private DataFlavor[] flavors = new DataFlavor[]{ToolbarPreferences.access$300()};
            private final List<ActionDefinition> actions;

            public ActionTransferable(List<ActionDefinition> actions) {
                this.actions = actions;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.actions;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return this.flavors[0] == flavor;
            }
        }

        private final class Move
        implements ActionListener {
            private Move() {
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("<") && Settings.this.actionsTree.getSelectionCount() > 0) {
                    int leadItem = Settings.this.selected.getSize();
                    if (Settings.this.selectedList.getSelectedIndex() != -1) {
                        int[] indices = Settings.this.selectedList.getSelectedIndices();
                        leadItem = indices[indices.length - 1];
                    }
                    for (TreePath selectedAction : Settings.this.actionsTree.getSelectionPaths()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedAction.getLastPathComponent();
                        if (node.getUserObject() == null) {
                            Settings.this.selected.add(leadItem++, ActionDefinition.getSeparator());
                            continue;
                        }
                        if (!(node.getUserObject() instanceof Action)) continue;
                        Settings.this.selected.add(leadItem++, new ActionDefinition((Action)node.getUserObject()));
                    }
                } else if (e.getActionCommand().equals(">") && Settings.this.selectedList.getSelectedIndex() != -1) {
                    while (Settings.this.selectedList.getSelectedIndex() != -1) {
                        Settings.this.selected.remove(Settings.this.selectedList.getSelectedIndex());
                    }
                } else if (e.getActionCommand().equals("up")) {
                    int i = Settings.this.selectedList.getSelectedIndex();
                    Object o = Settings.this.selected.get(i);
                    if (i != 0) {
                        Settings.this.selected.remove(i);
                        Settings.this.selected.add(i - 1, o);
                        Settings.this.selectedList.setSelectedIndex(i - 1);
                    }
                } else if (e.getActionCommand().equals("down")) {
                    int i = Settings.this.selectedList.getSelectedIndex();
                    Object o = Settings.this.selected.get(i);
                    if (i != Settings.this.selected.size() - 1) {
                        Settings.this.selected.remove(i);
                        Settings.this.selected.add(i + 1, o);
                        Settings.this.selectedList.setSelectedIndex(i + 1);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionParametersTableModel
    extends AbstractTableModel {
        private ActionDefinition currentAction = ActionDefinition.getSeparator();

        private ActionParametersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.currentAction.isSeparator() || !(this.currentAction.getAction() instanceof ParameterizedAction)) {
                return 0;
            }
            ParameterizedAction pa = (ParameterizedAction)this.currentAction.getAction();
            return pa.getActionParameters().size();
        }

        private ActionParameter<Object> getParam(int index) {
            ParameterizedAction pa = (ParameterizedAction)this.currentAction.getAction();
            return pa.getActionParameters().get(index);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ActionParameter<Object> param = this.getParam(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return param.getName();
                }
                case 1: {
                    return param.writeToString(this.currentAction.getParameters().get(param.getName()));
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ActionParameter<Object> param = this.getParam(rowIndex);
            this.currentAction.getParameters().put(param.getName(), param.readFromString((String)aValue));
        }

        public void setCurrentAction(ActionDefinition currentAction) {
            this.currentAction = currentAction;
            this.fireTableDataChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionParser {
        private final Map<String, Action> actions;
        private final StringBuilder result = new StringBuilder();
        private int index;
        private char[] s;

        public ActionParser(Map<String, Action> actions) {
            this.actions = actions;
        }

        private String readTillChar(char ch1, char ch2) {
            this.result.setLength(0);
            while (this.index < this.s.length && this.s[this.index] != ch1 && this.s[this.index] != ch2) {
                if (this.s[this.index] == '\\') {
                    ++this.index;
                    if (this.index >= this.s.length) break;
                }
                this.result.append(this.s[this.index]);
                ++this.index;
            }
            return this.result.toString();
        }

        private void skip(char ch) {
            if (this.index < this.s.length && this.s[this.index] == ch) {
                ++this.index;
            }
        }

        public ActionDefinition loadAction(String actionName) {
            this.index = 0;
            this.s = actionName.toCharArray();
            String name = this.readTillChar('(', '(');
            Action action = this.actions.get(name);
            if (action == null) {
                return null;
            }
            ActionDefinition result = new ActionDefinition(action);
            if (action instanceof ParameterizedAction) {
                this.skip('(');
                ParameterizedAction parametrizedAction = (ParameterizedAction)action;
                HashMap actionParams = new HashMap();
                for (ActionParameter<?> param : parametrizedAction.getActionParameters()) {
                    actionParams.put(param.getName(), param);
                }
                do {
                    ActionParameter actionParam;
                    String paramName = this.readTillChar('=', '=');
                    this.skip('=');
                    String paramValue = this.readTillChar(',', ')');
                    if (paramName.length() > 0 && (actionParam = (ActionParameter)actionParams.get(paramName)) != null) {
                        result.getParameters().put(paramName, actionParam.readFromString(paramValue));
                    }
                    this.skip(',');
                } while (this.index < this.s.length && this.s[this.index] != ')');
            }
            return result;
        }

        private void escape(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '\\' || ch == '(' || ch == ',' || ch == ')' || ch == '=') {
                    this.result.append('\\');
                    this.result.append(ch);
                    continue;
                }
                this.result.append(ch);
            }
        }

        public String saveAction(ActionDefinition action) {
            this.result.setLength(0);
            this.escape((String)action.getAction().getValue("toolbar"));
            if (action.getAction() instanceof ParameterizedAction) {
                this.result.append('(');
                List<ActionParameter<?>> params = ((ParameterizedAction)action.getAction()).getActionParameters();
                for (int i = 0; i < params.size(); ++i) {
                    ActionParameter<?> param = params.get(i);
                    this.escape(param.getName());
                    this.result.append('=');
                    Object value = action.getParameters().get(param.getName());
                    if (value != null) {
                        this.escape(param.writeToString(value));
                    }
                    if (i < params.size() - 1) {
                        this.result.append(',');
                        continue;
                    }
                    this.result.append(')');
                }
            }
            return this.result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionDefinition {
        private final Action action;
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        public ActionDefinition(Action action) {
            this.action = action;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public Action getParametrizedAction() {
            if (this.getAction() instanceof ParameterizedAction) {
                return new ParameterizedActionDecorator((ParameterizedAction)this.getAction(), this.parameters);
            }
            return this.getAction();
        }

        public Action getAction() {
            return this.action;
        }

        public boolean isSeparator() {
            return this.action == null;
        }

        public static ActionDefinition getSeparator() {
            return new ActionDefinition(null);
        }
    }
}

