/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.Rule;

public abstract class ElemStyle {
    public long minScale;
    public long maxScale;
    public int priority;
    public String code;
    Collection<Rule> rules = null;

    public boolean equals(Object o) {
        return o instanceof ElemStyle && ((ElemStyle)o).getCode().equals(this.getCode());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String getCode() {
        if (this.code == null) {
            this.code = "";
            if (this.rules != null) {
                for (Rule r : this.rules) {
                    this.code = this.code + r.toCode();
                }
            }
        }
        return this.code;
    }

    public boolean check(OsmPrimitive primitive) {
        if (this.rules == null) {
            return true;
        }
        for (Rule r : this.rules) {
            String k = primitive.get(r.key);
            String bv = OsmUtils.getNamedOsmBoolean(r.boolValue);
            if (k != null && (r.value == null || k.equals(r.value)) && (bv == null || bv.equals(OsmUtils.getNamedOsmBoolean(k)))) continue;
            return false;
        }
        return true;
    }

    public abstract void paintPrimitive(OsmPrimitive var1, MapPaintSettings var2, MapPainter var3, boolean var4, boolean var5);
}

