/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractUploadTask;
import org.openstreetmap.josm.gui.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class UploadPrimitivesTask
extends AbstractUploadTask {
    private static final Logger logger = Logger.getLogger(UploadPrimitivesTask.class.getName());
    private boolean uploadCancelled = false;
    private Exception lastException = null;
    private APIDataSet toUpload;
    private OsmServerWriter writer;
    private OsmDataLayer layer;
    private Changeset changeset;
    private HashSet<OsmPrimitive> processedPrimitives;
    private UploadStrategySpecification strategy;

    public UploadPrimitivesTask(UploadStrategySpecification strategy, OsmDataLayer layer, APIDataSet toUpload, Changeset changeset) {
        super(I18n.tr("Uploading data for layer ''{0}''", layer.getName()), false);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        CheckParameterUtil.ensureParameterNotNull(strategy, "strategy");
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        this.toUpload = toUpload;
        this.layer = layer;
        this.changeset = changeset;
        this.strategy = strategy;
        this.processedPrimitives = new HashSet();
    }

    protected MaxChangesetSizeExceededPolicy askMaxChangesetSizeExceedsPolicy() {
        HelpAwareOptionPane.ButtonSpec[] specs = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue uploading"), ImageProvider.get("upload"), I18n.tr("Click to continue uploading to additional new changesets"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Go back to Upload Dialog"), ImageProvider.get("dialogs", "uploadproperties"), I18n.tr("Click to return to the Upload Dialog"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Abort"), ImageProvider.get("cancel"), I18n.tr("Click to abort uploading"), null)};
        int numObjectsToUploadLeft = this.toUpload.getSize() - this.processedPrimitives.size();
        String msg1 = I18n.tr("The server reported that the current changeset was closed.<br>This is most likely because the changesets size exceeded the max. size<br>of {0} objects on the server ''{1}''.", OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize(), OsmApi.getOsmApi().getBaseUrl());
        String msg2 = I18n.trn("There is {0} object left to upload.", "There are {0} objects left to upload.", numObjectsToUploadLeft, numObjectsToUploadLeft);
        String msg3 = I18n.tr("Click ''<strong>{0}</strong>'' to continue uploading to additional new changesets.<br>Click ''<strong>{1}</strong>'' to return to the upload dialog.<br>Click ''<strong>{2}</strong>'' to abort uploading and return to map editing.<br>", specs[0].text, specs[1].text, specs[2].text);
        String msg = "<html>" + msg1 + "<br><br>" + msg2 + "<br><br>" + msg3 + "</html>";
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Changeset is full"), 2, null, specs, specs[0], HelpUtil.ht("/Action/UploadAction#ChangesetFull"));
        switch (ret) {
            case 0: {
                return MaxChangesetSizeExceededPolicy.AUTOMATICALLY_OPEN_NEW_CHANGESETS;
            }
            case 1: {
                return MaxChangesetSizeExceededPolicy.FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG;
            }
            case 2: {
                return MaxChangesetSizeExceededPolicy.ABORT;
            }
            case -1: {
                return MaxChangesetSizeExceededPolicy.ABORT;
            }
        }
        return null;
    }

    protected void openNewChangeset() {
        ChangesetCache.getInstance().update(this.changeset);
        Changeset newChangeSet = new Changeset();
        newChangeSet.setKeys(this.changeset.getKeys());
        this.changeset = newChangeSet;
    }

    protected boolean recoverFromChangesetFullException() {
        if (this.toUpload.getSize() - this.processedPrimitives.size() == 0) {
            this.strategy.setPolicy(MaxChangesetSizeExceededPolicy.ABORT);
            return false;
        }
        if (this.strategy.getPolicy() == null || this.strategy.getPolicy().equals((Object)MaxChangesetSizeExceededPolicy.ABORT)) {
            MaxChangesetSizeExceededPolicy policy = this.askMaxChangesetSizeExceedsPolicy();
            this.strategy.setPolicy(policy);
        }
        switch (this.strategy.getPolicy()) {
            case ABORT: {
                return false;
            }
            case FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG: {
                return false;
            }
            case AUTOMATICALLY_OPEN_NEW_CHANGESETS: {
                this.openNewChangeset();
                this.toUpload.removeProcessed(this.processedPrimitives);
                return true;
            }
        }
        return false;
    }

    protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException e, ProgressMonitor monitor) throws OsmTransferException {
        if (!e.isKnownPrimitive()) {
            throw e;
        }
        OsmPrimitive p = this.layer.data.getPrimitiveById(e.getPrimitiveId(), e.getPrimitiveType());
        if (p == null) {
            throw e;
        }
        if (p.isDeleted()) {
            System.out.println(I18n.tr("Warning: object ''{0}'' is already deleted on the server. Skipping this object and retrying to upload.", p.getDisplayName(DefaultNameFormatter.getInstance())));
            monitor.appendLogMessage(I18n.tr("Object ''{0}'' is already deleted. Skipping object in upload.", p.getDisplayName(DefaultNameFormatter.getInstance())));
            this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
            this.processedPrimitives.add(p);
            this.toUpload.removeProcessed(this.processedPrimitives);
            return;
        }
        throw e;
    }

    protected void cleanupAfterUpload() {
        Runnable r = new Runnable(){

            public void run() {
                UploadPrimitivesTask.this.layer.cleanupAfterUpload(UploadPrimitivesTask.this.processedPrimitives);
                UploadPrimitivesTask.this.layer.onPostUploadToServer();
                ChangesetCache.getInstance().update(UploadPrimitivesTask.this.changeset);
            }
        };
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException e) {
            this.lastException = e;
        }
        catch (InvocationTargetException e) {
            this.lastException = new OsmTransferException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void realRun() throws SAXException, IOException {
        try {
            block33: while (true) {
                try {
                    this.getProgressMonitor().subTask(I18n.trn("Uploading {0} object...", "Uploading {0} objects...", this.toUpload.getSize(), this.toUpload.getSize()));
                    UploadPrimitivesTask uploadPrimitivesTask = this;
                    synchronized (uploadPrimitivesTask) {
                        this.writer = new OsmServerWriter();
                    }
                    this.writer.uploadOsm(this.strategy, this.toUpload.getPrimitives(), this.changeset, this.getProgressMonitor().createSubTaskMonitor(1, false));
                }
                catch (OsmTransferCancelledException e) {
                    e.printStackTrace();
                    this.uploadCancelled = true;
                }
                catch (OsmApiPrimitiveGoneException e) {
                    this.recoverFromGoneOnServer(e, this.getProgressMonitor());
                    continue;
                }
                catch (ChangesetClosedException e) {
                    this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    this.changeset.setOpen(false);
                    switch (e.getSource()) {
                        case UNSPECIFIED: {
                            throw e;
                        }
                        case UPDATE_CHANGESET: {
                            throw e;
                        }
                        case UPLOAD_DATA: {
                            if (this.recoverFromChangesetFullException()) break;
                            this.lastException = e;
                            break block33;
                        }
                    }
                    continue;
                }
                finally {
                    if (this.writer != null) {
                        this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                    }
                    UploadPrimitivesTask uploadPrimitivesTask = this;
                    synchronized (uploadPrimitivesTask) {
                        this.writer = null;
                    }
                    continue;
                }
                break;
            }
            if (this.strategy.isCloseChangesetAfterUpload() && this.changeset != null && !this.changeset.isNew() && this.changeset.isOpen()) {
                OsmApi.getOsmApi().closeChangeset(this.changeset, this.progressMonitor.createSubTaskMonitor(0, false));
            }
        }
        catch (Exception e) {
            if (this.uploadCancelled) {
                System.out.println(I18n.tr("Ignoring caught exception because upload is canceled. Exception is: {0}", e.toString()));
            }
            this.lastException = e;
        }
        if (this.uploadCancelled && this.processedPrimitives.isEmpty()) {
            return;
        }
        this.cleanupAfterUpload();
    }

    protected void finish() {
        if (this.uploadCancelled) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                ChangesetCache.getInstance().update(UploadPrimitivesTask.this.changeset);
                if (UploadPrimitivesTask.this.changeset != null && UploadPrimitivesTask.this.changeset.isOpen()) {
                    UploadDialog.getUploadDialog().setSelectedChangesetForNextUpload(UploadPrimitivesTask.this.changeset);
                }
                if (UploadPrimitivesTask.this.lastException == null) {
                    return;
                }
                if (UploadPrimitivesTask.this.lastException instanceof ChangesetClosedException) {
                    ChangesetClosedException e = (ChangesetClosedException)UploadPrimitivesTask.this.lastException;
                    if (e.getSource().equals((Object)ChangesetClosedException.Source.UPDATE_CHANGESET)) {
                        UploadPrimitivesTask.this.handleFailedUpload(UploadPrimitivesTask.this.lastException);
                        return;
                    }
                    if (UploadPrimitivesTask.this.strategy.getPolicy() == null) {
                        return;
                    }
                    if (e.getSource().equals((Object)ChangesetClosedException.Source.UPLOAD_DATA)) {
                        switch (UploadPrimitivesTask.this.strategy.getPolicy()) {
                            case ABORT: {
                                break;
                            }
                            case AUTOMATICALLY_OPEN_NEW_CHANGESETS: {
                                break;
                            }
                            case FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG: {
                                UploadPrimitivesTask.this.toUpload.removeProcessed(UploadPrimitivesTask.this.processedPrimitives);
                                UploadDialog.getUploadDialog().setUploadedPrimitives(UploadPrimitivesTask.this.toUpload);
                                UploadDialog.getUploadDialog().setVisible(true);
                            }
                        }
                    } else {
                        UploadPrimitivesTask.this.handleFailedUpload(UploadPrimitivesTask.this.lastException);
                    }
                } else {
                    UploadPrimitivesTask.this.handleFailedUpload(UploadPrimitivesTask.this.lastException);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.uploadCancelled = true;
        UploadPrimitivesTask uploadPrimitivesTask = this;
        synchronized (uploadPrimitivesTask) {
            if (this.writer != null) {
                this.writer.cancel();
            }
        }
    }
}

