/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VersionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Logger logger = Logger.getLogger(VersionTableCellRenderer.class.getName());
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_IS_REFERENCE_POINT = new Color(255, 197, 197);
    protected HashMap<OsmPrimitiveType, ImageIcon> icons = null;

    public VersionTableCellRenderer() {
        this.loadIcons();
        this.setOpaque(true);
    }

    protected void loadIcons() {
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderIcon(OsmPrimitiveType type) {
        ImageIcon icon = type == null ? null : this.icons.get((Object)type);
        this.setIcon(icon);
    }

    protected void renderText(HistoryOsmPrimitive primitive) {
        StringBuilder sb = new StringBuilder();
        if (primitive == null) {
            sb.append("");
        } else {
            String msg = I18n.tr("Version {0}, {1} (by {2})", Long.toString(primitive.getVersion()), new SimpleDateFormat().format(primitive.getTimestamp()), primitive.getUser());
            sb.append(msg);
        }
        this.setText(sb.toString());
        sb = new StringBuilder();
        if (primitive == null) {
            sb.append("");
        } else {
            sb.append(I18n.tr("Version {0} created on {1} by {2}", Long.toString(primitive.getVersion()), new SimpleDateFormat().format(primitive.getTimestamp()), primitive.getUser()));
        }
        this.setToolTipText(sb.toString());
    }

    protected OsmDataLayer getEditLayer() {
        try {
            return Main.map.mapView.getEditLayer();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected void renderLatestText(OsmPrimitive primitive) {
        StringBuffer sb = new StringBuffer();
        if (primitive == null) {
            this.setText("");
            return;
        }
        if (primitive.isModified()) {
            sb.append("*");
        }
        sb.append(I18n.tr("Version {0} in editor", primitive.getVersion()));
        if (primitive.isDeleted()) {
            sb.append(I18n.tr("[deleted]"));
        }
        this.setText(sb.toString());
        sb = new StringBuffer();
        OsmDataLayer l = this.getEditLayer();
        sb.append(I18n.tr("Version {0} currently edited in data layer ''{1}''", primitive.getId(), l == null ? I18n.tr("unknown") : l.getName()));
        this.setToolTipText(sb.toString());
    }

    protected void renderBackground(JTable table, int row, boolean isSelected) {
        Color bgColor = Color.WHITE;
        if (isSelected) {
            bgColor = BGCOLOR_SELECTED;
        } else if (this.getModel(table).isReferencePointInTime(row)) {
            bgColor = BGCOLOR_IS_REFERENCE_POINT;
        }
        this.setBackground(bgColor);
    }

    public void renderVersionFromHistory(HistoryOsmPrimitive primitive, JTable table, int row, boolean isSelected) {
        this.renderIcon(primitive == null ? null : primitive.getType());
        this.renderText(primitive);
        this.renderBackground(table, row, isSelected);
    }

    public void renderLatest(OsmPrimitive primitive, JTable table, int row, boolean isSelected) {
        this.renderIcon(primitive.getType());
        this.renderLatestText(this.getModel(table).getLatest());
        this.renderBackground(table, row, isSelected);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.getModel(table).isLatest(row)) {
            this.renderLatest(this.getModel(table).getLatest(), table, row, isSelected);
        } else {
            this.renderVersionFromHistory((HistoryOsmPrimitive)value, table, row, isSelected);
        }
        return this;
    }

    protected HistoryBrowserModel.VersionTableModel getModel(JTable table) {
        return (HistoryBrowserModel.VersionTableModel)table.getModel();
    }
}

