/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openstreetmap.josm.gui.MultiSplitLayout;
import org.openstreetmap.josm.gui.MultiSplitPane;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogsPanel
extends JPanel {
    protected List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    protected MultiSplitPane mSpltPane = new MultiSplitPane();
    protected final int DIVIDER_SIZE = 5;
    private List<JPanel> panels = new ArrayList<JPanel>();
    private final JSplitPane parent;
    public boolean initialized = false;

    public DialogsPanel(JSplitPane parent) {
        this.parent = parent;
    }

    public void initialize(List<ToggleDialog> pAllDialogs) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.initialized = true;
        this.allDialogs = new ArrayList<ToggleDialog>();
        for (ToggleDialog dialog : pAllDialogs) {
            this.add(dialog, false);
        }
        this.add(this.mSpltPane);
        this.reconstruct(Action.ELEMENT_SHRINKS, null);
    }

    public void add(ToggleDialog dlg) {
        this.add(dlg, true);
    }

    public void add(ToggleDialog dlg, boolean doReconstruct) {
        this.allDialogs.add(dlg);
        int i = this.allDialogs.size() - 1;
        dlg.setDialogsPanel(this);
        dlg.setVisible(false);
        JPanel p = new JPanel(){

            public Dimension getMinimumSize() {
                return new Dimension(0, 40);
            }
        };
        p.setLayout(new BoxLayout(p, 1));
        p.setVisible(false);
        this.mSpltPane.add((Component)p, "L" + i);
        this.panels.add(p);
        if (dlg.isDialogShowing()) {
            dlg.showDialog();
            if (dlg.isDialogInCollapsedView()) {
                dlg.isCollapsed = false;
                dlg.collapse();
            }
            if (doReconstruct) {
                this.reconstruct(Action.INVISIBLE_TO_DEFAULT, dlg);
            }
            dlg.showNotify();
        } else {
            dlg.hideDialog();
        }
    }

    public void reconstruct(Action action, ToggleDialog triggeredBy) {
        int N = this.allDialogs.size();
        for (JPanel p : this.panels) {
            p.removeAll();
            p.setVisible(false);
        }
        JPanel p = this.panels.get(N - 1);
        int k = -1;
        for (int i = N - 1; i >= 0; --i) {
            ToggleDialog dlg = this.allDialogs.get(i);
            if (dlg.isDialogInDefaultView()) {
                if (k == -1) {
                    k = N - 1;
                } else {
                    p = this.panels.get(--k);
                }
                p.add((Component)dlg, 0);
                p.setVisible(true);
                continue;
            }
            if (!dlg.isDialogInCollapsedView()) continue;
            p.add((Component)dlg, 0);
            p.setVisible(true);
        }
        if (k == -1) {
            k = N - 1;
        }
        int numPanels = N - k;
        if (action == Action.ELEMENT_SHRINKS) {
            for (int i = 0; i < N; ++i) {
                ToggleDialog dlg = this.allDialogs.get(i);
                if (!dlg.isDialogInDefaultView()) continue;
                int ph = dlg.getPreferredHeight();
                int ah = dlg.getSize().height;
                dlg.setPreferredSize(new Dimension(Integer.MAX_VALUE, ah < 20 ? ph : ah));
            }
        } else {
            int hn;
            int he;
            int h0;
            int ha;
            ToggleDialog dlg;
            int i;
            if (triggeredBy == null) {
                throw new IllegalArgumentException();
            }
            int sumP = 0;
            int sumA = 0;
            int sumC = 0;
            for (ToggleDialog dlg2 : this.allDialogs) {
                if (dlg2.isDialogInDefaultView()) {
                    if (dlg2 == triggeredBy) continue;
                    sumP += dlg2.getPreferredHeight();
                    sumA += dlg2.getHeight();
                    continue;
                }
                if (!dlg2.isDialogInCollapsedView()) continue;
                sumC += dlg2.getHeight();
            }
            if (sumA == 0) {
                this.reconstruct(Action.ELEMENT_SHRINKS, null);
                return;
            }
            int H = this.mSpltPane.getMultiSplitLayout().getModel().getBounds().getSize().height;
            int s2 = H - (numPanels - 1) * 5 - sumC;
            int hp_trig = triggeredBy.getPreferredHeight();
            if (hp_trig <= 0) {
                throw new IllegalStateException();
            }
            int hn_trig = hp_trig * s2 / (hp_trig + sumP);
            triggeredBy.setPreferredSize(new Dimension(Integer.MAX_VALUE, hn_trig));
            int R = s2 - hn_trig;
            int D_m = 0;
            int D_p = 0;
            for (i = 0; i < N; ++i) {
                dlg = this.allDialogs.get(i);
                if (!dlg.isDialogInDefaultView() || dlg == triggeredBy) continue;
                ha = dlg.getSize().height;
                h0 = ha * R / sumA;
                he = dlg.getPreferredHeight() * s2 / (sumP + hp_trig);
                if (h0 < he) {
                    hn = Math.min(ha, he);
                    D_m += hn - h0;
                    continue;
                }
                D_p += h0 - he;
            }
            for (i = 0; i < N; ++i) {
                int d;
                dlg = this.allDialogs.get(i);
                if (!dlg.isDialogInDefaultView() || dlg == triggeredBy) continue;
                ha = dlg.getHeight();
                h0 = ha * R / sumA;
                if (h0 < (he = dlg.getPreferredHeight() * s2 / (sumP + hp_trig))) {
                    hn = Math.min(ha, he);
                    dlg.setPreferredSize(new Dimension(Integer.MAX_VALUE, hn));
                    continue;
                }
                try {
                    d = (h0 - he) * D_m / D_p;
                }
                catch (ArithmeticException e) {
                    d = 0;
                }
                dlg.setPreferredSize(new Dimension(Integer.MAX_VALUE, h0 - d));
            }
        }
        ArrayList<MultiSplitLayout.Node> ch = new ArrayList<MultiSplitLayout.Node>();
        for (int i = k; i <= N - 1; ++i) {
            if (i != k) {
                ch.add(new MultiSplitLayout.Divider());
            }
            MultiSplitLayout.Leaf l = new MultiSplitLayout.Leaf("L" + i);
            l.setWeight(1.0 / (double)numPanels);
            ch.add(l);
        }
        if (numPanels == 1) {
            MultiSplitLayout.Node model = (MultiSplitLayout.Node)ch.get(0);
            this.mSpltPane.getMultiSplitLayout().setModel(model);
        } else {
            MultiSplitLayout.Split model = new MultiSplitLayout.Split();
            model.setRowLayout(false);
            model.setChildren(ch);
            this.mSpltPane.getMultiSplitLayout().setModel(model);
        }
        this.mSpltPane.getMultiSplitLayout().setDividerSize(5);
        this.mSpltPane.getMultiSplitLayout().setFloatingDividers(true);
        this.mSpltPane.revalidate();
        if (numPanels == 1 && this.panels.get(N - 1).getComponents().length == 0) {
            this.parent.setDividerSize(0);
            this.setVisible(false);
        } else {
            if (this.getWidth() != 0) {
                this.setPreferredSize(new Dimension(this.getWidth(), 0));
            }
            this.setVisible(true);
            this.parent.setDividerSize(5);
            this.parent.resetToPreferredSizes();
        }
    }

    public void destroy() {
        for (ToggleDialog t : this.allDialogs) {
            t.destroy();
        }
    }

    public <T> T getToggleDialog(Class<T> type) {
        for (ToggleDialog td : this.allDialogs) {
            if (!type.isInstance(td)) continue;
            return type.cast(td);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        INVISIBLE_TO_DEFAULT,
        COLLAPSED_TO_DEFAULT,
        ELEMENT_SHRINKS;

    }
}

