/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = TagConflictResolverModel.class.getName() + ".numConflicts";
    private TagCollection tags;
    private List<String> displayedKeys;
    private Set<String> keysWithConflicts;
    private HashMap<String, MultiValueResolutionDecision> decisions;
    private int numConflicts = 0;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean showTagsWithConflictsOnly = false;
    private boolean showTagsWithMultiValuesOnly = false;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected void setNumConflicts(int numConflicts) {
        int oldValue = this.numConflicts;
        this.numConflicts = numConflicts;
        if (oldValue != this.numConflicts) {
            this.support.firePropertyChange(NUM_CONFLICTS_PROP, oldValue, this.numConflicts);
        }
    }

    protected void refreshNumConflicts() {
        int count = 0;
        for (MultiValueResolutionDecision d : this.decisions.values()) {
            if (d.isDecided()) continue;
            ++count;
        }
        this.setNumConflicts(count);
    }

    protected void sort() {
        Collections.sort(this.displayedKeys, new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                if (((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(key1)).isDecided() && !((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(key2)).isDecided()) {
                    return 1;
                }
                if (!((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(key1)).isDecided() && ((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(key2)).isDecided()) {
                    return -1;
                }
                return key1.compareTo(key2);
            }
        });
    }

    protected void rebuild() {
        if (this.tags == null) {
            return;
        }
        for (String key : this.tags.getKeys()) {
            MultiValueResolutionDecision decision = new MultiValueResolutionDecision(this.tags.getTagsFor(key));
            if (this.decisions.get(key) != null) continue;
            this.decisions.put(key, decision);
        }
        this.displayedKeys.clear();
        Set<String> keys = this.tags.getKeys();
        if (this.showTagsWithConflictsOnly) {
            keys.retainAll(this.keysWithConflicts);
            if (this.showTagsWithMultiValuesOnly) {
                HashSet<String> keysWithMultiValues = new HashSet<String>();
                for (String key : keys) {
                    if (!this.decisions.get(key).canKeepAll()) continue;
                    keysWithMultiValues.add(key);
                }
                keys.retainAll(keysWithMultiValues);
            }
            for (String key : this.tags.getKeys()) {
                if (this.decisions.get(key).isDecided() || keys.contains(key)) continue;
                keys.add(key);
            }
        }
        this.displayedKeys.addAll(keys);
        this.refreshNumConflicts();
        this.sort();
        this.fireTableDataChanged();
    }

    public void populate(TagCollection tags, Set<String> keysWithConflicts) {
        CheckParameterUtil.ensureParameterNotNull(tags, "tags");
        this.tags = tags;
        this.displayedKeys = new ArrayList<String>();
        this.keysWithConflicts = keysWithConflicts == null ? new HashSet() : keysWithConflicts;
        this.decisions = new HashMap();
        this.rebuild();
    }

    @Override
    public int getRowCount() {
        if (this.displayedKeys == null) {
            return 0;
        }
        return this.displayedKeys.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.decisions.get(this.displayedKeys.get(row));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        MultiValueResolutionDecision decision = this.decisions.get(this.displayedKeys.get(row));
        if (value instanceof String) {
            decision.keepOne((String)value);
        } else if (value instanceof MultiValueDecisionType) {
            MultiValueDecisionType type = (MultiValueDecisionType)((Object)value);
            switch (type) {
                case KEEP_NONE: {
                    decision.keepNone();
                    break;
                }
                case KEEP_ALL: {
                    decision.keepAll();
                }
            }
        }
        this.fireTableDataChanged();
        this.refreshNumConflicts();
    }

    public boolean isResolvedCompletely() {
        return this.numConflicts == 0;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    public int getNumDecisions() {
        return this.getRowCount();
    }

    public TagCollection getResolution() {
        TagCollection tc = new TagCollection();
        for (String key : this.displayedKeys) {
            tc.add(this.decisions.get(key).getResolution());
        }
        return tc;
    }

    public TagCollection getAllResolutions() {
        TagCollection tc = new TagCollection();
        for (MultiValueResolutionDecision value : this.decisions.values()) {
            tc.add(value.getResolution());
        }
        return tc;
    }

    public MultiValueResolutionDecision getDecision(int row) {
        return this.decisions.get(this.displayedKeys.get(row));
    }

    public void setShowTagsWithConflictsOnly(boolean showTagsWithConflictsOnly) {
        this.showTagsWithConflictsOnly = showTagsWithConflictsOnly;
        this.rebuild();
    }

    public void setShowTagsWithMultiValuesOnly(boolean showTagsWithMultiValuesOnly) {
        this.showTagsWithMultiValuesOnly = showTagsWithMultiValuesOnly;
        this.rebuild();
    }

    public void prepareDefaultTagDecisions() {
        for (MultiValueResolutionDecision decision : this.decisions.values()) {
            List<String> values = decision.getValues();
            values.remove("");
            if (values.size() == 1) {
                decision.keepOne(values.get(0));
                continue;
            }
            decision.keepAll();
        }
        this.rebuild();
    }
}

